/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.web;

import com.atlassian.fisheye.web.NetworkLocation;
import junit.framework.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class NetworkLocationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testStringContainingOnlyNumber() throws Exception {
        NetworkLocation location = new NetworkLocation("8000");
        Assert.assertEquals((String)"0.0.0.0", (String)location.getHost());
        Assert.assertNull((Object)location.getInetAddress());
        Assert.assertEquals((int)8000, (int)location.getPort());
        Assert.assertEquals((String)"0.0.0.0:8000", (String)location.toString());
    }

    @Test
    public void testStringContainingColonAndNumber() throws Exception {
        NetworkLocation location = new NetworkLocation(":8000");
        Assert.assertEquals((String)"0.0.0.0", (String)location.getHost());
        Assert.assertNull((Object)location.getInetAddress());
        Assert.assertEquals((int)8000, (int)location.getPort());
        Assert.assertEquals((String)"0.0.0.0:8000", (String)location.toString());
    }

    @Test
    public void testStringContainingExampleDotCom() throws Exception {
        NetworkLocation location = new NetworkLocation("example.com:8000");
        Assert.assertEquals((String)"example.com", (String)location.getHost());
        Assert.assertNotNull((Object)location.getInetAddress());
        Assert.assertEquals((int)8000, (int)location.getPort());
        Assert.assertEquals((String)"example.com:8000", (String)location.toString());
    }

    @Test
    public void testStringContainingIpAndPort() throws Exception {
        NetworkLocation location = new NetworkLocation("1.2.3.4:12000");
        Assert.assertEquals((String)"1.2.3.4", (String)location.getHost());
        Assert.assertNotNull((Object)location.getInetAddress());
        Assert.assertEquals((int)12000, (int)location.getPort());
        Assert.assertEquals((String)"1.2.3.4:12000", (String)location.toString());
    }

    @Test
    public void testZeroAddressAndPort() throws Exception {
        NetworkLocation location = new NetworkLocation("0.0.0.0:0");
        Assert.assertEquals((String)"0.0.0.0", (String)location.getHost());
        Assert.assertEquals((int)0, (int)location.getPort());
        Assert.assertEquals((String)"0.0.0.0:0", (String)location.toString());
        Assert.assertTrue((boolean)location.isWildcard());
    }

    @Test
    public void testZeroAddress() throws Exception {
        this.exception.expect(NumberFormatException.class);
        new NetworkLocation("0.0.0.0");
    }

    @Test
    public void testZeroAddressWithColon() throws Exception {
        this.exception.expect(NumberFormatException.class);
        new NetworkLocation("0.0.0.0:");
    }

    @Test
    public void testStringContainingNonNumericPort() throws Exception {
        this.exception.expect(NumberFormatException.class);
        new NetworkLocation("abcdef");
    }

    @Test
    public void testStringContainingNegativePort() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        new NetworkLocation("-1");
    }

    @Test
    public void testStringContainingZeroPort() throws Exception {
        new NetworkLocation("0");
    }

    @Test
    public void testStringContainingMaxPort() throws Exception {
        new NetworkLocation("65535");
    }

    @Test
    public void testStringContainingTooBigPort() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        new NetworkLocation("65536");
    }
}

