/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.web;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.web.NavBuilder;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.PermaIdFormatException;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.util.DummyReviewManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.admin.actions.jira.DummyProjectManager;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.mockito.Mockito;

public class NavBuilderTest
extends TestCase {
    private HttpServletRequest request;
    private RootConfig oldRootConfig;

    public void setUp() throws Exception {
        super.setUp();
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.oldRootConfig = AppConfig.getsConfig();
        RootConfig c = new RootConfig();
        c.setConfig((ConfigDocument)Mockito.mock(ConfigDocument.class));
        AppConfig.resetConfig((RootConfig)c);
        Mockito.when((Object)this.request.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)this.request.getServerName()).thenReturn((Object)"atlassian.com");
        Mockito.when((Object)this.request.getServerPort()).thenReturn((Object)1234);
        Mockito.when((Object)this.request.getContextPath()).thenReturn((Object)"/path");
    }

    public void tearDown() throws Exception {
        AppConfig.resetConfig((RootConfig)this.oldRootConfig);
    }

    public void testChangesetLink() throws Exception {
        NavBuilderTest.assertEquals((String)"changelog/REPOSITORY?cs=a31558567f18", (String)NavBuilder.changeset((String)"REPOSITORY", (String)"a31558567f18"));
        NavBuilderTest.assertEquals((String)"/path/changelog/REPOSITORY?cs=a31558567f18", (String)NavBuilder.changeset((HttpServletRequest)this.request, (String)"REPOSITORY", (String)"a31558567f18"));
        NavBuilderTest.assertEquals((String)"http://atlassian.com:1234/path/changelog/REPOSITORY?cs=a31558567f18", (String)NavBuilder.changesetAbs((HttpServletRequest)this.request, (String)"REPOSITORY", (String)"a31558567f18"));
    }

    public void testChangesetCommentLink() throws Exception {
        NavBuilderTest.assertEquals((String)"changelog/REPOSITORY?cs=a31558567f18#c4301", (String)NavBuilder.changesetComment((String)"REPOSITORY", (String)"a31558567f18", (int)4301));
        NavBuilderTest.assertEquals((String)"/path/changelog/REPOSITORY?cs=a31558567f18#c4301", (String)NavBuilder.changesetComment((HttpServletRequest)this.request, (String)"REPOSITORY", (String)"a31558567f18", (int)4301));
        NavBuilderTest.assertEquals((String)"http://atlassian.com:1234/path/changelog/REPOSITORY?cs=a31558567f18#c4301", (String)NavBuilder.changesetCommentAbs((HttpServletRequest)this.request, (String)"REPOSITORY", (String)"a31558567f18", (int)4301));
    }

    public void testChangesetDiscussionLink() throws Exception {
        NavBuilderTest.assertEquals((String)"changelog/REPOSITORY?cs=a31558567f18#c0", (String)NavBuilder.changesetDiscussion((String)"REPOSITORY", (String)"a31558567f18"));
        NavBuilderTest.assertEquals((String)"/path/changelog/REPOSITORY?cs=a31558567f18#c0", (String)NavBuilder.changesetDiscussion((HttpServletRequest)this.request, (String)"REPOSITORY", (String)"a31558567f18"));
        NavBuilderTest.assertEquals((String)"http://atlassian.com:1234/path/changelog/REPOSITORY?cs=a31558567f18#c0", (String)NavBuilder.changesetDiscussionAbs((HttpServletRequest)this.request, (String)"REPOSITORY", (String)"a31558567f18"));
    }

    public void testChangelogLink() throws Exception {
        NavBuilderTest.assertEquals((String)"changelog/REPOSITORY", (String)NavBuilder.changelog((String)"REPOSITORY"));
        NavBuilderTest.assertEquals((String)"changelog/~br=myBranch/REPOSITORY", (String)NavBuilder.changelog((String)"REPOSITORY", (String)"myBranch"));
        NavBuilderTest.assertEquals((String)"/path/changelog/REPOSITORY", (String)NavBuilder.changelog((HttpServletRequest)this.request, (String)"REPOSITORY"));
        NavBuilderTest.assertEquals((String)"http://atlassian.com:1234/path/changelog/REPOSITORY", (String)NavBuilder.changelogAbs((HttpServletRequest)this.request, (String)"REPOSITORY"));
        NavBuilderTest.assertEquals((String)"http://atlassian.com:1234/path/changelog/~br=myBranch/REPOSITORY", (String)NavBuilder.changelogAbs((HttpServletRequest)this.request, (String)"REPOSITORY", (String)"myBranch"));
    }

    public void testChangelogLinkAtPath() throws Exception {
        NavBuilderTest.assertEquals((String)"/path/changelog/repo%3F%2Fo", (String)NavBuilder.changelogAtPath((HttpServletRequest)this.request, (String)"repo?/o", null));
        NavBuilderTest.assertEquals((String)"/path/changelog/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt", (String)NavBuilder.changelogAtPath((HttpServletRequest)this.request, (String)"repo?/o", (String)"p?ath<tag>/fil&=e.txt"));
        NavBuilderTest.assertEquals((String)"/path/changelog/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt", (String)NavBuilder.changelogAtPath((HttpServletRequest)this.request, (String)"repo?/o", (String)"p?ath<tag>/fil&=e.txt"));
        NavBuilderTest.assertEquals((String)"/path/changelog/repo%3F%2Fo", (String)NavBuilder.changelogAtPath((HttpServletRequest)this.request, (String)"repo?/o", null));
    }

    public void testChangelogAtChangesetLink() throws Exception {
        NavBuilderTest.assertEquals((String)"/path/changelog/REPOSITORY?showid=1234&view=fe", (String)NavBuilder.changelogAtChangeset((HttpServletRequest)this.request, (String)"REPOSITORY", (String)"1234"));
        NavBuilderTest.assertEquals((String)"/path/changelog/%3Cscript%3Ealert%28%27xss%27%29%3C%2Fscript%3E?showid=%3Cscript%3Ealert%28%27xss%27%29%3C%2Fscript%3E&view=fe", (String)NavBuilder.changelogAtChangeset((HttpServletRequest)this.request, (String)"<script>alert('xss')</script>", (String)"<script>alert('xss')</script>"));
    }

    public void testGraphLink() throws Exception {
        NavBuilderTest.assertEquals((String)"graph/REPOSITORY", (String)NavBuilder.graph((String)"REPOSITORY"));
        NavBuilderTest.assertEquals((String)"graph/%3Cscript%3Ealert%28%27xss%27%29%3C%2Fscript%3E", (String)NavBuilder.graph((String)"<script>alert('xss')</script>"));
        NavBuilderTest.assertEquals((String)"/path/graph/REPOSITORY", (String)NavBuilder.graph((HttpServletRequest)this.request, (String)"REPOSITORY"));
        NavBuilderTest.assertEquals((String)"/path/graph/%3Cscript%3Ealert%28%27xss%27%29%3C%2Fscript%3E", (String)NavBuilder.graph((HttpServletRequest)this.request, (String)"<script>alert('xss')</script>"));
    }

    public void testGraphAtChangesetLink() throws Exception {
        NavBuilderTest.assertEquals((String)"graph/REPOSITORY?csid=8082cb70308f", (String)NavBuilder.graphAtChangeset((String)"REPOSITORY", (String)"8082cb70308f"));
        NavBuilderTest.assertEquals((String)"/path/graph/REPOSITORY?csid=8082cb70308f", (String)NavBuilder.graphAtChangeset((HttpServletRequest)this.request, (String)"REPOSITORY", (String)"8082cb70308f"));
        NavBuilderTest.assertEquals((String)"graph/%3Cscript%3Ealert%28%27xss%27%29%3C%2Fscript%3E?csid=%3Cscript%3Ealert%28%27xss%27%29%3C%2Fscript%3E", (String)NavBuilder.graphAtChangeset((String)"<script>alert('xss')</script>", (String)"<script>alert('xss')</script>"));
        NavBuilderTest.assertEquals((String)"/path/graph/%3Cscript%3Ealert%28%27xss%27%29%3C%2Fscript%3E?csid=%3Cscript%3Ealert%28%27xss%27%29%3C%2Fscript%3E", (String)NavBuilder.graphAtChangeset((HttpServletRequest)this.request, (String)"<script>alert('xss')</script>", (String)"<script>alert('xss')</script>"));
    }

    public void testNastyBranchLink() throws Exception {
        NavBuilderTest.assertEquals((String)"/path/changelog/~br=some%3Fnasty%403dbranch%402furghh/repo%3F%2Fo", (String)NavBuilder.branch((HttpServletRequest)this.request, (String)"repo?/o", (String)"some?nasty=branch/urghh"));
        NavBuilderTest.assertEquals((String)"http://atlassian.com:1234/path/changelog/~br=some%3Fnasty%403dbranch%402furghh/repo%3F%2Fo", (String)NavBuilder.branchAbs((HttpServletRequest)this.request, (String)"repo?/o", (String)"some?nasty=branch/urghh"));
    }

    public void testReviewLink() throws Exception {
        DummyReviewManager reviewManager = new DummyReviewManager(){

            @Override
            public Review getReviewByPermaId(final String permaId) throws PermaIdFormatException {
                return new Review(){

                    public String getPermaId() {
                        return permaId;
                    }
                };
            }
        };
        Review review = reviewManager.getReviewByPermaId("CR-1");
        NavBuilderTest.assertEquals((String)"cru/CR-1", (String)NavBuilder.review((Review)review));
        NavBuilderTest.assertEquals((String)"/path/cru/CR-1", (String)NavBuilder.review((HttpServletRequest)this.request, (Review)review));
        NavBuilderTest.assertEquals((String)"http://atlassian.com:1234/path/cru/CR-1", (String)NavBuilder.reviewAbs((HttpServletRequest)this.request, (Review)review));
        Review snippet = reviewManager.getReviewByPermaId("CR-2");
        snippet.setType(Review.ReviewType.SNIPPET);
        NavBuilderTest.assertEquals((String)"snippet/CR-2", (String)NavBuilder.review((Review)snippet));
        NavBuilderTest.assertEquals((String)"/path/snippet/CR-2", (String)NavBuilder.review((HttpServletRequest)this.request, (Review)snippet));
        NavBuilderTest.assertEquals((String)"http://atlassian.com:1234/path/snippet/CR-2", (String)NavBuilder.reviewAbs((HttpServletRequest)this.request, (Review)snippet));
    }

    public void testReviewCommentLink() {
        Comment reviewComment = new Comment(){

            public Integer getId() {
                return 12345;
            }

            public Review getReview() {
                return new Review(){

                    public String getPermaId() {
                        return "CR-123";
                    }
                };
            }
        };
        NavBuilderTest.assertEquals((String)"cru/CR-123#c12345", (String)NavBuilder.reviewComment((Comment)reviewComment));
        NavBuilderTest.assertEquals((String)"/path/cru/CR-123#c12345", (String)NavBuilder.reviewComment((HttpServletRequest)this.request, (Comment)reviewComment));
    }

    public void testReviewFileLink() {
        FileRevisionExtraInfo reviewFile = new FileRevisionExtraInfo(){

            public Integer getId() {
                return 12345;
            }

            public Review getReview() {
                return new Review(){

                    public String getPermaId() {
                        return "CR-123";
                    }
                };
            }
        };
        NavBuilderTest.assertEquals((String)"cru/CR-123#CFR-12345", (String)NavBuilder.reviewFile((FileRevisionExtraInfo)reviewFile));
    }

    public void testReviewGeneralCommentsLink() {
        Review r = new Review(){

            public String getPermaId() {
                return "CR-123";
            }
        };
        NavBuilderTest.assertEquals((String)"cru/CR-123#general-comments", (String)NavBuilder.reviewGeneralComments((Review)r));
    }

    public void testCreateReviewLink() throws Exception {
        NavBuilderTest.assertEquals((String)"/path/cru/create?csid=%2F%2FFE-hg%2F12345", (String)NavBuilder.createReview((HttpServletRequest)this.request, (String)"FE-hg", (String)"12345"));
        NavBuilderTest.assertEquals((String)"/path/cru/create?csid=%2F%2F%3Cscript%3Ealert%28%27FE-hg%27%29%3C%2Fscript%3E%2F%3Cscript%3Ealert%28%27xss%27%29%3C%2Fscript%3E", (String)NavBuilder.createReview((HttpServletRequest)this.request, (String)"<script>alert('FE-hg')</script>", (String)"<script>alert('xss')</script>"));
        NavBuilderTest.assertEquals((String)"http://atlassian.com:1234/path/cru/create?csid=%2F%2Frepo1%2Fcsid123", (String)NavBuilder.createReviewAbs((HttpServletRequest)this.request, (String)"repo1", (String)"csid123"));
    }

    public void testUserLink() throws Exception {
        NavBuilderTest.assertEquals((String)"user/seb", (String)NavBuilder.user((String)"seb"));
        NavBuilderTest.assertEquals((String)"user/%3Cscript%3Ealert%28%27xss%27%29%3C%2Fscript%3E", (String)NavBuilder.user((String)"<script>alert('xss')</script>"));
        NavBuilderTest.assertEquals((String)"/path/user/seb", (String)NavBuilder.user((HttpServletRequest)this.request, (String)"seb"));
        NavBuilderTest.assertEquals((String)"http://atlassian.com:1234/path/user/seb", (String)NavBuilder.userAbs((HttpServletRequest)this.request, (String)"seb"));
        FecruUser user = new FecruUser("seb");
        NavBuilderTest.assertEquals((String)"user/seb", (String)NavBuilder.user((FecruUser)user));
        NavBuilderTest.assertEquals((String)"/path/user/seb", (String)NavBuilder.user((HttpServletRequest)this.request, (FecruUser)user));
    }

    public void testCommitterLink() throws Exception {
        NavBuilderTest.assertEquals((String)"committer/FE-hg/seb", (String)NavBuilder.committer((String)"FE-hg", (String)"seb"));
        NavBuilderTest.assertEquals((String)"/path/committer/FE-hg/seb", (String)NavBuilder.committer((HttpServletRequest)this.request, (String)"FE-hg", (String)"seb"));
        NavBuilderTest.assertEquals((String)"/path/committer/FE-hg/%3Cscript%3Ealert%28%27xss%27%29%3C%2Fscript%3E", (String)NavBuilder.committer((HttpServletRequest)this.request, (String)"FE-hg", (String)"<script>alert('xss')</script>"));
        NavBuilderTest.assertEquals((String)"/path/committer/repo%3F%2Fo/%3Cscript%3Ealert%28%27xss%27%29%3C%2Fscript%3E", (String)NavBuilder.committer((HttpServletRequest)this.request, (String)"repo?/o", (String)"<script>alert('xss')</script>"));
        NavBuilderTest.assertEquals((String)"http://atlassian.com:1234/path/committer/repo%3F%2Fo/%3Cscript%3Ealert%28%27xss%27%29%3C%2Fscript%3E", (String)NavBuilder.committerAbs((HttpServletRequest)this.request, (String)"repo?/o", (String)"<script>alert('xss')</script>"));
    }

    public void testProjectLink() throws Exception {
        DummyProjectManager projectManager = new DummyProjectManager(){

            @Override
            public Project getProjectByKey(String key) {
                Project p = new Project();
                p.setProjKey(key);
                return p;
            }
        };
        NavBuilderTest.assertEquals((String)"project/CR", (String)NavBuilder.project((String)"CR"));
        NavBuilderTest.assertEquals((String)"/path/project/CR", (String)NavBuilder.project((HttpServletRequest)this.request, (String)"CR"));
        NavBuilderTest.assertEquals((String)"http://atlassian.com:1234/path/project/CR", (String)NavBuilder.projectAbs((HttpServletRequest)this.request, (String)"CR"));
        Project p = projectManager.getProjectByKey("CR-FE");
        NavBuilderTest.assertEquals((String)"project/CR-FE", (String)NavBuilder.project((Project)p));
        NavBuilderTest.assertEquals((String)"/path/project/CR-FE", (String)NavBuilder.project((HttpServletRequest)this.request, (Project)p));
    }

    public void testBrowseWithBranch() {
        WaybackSpec wbSpec = new WaybackSpec();
        wbSpec.setBranch("oliver-area");
        NavBuilderTest.assertEquals((String)"browse/~br=oliver-area/checkstyle-svn/branches/oliver-area", (String)NavBuilder.browse((WaybackSpec)wbSpec, (String)"checkstyle-svn", (Path)new Path((CharSequence)"/branches/oliver-area/")));
    }

    public void testBrowsePath() throws Exception {
        NavBuilderTest.assertEquals((String)"browse/repo%3F%2Fo", (String)NavBuilder.browse(null, (String)"repo?/o", null));
        NavBuilderTest.assertEquals((String)"browse/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt", (String)NavBuilder.browse(null, (String)"repo?/o", (Path)new Path((CharSequence)"p?ath<tag>/fil&=e.txt")));
        NavBuilderTest.assertEquals((String)"/path/browse/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt", (String)NavBuilder.browse((HttpServletRequest)this.request, null, (String)"repo?/o", (Path)new Path((CharSequence)"p?ath<tag>/fil&=e.txt")));
        NavBuilderTest.assertEquals((String)"/path/browse/repo%3F%2Fo", (String)NavBuilder.browse((HttpServletRequest)this.request, null, (String)"repo?/o", null));
    }

    public void testBrowseRevision() throws Exception {
        NavBuilderTest.assertEquals((String)"/path/browse/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt#r1.3", (String)NavBuilder.browseRevision((HttpServletRequest)this.request, null, (String)"repo?/o", (Path)new Path((CharSequence)"p?ath<tag>/fil&=e.txt"), (String)"1.3"));
    }

    public void testBrowseSource() throws Exception {
        FileRevision revision = (FileRevision)Mockito.mock(FileRevision.class);
        Mockito.when((Object)revision.getPath()).thenReturn((Object)new Path((CharSequence)"p?ath<tag>/fil&=e.txt"));
        Mockito.when((Object)revision.getRevision()).thenReturn((Object)"r?evi&%sio=n");
        NavBuilderTest.assertEquals((String)"browse/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt?r=r%3Fevi%26%25sio%3Dn", (String)NavBuilder.browseSource(null, (String)"repo?/o", (FileRevision)revision));
        NavBuilderTest.assertEquals((String)"/path/browse/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt?r=r%3Fevi%26%25sio%3Dn", (String)NavBuilder.browseSource((HttpServletRequest)this.request, null, (String)"repo?/o", (FileRevision)revision));
        NavBuilderTest.assertEquals((String)"browse/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt?r=r%3Fevi%26%25sio%3Dn", (String)NavBuilder.browseSource(null, (String)"repo?/o", (Path)revision.getPath(), (String)revision.getRevision()));
        NavBuilderTest.assertEquals((String)"/path/browse/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt?r=r%3Fevi%26%25sio%3Dn", (String)NavBuilder.browseSource((HttpServletRequest)this.request, null, (String)"repo?/o", (Path)revision.getPath(), (String)revision.getRevision()));
        NavBuilderTest.assertEquals((String)"http://atlassian.com:1234/path/browse/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt?r=r%3Fevi%26%25sio%3Dn", (String)NavBuilder.browseSourceAbs((HttpServletRequest)this.request, null, (String)"repo?/o", (Path)revision.getPath(), (String)revision.getRevision()));
    }

    public void testFileHistory() throws Exception {
        FileRevision revision = (FileRevision)Mockito.mock(FileRevision.class);
        Mockito.when((Object)revision.getPath()).thenReturn((Object)new Path((CharSequence)"p?ath<tag>/fil&=e.txt"));
        Mockito.when((Object)revision.getRevision()).thenReturn((Object)"r?evi&%sio=n");
        WaybackSpec wbSpec = new WaybackSpec();
        wbSpec.setBranch("test-branch");
        NavBuilderTest.assertEquals((String)"browse/~br=test-branch/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt#rr%3Fevi%26%25sio%3Dn", (String)NavBuilder.fileHistory((WaybackSpec)wbSpec, (String)"repo?/o", (FileRevision)revision));
        NavBuilderTest.assertEquals((String)"/path/browse/~br=test-branch/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt#rr%3Fevi%26%25sio%3Dn", (String)NavBuilder.fileHistory((HttpServletRequest)this.request, (WaybackSpec)wbSpec, (String)"repo?/o", (FileRevision)revision));
        NavBuilderTest.assertEquals((String)"http://atlassian.com:1234/path/browse/~br=test-branch/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt#rr%3Fevi%26%25sio%3Dn", (String)NavBuilder.fileHistoryAbs((HttpServletRequest)this.request, (WaybackSpec)wbSpec, (String)"repo?/o", (FileRevision)revision));
    }

    public void testBrowseRawFile() throws Exception {
        Path path = new Path((CharSequence)"p?ath<tag>/fil&=e.txt");
        String revisionName = "r?evi&%sio=n";
        NavBuilderTest.assertEquals((String)"browse/~raw,r=r%3Fevi%26%25sio%3Dn/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt", (String)NavBuilder.browseRawFile((String)"repo?/o", (String)"r?evi&%sio=n", (Path)path));
        NavBuilderTest.assertEquals((String)"/path/browse/~raw,r=r%3Fevi%26%25sio%3Dn/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt", (String)NavBuilder.browseRawFile((HttpServletRequest)this.request, (String)"repo?/o", (String)"r?evi&%sio=n", (Path)path));
        FileRevision revision = (FileRevision)Mockito.mock(FileRevision.class);
        Mockito.when((Object)revision.getPath()).thenReturn((Object)path);
        Mockito.when((Object)revision.getRevision()).thenReturn((Object)"r?evi&%sio=n");
        NavBuilderTest.assertEquals((String)"browse/~raw,r=r%3Fevi%26%25sio%3Dn/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt", (String)NavBuilder.browseRawFile((String)"repo?/o", (FileRevision)revision));
        NavBuilderTest.assertEquals((String)"/path/browse/~raw,r=r%3Fevi%26%25sio%3Dn/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt", (String)NavBuilder.browseRawFile((HttpServletRequest)this.request, (String)"repo?/o", (FileRevision)revision));
    }

    public void testBrowseDiff() throws Exception {
        FileRevision revision = (FileRevision)Mockito.mock(FileRevision.class);
        Mockito.when((Object)revision.getPath()).thenReturn((Object)new Path((CharSequence)"p?ath<tag>/fil&=e.txt"));
        RevInfoKey diffReviInfoKey = (RevInfoKey)Mockito.mock(RevInfoKey.class);
        Mockito.when((Object)diffReviInfoKey.getRev()).thenReturn((Object)"diffR?evi&%sio=n");
        Mockito.when((Object)revision.getDiffRevision()).thenReturn((Object)diffReviInfoKey);
        Mockito.when((Object)revision.getRevision()).thenReturn((Object)"123456");
        NavBuilderTest.assertEquals((String)"browse/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt?r1=diffR%3Fevi%26%25sio%3Dn&r2=123456", (String)NavBuilder.browseDiff(null, (String)"repo?/o", (FileRevision)revision));
        NavBuilderTest.assertEquals((String)"/path/browse/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt?r1=diffR%3Fevi%26%25sio%3Dn&r2=123456", (String)NavBuilder.browseDiff((HttpServletRequest)this.request, null, (String)"repo?/o", (FileRevision)revision));
        NavBuilderTest.assertEquals((String)"/path/browse/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt?r2=123456", (String)NavBuilder.browseDiffToPrevious((HttpServletRequest)this.request, null, (String)"repo?/o", (Path)revision.getPath(), (String)revision.getRevision()));
        NavBuilderTest.assertEquals((String)"http://atlassian.com:1234/path/browse/repo%3F%2Fo/p%3Fath%3Ctag%3E/fil%26%3De.txt?r1=diffR%3Fevi%26%25sio%3Dn&r2=123456", (String)NavBuilder.browseDiffAbs((HttpServletRequest)this.request, null, (String)"repo?/o", (FileRevision)revision));
    }

    public void testRepository() throws Exception {
        Assert.assertThat((Object)NavBuilder.repository((HttpServletRequest)this.request, (String)"FE-hg"), (Matcher)IsEqual.equalTo((Object)"/path/browse/FE-hg"));
    }

    public void testQuickSearch() throws Exception {
        Assert.assertThat((Object)NavBuilder.quickSearch((HttpServletRequest)this.request, null, (String)"foobar"), (Matcher)IsEqual.equalTo((Object)"/path/qsearch?q=foobar"));
        Assert.assertThat((Object)NavBuilder.quickSearch((HttpServletRequest)this.request, (String)"FE-hg", (String)"foobar"), (Matcher)IsEqual.equalTo((Object)"/path/qsearch/FE-hg?q=foobar"));
        Assert.assertThat((Object)NavBuilder.quickSearch((HttpServletRequest)this.request, null, null), (Matcher)IsEqual.equalTo((Object)"/path/qsearch"));
    }
}

