/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.util;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.config.ConfigurationManager;
import junit.framework.TestCase;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class UseTestSpringContextTestCase
extends TestCase {
    private String myContextFile;
    private static final String STD_TEST_CONTEXT = "com/atlassian/fisheye/util/testApplicationContext.xml";

    public UseTestSpringContextTestCase() {
    }

    public UseTestSpringContextTestCase(String name) {
        super(name);
    }

    public UseTestSpringContextTestCase(String name, String myContextFile) {
        super(name);
        this.myContextFile = myContextFile;
    }

    protected void setUp() throws Exception {
        String[] contexts = this.myContextFile != null ? new String[]{STD_TEST_CONTEXT, this.myContextFile} : new String[]{STD_TEST_CONTEXT};
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(contexts);
        SpringContext.setApplicationContext((ApplicationContext)context);
    }

    protected void tearDown() throws Exception {
        HibernateUtil.forceRollbackTransaction();
        HibernateUtil.closeSession();
        int sessionCount = HibernateUtil.getSessionCount();
        if (sessionCount != 0) {
            String message = "Not all hibernate sessions were closed - " + sessionCount + " remain open";
            throw new IllegalStateException(message);
        }
        TestFishEyeInstances.stop();
        TestFishEyeInstances.checkCleanStart();
        if (SpringContext.isSetup()) {
            DisposableBean context = (DisposableBean)SpringContext.getApplicationContext();
            context.destroy();
        }
        SpringContext.setApplicationContext(null);
        ConfigurationManager.setConfiguration(null);
        ConfigurationManager.clearConfigurationProviders();
        ObjectFactory.setObjectFactory((ObjectFactory)new ObjectFactory(){});
    }
}

