/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.util;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.FileRevisionImpl;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.rep.impl.LineCountState;
import com.google.common.collect.Lists;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class MockTestFileRevision
extends FileRevisionImpl {
    private static int revIdGen = 0;
    private int revid;
    private String file;
    private String revision;
    private String author;
    private Date date;
    private String csid;
    private int linesAdded;
    private int linesRemoved;
    private int totalLines;
    private boolean binary = false;
    private boolean added = false;
    private boolean deleted = false;
    private boolean copied = false;
    private boolean moved = false;
    private List<String> tags;
    private List<Integer> reviews;
    private List<RevInfoKey> ancestors = Collections.emptyList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MockTestFileRevision(String file, String revision, String author, String date, String csid, int linesAdded, int linesRemoved, int totalLines) {
        this.file = file;
        this.revision = revision;
        this.author = author;
        try {
            this.date = new SimpleDateFormat("yyyy/MM/dd").parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        this.csid = csid;
        this.linesAdded = linesAdded;
        this.linesRemoved = linesRemoved;
        this.totalLines = totalLines;
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            this.revid = revIdGen++;
        }
    }

    public MockTestFileRevision tags(String ... tags) {
        this.tags = Lists.newArrayList((Object[])tags);
        return this;
    }

    public MockTestFileRevision reviews(Integer ... reviews) {
        this.reviews = Lists.newArrayList((Object[])reviews);
        return this;
    }

    public MockTestFileRevision binary() {
        this.binary = true;
        return this;
    }

    public MockTestFileRevision added() {
        this.added = true;
        return this;
    }

    public MockTestFileRevision deleted() {
        this.deleted = true;
        return this;
    }

    public MockTestFileRevision copied() {
        this.copied = true;
        return this;
    }

    public MockTestFileRevision moved() {
        this.moved = true;
        return this;
    }

    public String getRevision() {
        return this.revision;
    }

    public List<RevInfoKey> getAncestors() {
        return this.ancestors;
    }

    public void setAncestors(List<RevInfoKey> ancestors) {
        this.ancestors = ancestors;
    }

    public RevInfoKey getAncestorOnBranch() {
        return null;
    }

    public RevInfoKey getDiffRevision() {
        return null;
    }

    public AncestorLink getAncestorLink() {
        return null;
    }

    public Path getPath() {
        return new Path((CharSequence)this.file);
    }

    public String getChangeSetId() {
        return this.csid;
    }

    public String getComment() {
        return null;
    }

    public String getAuthor() {
        return this.author;
    }

    public long getDate() {
        return this.date.getTime();
    }

    public Date getDateValue() {
        return this.date;
    }

    public List<String> getBranchPoints() {
        return null;
    }

    public List<String> getTags() {
        if (this.tags == null) {
            return Collections.emptyList();
        }
        return this.tags;
    }

    public int getRevID() {
        return this.revid;
    }

    public String getBranch() {
        return null;
    }

    public boolean isTrunkLike() {
        return false;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isDead() {
        return this.deleted;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isCopy() {
        return this.copied;
    }

    public boolean isMove() {
        return this.moved;
    }

    public boolean isModify() {
        return !this.added && !this.deleted && !this.copied && !this.moved;
    }

    public int getLinesAdded() {
        return this.linesAdded;
    }

    public int getLinesRemoved() {
        return this.linesRemoved;
    }

    public LineCountState getLineCountState() {
        return LineCountState.FULL;
    }

    public int getLineCount() {
        return this.totalLines;
    }

    public RevInfoKey getRevInfoKey() {
        return new RevInfoKey(this.getPath(), this.csid);
    }

    public RevInfoKey getCopySource() {
        return null;
    }

    public List<RevInfoKey> getCopyDestinations() throws DbException {
        return null;
    }

    public RevInfoKey getMoveSource() {
        return null;
    }

    public RevInfoKey getMoveDestination() throws DbException {
        return null;
    }

    public int getFileType() {
        return 0;
    }

    public List<Integer> getReviewIds() {
        if (this.reviews == null) {
            return Collections.emptyList();
        }
        return this.reviews;
    }

    public List<Hunk> getHunks() {
        return null;
    }

    public boolean isOversize() {
        return false;
    }

    public boolean isBinaryOrOversize() {
        return false;
    }

    public File getTmpDiffAddedFile() {
        return null;
    }

    public File getTmpDiffRemovedFile() {
        return null;
    }

    public boolean isHead() {
        return false;
    }

    public List<RevInfoKey> getParents() {
        return null;
    }

    public boolean isMetadataOnlyChange() {
        return CommonFileRevision.isMetadataOnlyChange((FileRevision)this);
    }

    public Set<String> getHeadOnBranches() {
        return null;
    }

    public Set<String> getBranches() {
        return null;
    }

    public RevInfoKey getPredecessor() {
        return null;
    }
}

