/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.util;

import com.atlassian.crucible.spi.data.FisheyeReviewItemData;
import com.atlassian.fecru.util.ListIterable;
import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.util.MockTestFileRevision;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.IndexableFileRevision;
import com.cenqua.fisheye.rep.Position;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.BaseTestChangeSetService;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class MockChangeSetService
extends BaseTestChangeSetService<ChangeSet> {
    private Map<String, MockChangeSet> changeSets = new HashMap<String, MockChangeSet>();
    private Map<Integer, FileRevision> revisionsById = Maps.newHashMap();
    private Multimap<String, String> crossBranchNextHeads = HashMultimap.create();
    private List<ChangeSet> topologicalOrder = new ArrayList<ChangeSet>();
    private Map<String, List<ChangeSet>> branchTopologicalOrder = new HashMap<String, List<ChangeSet>>();
    private static int NEXT_CS_POSITION = 0;

    @Override
    public ChangeSet getChangeSet(String csId) throws DbException {
        return (ChangeSet)this.changeSets.get(csId);
    }

    @Override
    public ListIterable<ChangeSet> getChangeSets(final ChangeSet startPosition) throws DbException {
        return new ListIterable<ChangeSet>(){

            public ListIterator<ChangeSet> iterator() {
                return MockChangeSetService.this.initIterator(MockChangeSetService.this.topologicalOrder, startPosition);
            }

            public ListIterator<ChangeSet> iteratorFromEnd() {
                return MockChangeSetService.this.topologicalOrder.listIterator(MockChangeSetService.this.topologicalOrder.size());
            }
        };
    }

    @Override
    public ListIterable<ChangeSet> getChangeSetsOnBranch(final String branchName, final ChangeSet startPosition) throws DbException {
        return new ListIterable<ChangeSet>(){

            public ListIterator<ChangeSet> iterator() {
                return MockChangeSetService.this.initIterator((List)MockChangeSetService.this.branchTopologicalOrder.get(branchName), startPosition);
            }

            public ListIterator<ChangeSet> iteratorFromEnd() {
                List list = (List)MockChangeSetService.this.branchTopologicalOrder.get(branchName);
                return ((List)MockChangeSetService.this.branchTopologicalOrder.get(branchName)).listIterator(list.size());
            }
        };
    }

    @Override
    public ChangeSet getLatestChangesetOnBranch(String branchName) throws DbException {
        List<ChangeSet> changeSets = this.branchTopologicalOrder.get(branchName);
        return changeSets.get(changeSets.size() - 1);
    }

    public Branch getBranch(String branchName) {
        return new Branch(branchName, this.getLatestChangesetOnBranch(branchName).getId(), BranchState.ACTIVE);
    }

    public FileRevision findFileRevision(int revId) {
        return this.revisionsById.get(revId);
    }

    public FileRevision findFileRevision(Path path, String csId) {
        FileRevision fileRevision;
        block1: {
            String parentCsId;
            fileRevision = null;
            ChangeSet changeSet = this.getChangeSet(csId);
            if (changeSet == null || (fileRevision = (FileRevision)Iterables.find((Iterable)changeSet.getFileRevisions(), fileRevision1 -> path.equals((Object)fileRevision1.getPath()), null)) != null) break block1;
            Iterator iterator = changeSet.getParents().iterator();
            while (iterator.hasNext() && (fileRevision = this.findFileRevision(path, parentCsId = (String)iterator.next())) == null) {
            }
        }
        return fileRevision;
    }

    private ListIterator<ChangeSet> initIterator(List<ChangeSet> mockChangeSets, ChangeSet start) {
        ListIterator<ChangeSet> iterator = mockChangeSets.listIterator();
        while (iterator.hasNext()) {
            ChangeSet cs = iterator.next();
            if (cs.isBefore(start)) continue;
            iterator.previous();
            break;
        }
        return iterator;
    }

    public MockChangeSet mockChangeset(String csid) {
        return new MockChangeSet(csid);
    }

    public void addChangeSet(MockChangeSet cs) {
        this.changeSets.put(cs.getId(), cs);
        this.topologicalOrder.add((ChangeSet)cs);
        for (String branch : cs.branches) {
            if (!this.branchTopologicalOrder.containsKey(branch)) {
                this.branchTopologicalOrder.put(branch, new ArrayList());
            }
            this.branchTopologicalOrder.get(branch).add((ChangeSet)cs);
        }
        this.updateCrossBranchNextHeads(cs);
    }

    private void updateCrossBranchNextHeads(MockChangeSet cs) {
        ChangeSet earliestParent = null;
        List<String> parentIds = cs.getParents();
        for (String parent : parentIds) {
            ChangeSet parentCs = (ChangeSet)this.changeSets.get(parent);
            if (earliestParent != null && !parentCs.isBefore(earliestParent)) continue;
            earliestParent = parentCs;
        }
        for (ChangeSet existingCs : this.topologicalOrder) {
            if (parentIds.contains(existingCs.getId()) || !existingCs.isAfter(earliestParent) || !existingCs.isBefore((ChangeSet)cs)) continue;
            this.crossBranchNextHeads.put((Object)existingCs.getId(), (Object)cs.getId());
        }
    }

    public class MockChangeSet
    extends ChangeSetImpl {
        private Set<String> branches = new HashSet<String>();
        private final int position;
        private List<String> parents = Collections.emptyList();
        private List<String> children = new ArrayList<String>();
        private List<FileRevision> fileRevisions = Collections.emptyList();

        public MockChangeSet(String csId) {
            this.setId(csId);
            this.position = NEXT_CS_POSITION++;
        }

        public List<String> getParents() {
            return this.parents;
        }

        public List<String> getChildren() {
            return this.children;
        }

        public Set<String> getNextCrossBranchCommits() {
            if (MockChangeSetService.this.crossBranchNextHeads.containsKey((Object)this.getId())) {
                return new HashSet<String>(MockChangeSetService.this.crossBranchNextHeads.get((Object)this.getId()));
            }
            return Collections.emptySet();
        }

        public List<FileRevision> getFileRevisions() {
            return this.fileRevisions;
        }

        public void visitRevisions(StoppableVisitor visitor) throws DbException {
            for (FileRevision revision : this.fileRevisions) {
                if (visitor.visit((Object)revision)) continue;
                return;
            }
        }

        public String toString() {
            return this.getId();
        }

        public MockChangeSet branch(String branch) {
            this.branches.add(branch);
            return this;
        }

        public Set<String> getBranches() {
            return this.branches;
        }

        public Position getPosition() {
            return new Position(new long[]{this.position});
        }

        public MockChangeSet parents(String ... parents) {
            this.parents = Arrays.asList(parents);
            for (String parent : parents) {
                ((MockChangeSet)((Object)MockChangeSetService.this.changeSets.get(parent))).addChild(this.getId());
            }
            return this;
        }

        public MockChangeSet fileRevisions(FileRevision ... fileRevisions) {
            this.fileRevisions = Arrays.asList(fileRevisions);
            MockChangeSetService.this.revisionsById.putAll(Maps.uniqueIndex(this.fileRevisions, IndexableFileRevision::getRevID));
            return this;
        }

        public MockChangeSet fileRevisions(String ... files) {
            return this.fileRevisions((FileRevision[])Iterables.toArray((Iterable)Iterables.transform(Arrays.asList(files), this::createBasicFileRevisionFor), FileRevision.class));
        }

        public MockChangeSet fileRevision(String file, FisheyeReviewItemData.CommitType commitType) {
            MockTestFileRevision fileRevision = this.createBasicFileRevisionFor(file);
            switch (commitType) {
                case Added: {
                    fileRevision.added();
                    break;
                }
                case Deleted: {
                    fileRevision.deleted();
                    break;
                }
                case Moved: {
                    fileRevision.moved();
                    break;
                }
                case Copied: {
                    fileRevision.copied();
                    break;
                }
            }
            return this.fileRevisions(new FileRevision[]{fileRevision});
        }

        private MockTestFileRevision createBasicFileRevisionFor(String path) {
            final MockTestFileRevision fileRevision = new MockTestFileRevision(path, this.getId(), this.getAuthor(), new SimpleDateFormat("yyyy/MM/dd").format(new Date(this.getDate())), this.getId(), 0, 0, 0);
            Iterable ancestryRevKeys = Iterables.transform(this.getParents(), (Function)new Function<String, RevInfoKey>(){

                @Nullable
                public RevInfoKey apply(@Nullable String parentCsId) {
                    FileRevision parentRevision = MockChangeSetService.this.findFileRevision(fileRevision.getPath(), parentCsId);
                    if (parentRevision != null) {
                        MockChangeSetService.this.revisionsById.put(parentRevision.getRevID(), parentRevision);
                    }
                    return parentRevision != null ? parentRevision.getRevInfoKey() : null;
                }
            });
            ImmutableList ancestors = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)ancestryRevKeys, (Predicate)Predicates.notNull()));
            fileRevision.setAncestors((List<RevInfoKey>)ancestors);
            return fileRevision;
        }

        void addChild(String csId) {
            this.children.add(csId);
        }
    }
}

