/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.util;

import com.cenqua.fisheye.util.CollectionsUtil;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;

public class ListAssert<T> {
    private List<T> values;
    private int elementsVerified = 0;

    public ListAssert(List<T> values) {
        this.values = values;
    }

    public ListAssert<T> equals(T ... expected) {
        List<T> expectedArr = Arrays.asList(expected);
        Assert.assertEquals((String)"values was not equal", expectedArr, this.values);
        this.elementsVerified = this.values.size();
        return this;
    }

    public ListAssert<T> startsWith(T ... expected) {
        Assert.assertTrue((String)"values does not contain all expected parts. It is too short", (this.values != null && this.values.size() >= expected.length ? 1 : 0) != 0);
        Assert.assertEquals(Arrays.asList(expected), this.values.subList(0, expected.length));
        this.elementsVerified += expected.length;
        return this;
    }

    public ListAssert<T> endsWith(T ... expected) {
        Assert.assertTrue((String)"values does not contain all expected parts. It is too short", (this.values != null && this.values.size() >= expected.length ? 1 : 0) != 0);
        Assert.assertEquals(Arrays.asList(expected), this.values.subList(this.values.size() - expected.length, this.values.size()));
        this.elementsVerified += expected.length;
        return this;
    }

    public ListAssert<T> contains(T ... expected) {
        Assert.assertTrue((String)("subsequence (" + Arrays.toString(expected) + ") not found in values (" + this.values + ")"), (CollectionsUtil.findSublist(this.values, Arrays.asList(expected)) != -1 ? 1 : 0) != 0);
        this.elementsVerified += expected.length;
        return this;
    }

    public ListAssert<T> andNothingElse() {
        Assert.assertEquals((String)"There are more elements on the values than expected", (int)this.values.size(), (int)this.elementsVerified);
        return this;
    }
}

