/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.util;

import com.atlassian.fisheye.util.DevMode;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.RestoreSystemProperties;

public class DevModeTest {
    @Rule
    public final RestoreSystemProperties restoreSystemProperties = new RestoreSystemProperties();

    @Test
    public void shouldNotBeInAnyDevModeByDefault() throws Exception {
        Assert.assertFalse((boolean)DevMode.isAtlassianDevMode());
        Assert.assertFalse((boolean)DevMode.isDevMode());
    }

    @Test
    public void shouldEnableDevModeViaSysProp() throws Exception {
        System.setProperty("atlassian.fecru.dev.mode", "true");
        Assert.assertFalse((boolean)DevMode.isAtlassianDevMode());
        Assert.assertTrue((boolean)DevMode.isDevMode());
    }

    @Test
    public void shouldEnableAtlassianDevModeViaSysProp() throws Exception {
        System.setProperty("atlassian.dev.mode", "true");
        Assert.assertTrue((boolean)DevMode.isAtlassianDevMode());
        Assert.assertFalse((boolean)DevMode.isDevMode());
    }
}

