/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.permissions;

import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.utils.collectors.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.junit.Assert;

public class PagedResourceFetchHelper {
    public static <PAGE_TYPE> List<List<PAGE_TYPE>> fetchPagedResource(int pageSize, int noExpectedPages, Function<PageRequest, Page<PAGE_TYPE>> fetchFunction) {
        return PagedResourceFetchHelper.fetchPagedResource(pageSize, noExpectedPages, fetchFunction, Function.identity());
    }

    public static <RETURNED_TYPE, PAGE_TYPE> List<List<RETURNED_TYPE>> fetchPagedResource(int pageSize, int noExpectedPages, Function<PageRequest, Page<PAGE_TYPE>> fetchFunction, Function<PAGE_TYPE, RETURNED_TYPE> elemTransformFunction) {
        PageRequest pageRequest = PageRequest.create((Integer)0, (Integer)pageSize);
        ArrayList pages = Lists.newArrayList();
        for (int i = 0; i < noExpectedPages - 1; ++i) {
            Page<PAGE_TYPE> page = fetchFunction.apply(pageRequest);
            Assert.assertFalse((String)("Expected " + noExpectedPages + " pages but " + i + " was last"), (boolean)page.isLastPage());
            pageRequest = page.getNextPageRequest();
            pages.add(PagedResourceFetchHelper.transformElements(elemTransformFunction, page));
        }
        Page<PAGE_TYPE> lastPage = fetchFunction.apply(pageRequest);
        Assert.assertTrue((String)("Expected " + noExpectedPages + " pages but " + (noExpectedPages - 1) + " was last"), (boolean)lastPage.isLastPage());
        pages.add(PagedResourceFetchHelper.transformElements(elemTransformFunction, lastPage));
        return pages;
    }

    private static <RETURNED_TYPE, PAGE_TYPE> ImmutableList<RETURNED_TYPE> transformElements(Function<PAGE_TYPE, RETURNED_TYPE> elemTransformFunction, Page<PAGE_TYPE> page) {
        return (ImmutableList)StreamSupport.stream(page.getValues().spliterator(), false).map(elemTransformFunction).collect(ImmutableCollectors.toList());
    }
}

