/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.permissions;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.user.permissions.GlobalPermissionDao;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.fisheye.user.permissions.cache.EagerGlobalPermissionCacheLoader;
import com.atlassian.fisheye.user.permissions.model.GlobalPermission;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class EagerGlobalPermissionCacheLoaderTest {
    @Mock
    GroupMembershipManager groupMembershipManager;
    @Mock
    GlobalPermissionDao dao;
    @InjectMocks
    EagerGlobalPermissionCacheLoader loader;

    @Test
    public void testLoad() throws Exception {
        Mockito.when((Object)this.groupMembershipManager.getUsersInGroup("team-1")).thenReturn(this.makeUsers("jake", "cake")).thenThrow(new Throwable[]{new AssertionError((Object)"Should only check once")});
        Mockito.when((Object)this.groupMembershipManager.getUsersInGroup("team-2")).thenReturn(this.makeUsers("Jake", "break", "rake")).thenThrow(new Throwable[]{new AssertionError((Object)"Should only check once")});
        Mockito.when((Object)this.dao.getGroupsWithPermissions((Set)org.mockito.Matchers.eq(Collections.emptySet()), org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyInt())).thenReturn((Object)ImmutableList.of((Object)new GlobalPermission("team-1", Collections.singleton(GlobalPermissionType.FISHEYE_USER)), (Object)new GlobalPermission("team-2", GlobalPermissionType.FISHEYE_AND_CRUCIBLE)));
        SetMultimap result = this.loader.load(new Object());
        Assert.assertThat((Object)result.get((Object)GlobalPermissionType.FISHEYE_USER), (Matcher)Matchers.contains((Object[])new String[]{"break", "cake", "jake", "rake"}));
        Assert.assertThat((Object)result.get((Object)GlobalPermissionType.CRUCIBLE_USER), (Matcher)Matchers.contains((Object[])new String[]{"break", "jake", "rake"}));
    }

    List<FecruUser> makeUsers(String ... users) {
        return Arrays.stream(users).map(FecruUser::new).collect(Collectors.toList());
    }
}

