/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.permissions;

import com.atlassian.crucible.spi.data.GlobalPermissionData;
import com.atlassian.crucible.spi.impl.DefaultGlobalPermissionService;
import com.atlassian.crucible.spi.services.GlobalPermissionService;
import com.atlassian.crucible.spi.services.GroupService;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.fisheye.user.permissions.PagedResourceFetchHelper;
import com.atlassian.fisheye.user.permissions.model.GlobalPermission;
import com.cenqua.fisheye.user.GroupInfo;
import com.cenqua.fisheye.user.GroupSearchCriteria;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultGlobalPermissionServiceTest {
    @Mock
    private GlobalPermissionManager globalPermissionManager;
    @Mock
    private GroupService groupService;
    @Mock
    private UserManager userManager;
    @Mock
    private EffectiveUserProvider effectiveUserProvider;
    private GlobalPermissionService globalPermissionService;

    @Before
    public void setUp() throws Exception {
        this.globalPermissionService = new DefaultGlobalPermissionService(this.globalPermissionManager, this.groupService, this.userManager, this.effectiveUserProvider);
        Mockito.when((Object)this.globalPermissionManager.hasPermissions((String)org.mockito.Matchers.any(String.class), (Set)org.mockito.Matchers.any(Set.class))).thenReturn((Object)true);
        Mockito.when((Object)this.groupService.exist(org.mockito.Matchers.anyString())).thenReturn((Object)true);
        FecruUser fecruUser = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)this.userManager.getUser(org.mockito.Matchers.anyString())).thenReturn((Object)fecruUser);
        Mockito.when((Object)fecruUser.isEnabled()).thenReturn((Object)true);
        ((EffectiveUserProvider)Mockito.doThrow(NotPermittedException.class).when((Object)this.effectiveUserProvider)).ensureAdminPermission();
    }

    @Test
    public void testHasUserPermissionsDoesntNeedAdminPermissions() throws Exception {
        Mockito.when((Object)this.globalPermissionManager.hasPermission("user", GlobalPermissionType.FISHEYE_USER)).thenReturn((Object)true);
        Mockito.when((Object)this.userManager.existsEnabledUser("user")).thenReturn((Object)true);
        boolean result = this.globalPermissionService.hasUserPermissions("user", GlobalPermissionType.FISHEYE_USER);
        Assert.assertTrue((boolean)result);
    }

    @Test(expected=NotPermittedException.class)
    public void testAddPermissionsWithoutAdmin() throws Exception {
        this.globalPermissionService.setPermissionsForGroup("gr1", EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.globalPermissionManager});
    }

    @Test
    public void testRemovePermissionWithAdmin() throws Exception {
        ((EffectiveUserProvider)Mockito.doNothing().when((Object)this.effectiveUserProvider)).ensureAdminPermission();
        this.globalPermissionService.setPermissionsForGroup("gr1", EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        ((GlobalPermissionManager)Mockito.verify((Object)this.globalPermissionManager, (VerificationMode)Mockito.times((int)1))).setPermissionsForGroup((String)org.mockito.Matchers.eq((Object)"gr1"), (Set)org.mockito.Matchers.eq(EnumSet.of(GlobalPermissionType.FISHEYE_USER)));
    }

    @Test
    public void testRemoveAllPermissionForGroup() throws Exception {
        String foobar = "foobar";
        ((EffectiveUserProvider)Mockito.doNothing().when((Object)this.effectiveUserProvider)).ensureAdminPermission();
        this.globalPermissionService.removeAllPermissionForGroup("foobar");
        ((GlobalPermissionManager)Mockito.verify((Object)this.globalPermissionManager)).removeAllPermissionsForGroup("foobar");
    }

    @Test(expected=NotPermittedException.class)
    public void testListPermissionsWhenNonAdmin() throws Exception {
        Page page = this.globalPermissionService.listPermissions(null);
    }

    @Test
    public void testListPermissionsWhenAdmin() throws Exception {
        ((EffectiveUserProvider)Mockito.doNothing().when((Object)this.effectiveUserProvider)).ensureAdminPermission();
        GlobalPermission gp1 = new GlobalPermission("g1", EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        GlobalPermission gp2 = new GlobalPermission("g2", GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        ArrayList expectedList = Lists.newArrayList((Object[])new GlobalPermissionData[]{new GlobalPermissionData("g1", true, false), new GlobalPermissionData("g2", true, true)});
        Mockito.when((Object)this.globalPermissionManager.listPermissions((PageRequest)org.mockito.Matchers.any())).thenReturn((Object)Lists.newArrayList((Object[])new GlobalPermission[]{gp1, gp2}));
        Page page = this.globalPermissionService.listPermissions(null);
        Iterable result = page.getValues();
        Assert.assertEquals((Object)expectedList, (Object)result);
    }

    @Test
    public void testGroupsWithoutAnyPermissions() throws Exception {
        String prefix = "prefix";
        GroupInfo g1 = new GroupInfo("g1", false);
        GroupInfo g2 = new GroupInfo("g2", false);
        GroupInfo g3 = new GroupInfo("g3", false);
        GroupInfo g4 = new GroupInfo("g4", false);
        GroupInfo g5 = new GroupInfo("g5", false);
        ArrayList groupInfos = Lists.newArrayList((Object[])new GroupInfo[]{g1, g2, g3, g4, g5});
        ImmutableSet existingPermission = ImmutableSet.of((Object)new GlobalPermission("g2", true, false), (Object)new GlobalPermission("g4", true, false));
        Page page = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)page.getValues()).thenReturn((Object)groupInfos);
        Mockito.when((Object)this.userManager.searchGroups((GroupSearchCriteria)org.mockito.Matchers.any(), (PageRequest)org.mockito.Matchers.any())).thenReturn((Object)page);
        Mockito.when((Object)this.globalPermissionManager.listPermissions((PageRequest)org.mockito.Matchers.any())).thenReturn((Object)existingPermission);
        List pages = PagedResourceFetchHelper.fetchPagedResource(1, 3, pageRequest -> this.globalPermissionService.groupsWithoutAnyPermissions("prefix", pageRequest));
        Assert.assertThat(pages.get(0), (Matcher)Matchers.contains((Object[])new String[]{"g1"}));
        Assert.assertThat(pages.get(1), (Matcher)Matchers.contains((Object[])new String[]{"g3"}));
        Assert.assertThat(pages.get(2), (Matcher)Matchers.contains((Object[])new String[]{"g5"}));
    }
}

