/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.permissions;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.user.permissions.DefaultGlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionDao;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionModifiedEvent;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.fisheye.user.permissions.cache.EagerGlobalPermissionCacheLoader;
import com.atlassian.fisheye.user.permissions.cache.GlobalPermissionCache;
import com.atlassian.fisheye.user.permissions.cache.GlobalPermissionCacheLoader;
import com.atlassian.fisheye.user.permissions.model.GlobalPermission;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultGlobalPermissionManagerTest {
    private static final String GROUP1 = "testgroup";
    private static final String GROUP2 = "testgroup2";
    private static final String GROUP3 = "testgroup3";
    private static final List<String> SINGLE_TEST_GROUP = Lists.newArrayList((Object[])new String[]{"testgroup"});
    private static final List<GlobalPermission> GROUP1_GROUP2_GROUP3_TEST_GROUPS = Lists.newArrayList((Object[])new GlobalPermission[]{new GlobalPermission("testgroup", true, true), new GlobalPermission("testgroup2", true, true), new GlobalPermission("testgroup3", false, true)});
    private GlobalPermissionManager manager;
    @Mock
    private GlobalPermissionDao dao;
    @Mock
    private GroupMembershipManager groupMembershipManager;
    @Mock
    private EventPublisher eventPublisher;

    @Before
    public void setUp() throws Exception {
        this.manager = new DefaultGlobalPermissionManager(this.dao, this.eventPublisher, new GlobalPermissionCache((GlobalPermissionCacheLoader)new EagerGlobalPermissionCacheLoader(this.dao, this.groupMembershipManager)));
    }

    @Test
    public void testUserAllGroupsHasPermission() throws Exception {
        Mockito.when((Object)this.groupMembershipManager.getUsersInGroup(GROUP1)).thenReturn(Collections.singletonList(new FecruUser("testUser")));
        Mockito.when((Object)this.dao.getGroupsWithPermissions(Matchers.anySet(), Matchers.anyInt(), Matchers.anyInt())).thenReturn(Collections.singletonList(new GlobalPermission(GROUP1, true, false)));
        boolean result = this.manager.hasPermission("testUser", GlobalPermissionType.FISHEYE_USER);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testUserAllGroupsDoesntHavePermission() throws Exception {
        Mockito.when((Object)this.groupMembershipManager.getGroupsForUser("testuser")).thenReturn(SINGLE_TEST_GROUP);
        Mockito.when((Object)this.dao.existsGroupWithPermission((Collection)Matchers.eq(SINGLE_TEST_GROUP), (Set)Matchers.eq(EnumSet.of(GlobalPermissionType.FISHEYE_USER)))).thenReturn((Object)true);
        boolean result = this.manager.hasPermissions("testUser", GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testHasPermissions_shouldReturnTrueOnEmptyList() throws Exception {
        boolean hasNoPermissions = this.manager.hasPermissions("testUser", Collections.emptySet());
        Assert.assertTrue((boolean)hasNoPermissions);
    }

    @Test
    public void testAddPermissionForGroup() throws Exception {
        this.manager.setPermissionsForGroup("testGROUP", GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        ((GlobalPermissionDao)Mockito.verify((Object)this.dao)).setPermissionsForGroup((String)Matchers.eq((Object)GROUP1), (Set)Matchers.eq((Object)GlobalPermissionType.FISHEYE_AND_CRUCIBLE));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.times((int)1))).publish(Matchers.argThat((Matcher)CoreMatchers.instanceOf(GlobalPermissionModifiedEvent.class)));
    }

    @Test
    public void testRemovePermissionForGroup() throws Exception {
        this.manager.removeAllPermissionsForGroup("testGROUP");
        ((GlobalPermissionDao)Mockito.verify((Object)this.dao)).removeAllPermissionsForGroup((String)Matchers.eq((Object)GROUP1));
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.times((int)1))).publish(Matchers.argThat((Matcher)CoreMatchers.instanceOf(GlobalPermissionModifiedEvent.class)));
    }

    @Test
    public void testCountUsersWithPermission() throws Exception {
        Mockito.when((Object)this.groupMembershipManager.getUsersInGroup((String)Matchers.eq((Object)GROUP1))).thenReturn((Object)Lists.newArrayList((Object[])new FecruUser[]{new FecruUser("user1"), new FecruUser("user3"), new FecruUser("user10")}));
        Mockito.when((Object)this.groupMembershipManager.getUsersInGroup((String)Matchers.eq((Object)GROUP2))).thenReturn((Object)Lists.newArrayList((Object[])new FecruUser[]{new FecruUser("user2"), new FecruUser("user4"), new FecruUser("user10")}));
        Mockito.when((Object)this.groupMembershipManager.getUsersInGroup((String)Matchers.eq((Object)GROUP3))).thenReturn((Object)Lists.newArrayList((Object[])new FecruUser[]{new FecruUser("user1"), new FecruUser("user5"), new FecruUser("user10")}));
        Mockito.when((Object)this.dao.getGroupsWithPermissions((Set)Matchers.eq(Collections.emptySet()), Matchers.anyInt(), Matchers.anyInt())).thenReturn(GROUP1_GROUP2_GROUP3_TEST_GROUPS);
        int feOnly = this.manager.countUsersWithPermission(GlobalPermissionType.FISHEYE_USER);
        int cruOnly = this.manager.countUsersWithPermission(GlobalPermissionType.CRUCIBLE_USER);
        Assert.assertEquals((long)5L, (long)feOnly);
        Assert.assertEquals((long)6L, (long)cruOnly);
    }

    @Test
    public void testGetGlobalPermissionForGroupWhenItHasPermission() throws Exception {
        GlobalPermission permission = new GlobalPermission(GROUP1, GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        Mockito.when((Object)this.dao.getPermissionForGroup((String)Matchers.any())).thenReturn((Object)permission);
        Optional result = this.manager.getPermissionForGroup(GROUP1);
        Assert.assertSame((Object)permission, result.orElse(null));
    }

    @Test
    public void testGetGlobalPermissionForGroupWhenItHasNotPermission() throws Exception {
        Optional result = this.manager.getPermissionForGroup(GROUP1);
        Assert.assertFalse((String)"Optional should be empty", (boolean)result.isPresent());
    }

    @Test(expected=IllegalStateException.class)
    public void testIllegalStateExceptionWhenGrantingCruOnlyAndFeDisabledPermission() {
        Mockito.when((Object)this.dao.getPermissionForGroup(GROUP1)).thenReturn((Object)new GlobalPermission(GROUP1, false, false));
        this.manager.setPermissionsForGroup(GROUP1, EnumSet.of(GlobalPermissionType.CRUCIBLE_USER));
    }

    @Test(expected=IllegalStateException.class)
    public void testIllegalStateExceptionWhenGrantingCruOnlyAndNonePermissionsExist() {
        Mockito.when((Object)this.dao.getPermissionForGroup(GROUP1)).thenReturn(null);
        this.manager.setPermissionsForGroup(GROUP1, EnumSet.of(GlobalPermissionType.CRUCIBLE_USER));
    }

    @Test(expected=IllegalStateException.class)
    public void testIllegalStateExceptionWhenRevokingFeWhenCruTruePermission() {
        Mockito.when((Object)this.dao.getPermissionForGroup(GROUP1)).thenReturn((Object)new GlobalPermission(GROUP1, true, true));
        this.manager.setPermissionsForGroup(GROUP1, EnumSet.of(GlobalPermissionType.CRUCIBLE_USER));
    }

    @Test
    public void shouldEmitEventsOnPermissionChanges() throws Exception {
        this.manager.setPermissionsForGroup(GROUP1, GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        this.manager.removeAllPermissionsForGroup(GROUP1);
        ((EventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.times((int)2))).publish(Matchers.any(GlobalPermissionModifiedEvent.class));
    }
}

