/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.permissions;

import com.atlassian.fisheye.user.permissions.DefaultGlobalPermissionDao;
import com.atlassian.fisheye.user.permissions.GlobalPermissionDao;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.fisheye.user.permissions.model.GlobalPermission;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hibernate.Query;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level1-session.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class DefaultGlobalPermissionDaoDBTest {
    private static final String GROUP1 = "group1";
    private static final String GROUP2 = "group2";
    private static final String GROUP3 = "group3";
    @Autowired
    private CurrentSessionProvider sessionProvider;
    private GlobalPermissionDao dao;

    @Before
    public void setUp() throws Exception {
        this.dao = new DefaultGlobalPermissionDao(this.sessionProvider);
        this.clearAllObjectsAndCloseSession();
    }

    private void clearAllObjectsAndCloseSession() {
        Session session = this.sessionProvider.currentSession();
        Query query = session.createQuery("DELETE FROM GlobalPermission");
        query.executeUpdate();
        session.flush();
        session.clear();
    }

    @Test
    public void testAddPermissionForGroup() throws Exception {
        this.dao.setPermissionsForGroup(GROUP1, EnumSet.of(GlobalPermissionType.CRUCIBLE_USER));
        boolean feOnly = this.dao.existsGroupWithPermission(Collections.singleton(GROUP1), EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        boolean cruOnly = this.dao.existsGroupWithPermission(Collections.singleton(GROUP1), EnumSet.of(GlobalPermissionType.CRUCIBLE_USER));
        boolean fecru = this.dao.existsGroupWithPermission(Collections.singleton(GROUP1), GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        Assert.assertFalse((boolean)feOnly);
        Assert.assertFalse((boolean)fecru);
        Assert.assertTrue((boolean)cruOnly);
    }

    @Test
    public void testUpdatePreviouslyEmptyGroup() throws Exception {
        this.addPermission(GROUP1, Collections.emptySet());
        this.dao.setPermissionsForGroup(GROUP1, EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        boolean feOnly = this.dao.existsGroupWithPermission(Collections.singleton(GROUP1), EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        boolean fecru = this.dao.existsGroupWithPermission(Collections.singleton(GROUP1), GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        Assert.assertTrue((boolean)feOnly);
        Assert.assertFalse((boolean)fecru);
    }

    @Test
    public void testUpdateWithTheSamePermissionForGroup() throws Exception {
        this.addPermission(GROUP1, GlobalPermissionType.FISHEYE_USER);
        this.dao.setPermissionsForGroup(GROUP1, EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        boolean fe = this.dao.existsGroupWithPermission(Collections.singleton(GROUP1), EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        boolean cru = this.dao.existsGroupWithPermission(Collections.singleton(GROUP1), EnumSet.of(GlobalPermissionType.CRUCIBLE_USER));
        boolean fecru = this.dao.existsGroupWithPermission(Collections.singleton(GROUP1), GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        Assert.assertTrue((boolean)fe);
        Assert.assertFalse((boolean)cru);
        Assert.assertFalse((boolean)fecru);
    }

    @Test
    public void testHasPermissionsRequireAllPermissions() throws Exception {
        this.addPermission(GROUP1, GlobalPermissionType.FISHEYE_USER);
        this.addPermission(GROUP2, EnumSet.of(GlobalPermissionType.FISHEYE_USER, GlobalPermissionType.CRUCIBLE_USER));
        boolean feOnlyG1 = this.dao.existsGroupWithPermission(Collections.singleton(GROUP1), EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        boolean cruOnlyG1 = this.dao.existsGroupWithPermission(Collections.singleton(GROUP1), EnumSet.of(GlobalPermissionType.CRUCIBLE_USER));
        boolean fecruG1 = this.dao.existsGroupWithPermission(Collections.singleton(GROUP1), GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        boolean fecruG2 = this.dao.existsGroupWithPermission(Collections.singleton(GROUP2), GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        Assert.assertTrue((boolean)feOnlyG1);
        Assert.assertFalse((boolean)fecruG1);
        Assert.assertFalse((boolean)cruOnlyG1);
        Assert.assertTrue((boolean)fecruG2);
    }

    @Test
    public void testAnyOfGroupHasPermissionsRequireAllPermissions() throws Exception {
        this.addPermission(GROUP1, EnumSet.of(GlobalPermissionType.FISHEYE_USER, GlobalPermissionType.CRUCIBLE_USER));
        this.addPermission(GROUP2, EnumSet.of(GlobalPermissionType.FISHEYE_USER, GlobalPermissionType.CRUCIBLE_USER));
        this.addPermission(GROUP3, GlobalPermissionType.FISHEYE_USER);
        boolean feCruAllGroups = this.dao.existsGroupWithPermission((Collection)Lists.newArrayList((Object[])new String[]{GROUP1, GROUP2, GROUP3}), GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        boolean feCruGroup1_2 = this.dao.existsGroupWithPermission((Collection)Lists.newArrayList((Object[])new String[]{GROUP1, GROUP2}), GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        boolean cruAllGroups = this.dao.existsGroupWithPermission((Collection)Lists.newArrayList((Object[])new String[]{GROUP1, GROUP2, GROUP3}), EnumSet.of(GlobalPermissionType.CRUCIBLE_USER));
        boolean feAllGroups = this.dao.existsGroupWithPermission((Collection)Lists.newArrayList((Object[])new String[]{GROUP1, GROUP2, GROUP3}), EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        Assert.assertTrue((boolean)feCruAllGroups);
        Assert.assertTrue((boolean)feCruGroup1_2);
        Assert.assertTrue((boolean)cruAllGroups);
        Assert.assertTrue((boolean)feAllGroups);
    }

    @Test
    public void testRemovePermissionsForGroup() throws Exception {
        this.addPermission(GROUP1, EnumSet.of(GlobalPermissionType.FISHEYE_USER, GlobalPermissionType.CRUCIBLE_USER));
        this.dao.setPermissionsForGroup(GROUP1, EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        boolean feOnly = this.dao.existsGroupWithPermission(Collections.singleton(GROUP1), EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        boolean cruOnly = this.dao.existsGroupWithPermission(Collections.singleton(GROUP1), EnumSet.of(GlobalPermissionType.CRUCIBLE_USER));
        Assert.assertTrue((boolean)feOnly);
        Assert.assertFalse((boolean)cruOnly);
    }

    @Test
    public void testRemoveMultiPermissionsForGroup() throws Exception {
        this.addPermission(GROUP1, EnumSet.of(GlobalPermissionType.FISHEYE_USER, GlobalPermissionType.CRUCIBLE_USER));
        this.dao.removeAllPermissionsForGroup(GROUP1);
        boolean feOnly = this.dao.existsGroupWithPermission(Collections.singleton(GROUP1), EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        boolean cruOnly = this.dao.existsGroupWithPermission(Collections.singleton(GROUP1), EnumSet.of(GlobalPermissionType.CRUCIBLE_USER));
        Assert.assertFalse((boolean)feOnly);
        Assert.assertFalse((boolean)cruOnly);
    }

    @Test
    public void testGetGroupsWithAllPermissions() throws Exception {
        this.addPermission(GROUP3, EnumSet.of(GlobalPermissionType.CRUCIBLE_USER));
        this.addPermission(GROUP2, EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        this.addPermission(GROUP1, EnumSet.of(GlobalPermissionType.FISHEYE_USER, GlobalPermissionType.CRUCIBLE_USER));
        Collection feOnly = this.dao.getGroupsWithPermissions(EnumSet.of(GlobalPermissionType.FISHEYE_USER), 0, 10).stream().map(GlobalPermission::getGroup).collect(Collectors.toList());
        Collection cruOnly = this.dao.getGroupsWithPermissions(EnumSet.of(GlobalPermissionType.CRUCIBLE_USER), 0, 10).stream().map(GlobalPermission::getGroup).collect(Collectors.toList());
        Collection fecru = this.dao.getGroupsWithPermissions(EnumSet.of(GlobalPermissionType.FISHEYE_USER, GlobalPermissionType.CRUCIBLE_USER), 0, 10).stream().map(GlobalPermission::getGroup).collect(Collectors.toList());
        Assert.assertThat((Object)feOnly, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{GROUP1, GROUP2}));
        Assert.assertThat((Object)cruOnly, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{GROUP1, GROUP3}));
        Assert.assertThat((Object)fecru, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{GROUP1}));
    }

    @Test
    public void testNoGroupsSpecifiedReturnsFalse() throws Exception {
        this.addPermission(GROUP1, EnumSet.of(GlobalPermissionType.FISHEYE_USER, GlobalPermissionType.CRUCIBLE_USER));
        this.addPermission(GROUP2, EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        this.addPermission(GROUP3, EnumSet.of(GlobalPermissionType.CRUCIBLE_USER));
        boolean feOnly = this.dao.existsGroupWithPermission(Collections.emptySet(), EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        Assert.assertFalse((String)"Without specifying any groups permission is denied", (boolean)feOnly);
    }

    @Test
    public void testWhenRemovingAllPermissionsEntityShallBeDeleted() throws Exception {
        this.addPermission(GROUP2, EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        this.dao.removeAllPermissionsForGroup(GROUP2);
        long count = (Long)this.sessionProvider.currentSession().createQuery("SELECT count(id) From GlobalPermission").uniqueResult();
        Assert.assertEquals((String)"Expecting 0 entities in db", (long)0L, (long)count);
    }

    @Test
    public void testWhenSettingNonePermissionsEntityShallBeDeleted() throws Exception {
        this.addPermission(GROUP2, EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        this.dao.setPermissionsForGroup(GROUP2, Collections.emptySet());
        long count = (Long)this.sessionProvider.currentSession().createQuery("SELECT count(id) From GlobalPermission").uniqueResult();
        Assert.assertEquals((String)"Expecting 0 entities in db", (long)0L, (long)count);
    }

    @Test
    public void testGlobalPermissionForGroup() throws Exception {
        GlobalPermission expectedPermission = new GlobalPermission(GROUP1, GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        this.addPermission(GROUP1, EnumSet.of(GlobalPermissionType.FISHEYE_USER, GlobalPermissionType.CRUCIBLE_USER));
        this.addPermission(GROUP2, EnumSet.of(GlobalPermissionType.FISHEYE_USER));
        GlobalPermission permission = this.dao.getPermissionForGroup(GROUP1);
        Assert.assertEquals((Object)expectedPermission, (Object)permission);
    }

    private void addPermission(String group, GlobalPermissionType globalPermissionType) {
        this.addPermission(group, EnumSet.of(globalPermissionType));
    }

    private void addPermission(String group, Set<GlobalPermissionType> globalPermissionType) {
        Session session = this.sessionProvider.currentSession();
        GlobalPermission globalPermission = new GlobalPermission(group, globalPermissionType);
        session.save((Object)globalPermission);
        session.flush();
        session.clear();
    }
}

