/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.user.permissions;

import com.atlassian.crucible.spi.services.GlobalPermissionService;
import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fisheye.user.permissions.DefaultEffectiveUserPermissionService;
import com.atlassian.fisheye.user.permissions.EffectiveUserPermissionService;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.cenqua.fisheye.license.LicenseInfo;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultEffectiveUserPermissionServiceTest {
    private static final String USERNAME = "TestUser";
    @Mock
    LicenseManager licenseManager;
    @Mock
    LicenseInfo licenseInfo;
    @Mock
    GlobalPermissionService globalPermissionService;
    @InjectMocks
    EffectiveUserPermissionService effectiveUserPermissionService = new DefaultEffectiveUserPermissionService();

    private void setupPermissions(boolean isFisheyeInstance, boolean isCrucibleInstance, boolean hasFisheyePermission, boolean hasCruciblePermission) {
        Mockito.when((Object)this.globalPermissionService.hasUserPermissions(Matchers.anyString(), (GlobalPermissionType)Matchers.any(GlobalPermissionType.class))).thenReturn((Object)false);
        Mockito.when((Object)this.globalPermissionService.hasUserPermissions((String)Matchers.eq((Object)USERNAME), (GlobalPermissionType)Matchers.eq((Object)GlobalPermissionType.FISHEYE_USER))).thenReturn((Object)hasFisheyePermission);
        Mockito.when((Object)this.globalPermissionService.hasUserPermissions((String)Matchers.eq((Object)USERNAME), (GlobalPermissionType)Matchers.eq((Object)GlobalPermissionType.CRUCIBLE_USER))).thenReturn((Object)hasCruciblePermission);
        Mockito.when((Object)this.licenseManager.getLicenseInfo()).thenReturn((Object)this.licenseInfo);
        Mockito.when((Object)this.licenseManager.getLicenseInfo().isFishEye()).thenReturn((Object)isFisheyeInstance);
        Mockito.when((Object)this.licenseManager.getLicenseInfo().isCrucible()).thenReturn((Object)isCrucibleInstance);
    }

    @Test
    public void testNoPermissionsOnFisheye() {
        this.setupPermissions(true, false, false, false);
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessFisheye(USERNAME));
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessCrucible(USERNAME));
    }

    @Test
    public void testNoPermissionsOnCrucible() {
        this.setupPermissions(false, true, false, false);
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessFisheye(USERNAME));
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessCrucible(USERNAME));
    }

    @Test
    public void testNoPermissionsOnFeCru() {
        this.setupPermissions(true, true, false, false);
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessFisheye(USERNAME));
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessCrucible(USERNAME));
    }

    @Test
    public void testFePermissionsOnFisheye() {
        this.setupPermissions(true, false, true, false);
        Assert.assertTrue((boolean)this.effectiveUserPermissionService.canUserAccessFisheye(USERNAME));
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessCrucible(USERNAME));
    }

    @Test
    public void testFePermissionsOnCrucible() {
        this.setupPermissions(false, true, true, false);
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessFisheye(USERNAME));
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessCrucible(USERNAME));
    }

    @Test
    public void testFePermissionsOnFeCru() {
        this.setupPermissions(true, true, true, false);
        Assert.assertTrue((boolean)this.effectiveUserPermissionService.canUserAccessFisheye(USERNAME));
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessCrucible(USERNAME));
    }

    @Test
    public void testCruPermissionOnFisheye() {
        this.setupPermissions(true, false, false, true);
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessFisheye(USERNAME));
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessCrucible(USERNAME));
    }

    @Test
    public void testCruPermissionOnCrucible() {
        this.setupPermissions(false, true, false, true);
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessFisheye(USERNAME));
        Assert.assertTrue((boolean)this.effectiveUserPermissionService.canUserAccessCrucible(USERNAME));
    }

    @Test
    public void testCruPermissionOnFeCru() {
        this.setupPermissions(true, true, false, true);
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessFisheye(USERNAME));
        Assert.assertTrue((boolean)this.effectiveUserPermissionService.canUserAccessCrucible(USERNAME));
    }

    @Test
    public void testAllPermissionsOnFisheye() {
        this.setupPermissions(true, false, true, true);
        Assert.assertTrue((boolean)this.effectiveUserPermissionService.canUserAccessFisheye(USERNAME));
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessCrucible(USERNAME));
    }

    @Test
    public void testAllPermissionsOnCrucible() {
        this.setupPermissions(false, true, true, true);
        junit.framework.Assert.assertFalse((boolean)this.effectiveUserPermissionService.canUserAccessFisheye(USERNAME));
        Assert.assertTrue((boolean)this.effectiveUserPermissionService.canUserAccessCrucible(USERNAME));
    }

    @Test
    public void testAllPermissionsOnFeCru() {
        this.setupPermissions(true, true, true, true);
        Assert.assertTrue((boolean)this.effectiveUserPermissionService.canUserAccessFisheye(USERNAME));
        Assert.assertTrue((boolean)this.effectiveUserPermissionService.canUserAccessCrucible(USERNAME));
    }

    @Test(expected=NullPointerException.class)
    public void testPermissionsForNullUser() {
        this.setupPermissions(true, true, true, true);
        Assert.assertTrue((boolean)this.effectiveUserPermissionService.canUserAccessCrucible(null));
    }
}

