/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2MessageContext;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.atlassian.fisheye.svn.Svn2Utils;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.IndexingFeatures;
import com.cenqua.fisheye.svn.SvnChangePath;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.NodeKind;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class Svn2UtilsTest {
    @Mock
    private Svn2RepositoryEngine engine;
    @Mock
    private SvnChangeSet changeset;
    @Mock
    private Svn2Cache cache;
    @Mock
    private SvnRepositoryInfo repositoryInfo;
    @Mock
    private SvnRevInfoDAO infoDAO;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.engine.getInternalRevisionCache()).thenReturn((Object)this.cache);
        Mockito.when((Object)this.engine.getRepositoryInfo()).thenReturn((Object)this.repositoryInfo);
        Mockito.when((Object)this.cache.loadIndexingFeatures()).thenReturn(Mockito.mock(IndexingFeatures.class));
        Mockito.when((Object)this.cache.getDiffTextLock()).thenReturn((Object)new ReentrantLock());
        Mockito.when((Object)this.cache.getFileRevisionDAO()).thenReturn((Object)this.infoDAO);
        Mockito.when((Object)this.repositoryInfo.getServerPath((Path)Matchers.any(), Matchers.anyLong())).thenAnswer(invocation -> invocation.getArguments()[0].toString());
    }

    @Test
    public void testRecreatedContextContainAllChangedRevisions() throws Exception {
        SvnChangePath expectedP1 = new SvnChangePath("file.txt", 0L, null, ChangePath.Action.add, NodeKind.file);
        SvnChangePath expectedP2 = new SvnChangePath("file2.txt", 0L, null, ChangePath.Action.modify, NodeKind.file);
        SvnRevInfo fr1 = (SvnRevInfo)Mockito.mock(SvnRevInfo.class);
        SvnRevInfo fr2 = (SvnRevInfo)Mockito.mock(SvnRevInfo.class);
        Mockito.when((Object)fr1.getPath()).thenReturn((Object)new Path((CharSequence)"file.txt"));
        Mockito.when((Object)fr2.getPath()).thenReturn((Object)new Path((CharSequence)"file2.txt"));
        ArrayList revisions = Lists.newArrayList((Object[])new SvnRevInfo[]{fr1, fr2});
        this.mockSvnInfoVisitChangesets(revisions);
        Svn2MessageContext result = Svn2Utils.recreateMessageContext((Svn2RepositoryEngine)this.engine, (SvnChangeSet)this.changeset);
        Iterable changePaths = result.getChangePaths();
        Assert.assertTrue((boolean)Iterables.contains((Iterable)changePaths, (Object)expectedP1));
        Assert.assertTrue((boolean)Iterables.contains((Iterable)changePaths, (Object)expectedP2));
    }

    @Test
    public void testRecreatedContextWithInitialRevisionDoesntContainRootPath() throws Exception {
        Mockito.when((Object)this.repositoryInfo.getStartRev()).thenReturn((Object)8L);
        Mockito.when((Object)this.changeset.getLongId()).thenReturn((Object)8L);
        SvnChangePath expectedP1 = new SvnChangePath("", 0L, null, ChangePath.Action.add, NodeKind.dir);
        SvnChangePath expectedP2 = new SvnChangePath("dir2", 0L, null, ChangePath.Action.modify, NodeKind.file);
        SvnRevInfo fr1 = (SvnRevInfo)Mockito.mock(SvnRevInfo.class);
        SvnRevInfo fr2 = (SvnRevInfo)Mockito.mock(SvnRevInfo.class);
        Mockito.when((Object)fr1.getPath()).thenReturn((Object)new Path((CharSequence)""));
        Mockito.when((Object)fr1.isAdded()).thenReturn((Object)true);
        Mockito.when((Object)fr2.getPath()).thenReturn((Object)new Path((CharSequence)"dir2"));
        ArrayList revisions = Lists.newArrayList((Object[])new SvnRevInfo[]{fr1, fr2});
        this.mockSvnInfoVisitChangesets(revisions);
        Svn2MessageContext result = Svn2Utils.recreateMessageContext((Svn2RepositoryEngine)this.engine, (SvnChangeSet)this.changeset);
        Iterable changePaths = result.getChangePaths();
        Assert.assertFalse((boolean)Iterables.contains((Iterable)changePaths, (Object)expectedP1));
        Assert.assertTrue((boolean)Iterables.contains((Iterable)changePaths, (Object)expectedP2));
    }

    @Test
    public void testRecreatedContextWithoutInitialRevisionDoesntContainRootPath() throws Exception {
        Mockito.when((Object)this.repositoryInfo.getStartRev()).thenReturn((Object)0L);
        Mockito.when((Object)this.changeset.getLongId()).thenReturn((Object)8L);
        SvnChangePath expectedP1 = new SvnChangePath("", 0L, null, ChangePath.Action.add, NodeKind.dir);
        SvnRevInfo fr1 = (SvnRevInfo)Mockito.mock(SvnRevInfo.class);
        Mockito.when((Object)fr1.getPath()).thenReturn((Object)new Path((CharSequence)""));
        Mockito.when((Object)fr1.isAdded()).thenReturn((Object)true);
        ArrayList revisions = Lists.newArrayList((Object[])new SvnRevInfo[]{fr1});
        this.mockSvnInfoVisitChangesets(revisions);
        Svn2MessageContext result = Svn2Utils.recreateMessageContext((Svn2RepositoryEngine)this.engine, (SvnChangeSet)this.changeset);
        Iterable changePaths = result.getChangePaths();
        Assert.assertTrue((boolean)Iterables.contains((Iterable)changePaths, (Object)expectedP1));
    }

    @Test
    public void testRecreatedContextContainsProperRevProps() throws Exception {
        Mockito.when((Object)this.changeset.getAuthor()).thenReturn((Object)"changeset author");
        Mockito.when((Object)this.changeset.getComment()).thenReturn((Object)"my shiny comment");
        Mockito.when((Object)this.changeset.getDate()).thenReturn((Object)0L);
        Svn2MessageContext result = Svn2Utils.recreateMessageContext((Svn2RepositoryEngine)this.engine, (SvnChangeSet)this.changeset);
        Assert.assertEquals((Object)"changeset author", (Object)result.getAuthor());
        Assert.assertEquals((Object)"my shiny comment", (Object)result.getCommitMessage());
        Assert.assertEquals((long)0L, (long)result.getDate());
    }

    private void mockSvnInfoVisitChangesets(Collection<SvnRevInfo> revisionsToVisit) {
        ((SvnRevInfoDAO)Mockito.doAnswer(invocation -> {
            StoppableVisitor visitor = (StoppableVisitor)invocation.getArguments()[1];
            for (FileRevision revision : revisionsToVisit) {
                if (visitor.visit((Object)revision)) continue;
                return null;
            }
            return null;
        }).when((Object)this.infoDAO)).visitChangeSetRevisions((String)Matchers.any(), (StoppableVisitor)Matchers.anyObject());
    }
}

