/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.spi.admin.data.ImportMode;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2MessageContext;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.svn.SvnChangePath;
import com.cenqua.fisheye.svn.SvnLogMessage;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import com.infinitydb.ItemSpace;
import java.util.Arrays;
import java.util.Date;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.NodeKind;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class Svn2MessageContextTest {
    private Svn2RepositoryEngine svn2RepositoryEngineMock;
    private DiffTextCache diffTextCacheMock;
    private SvnLogMessage svnLogMessageMock;
    private Svn2Cache svn2CacheMock;
    private SvnRevInfoDAO fileRevisionDAO;
    private String repositoryPrefix = "project1/";

    @Before
    public void setUp() throws Exception {
        SvnLogicalPathMatcher pathMatcher = new SvnLogicalPathMatcher();
        this.diffTextCacheMock = (DiffTextCache)Mockito.mock(DiffTextCache.class);
        this.fileRevisionDAO = (SvnRevInfoDAO)Mockito.mock(SvnRevInfoDAO.class);
        this.svn2CacheMock = (Svn2Cache)Mockito.mock(Svn2Cache.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.svn2CacheMock.getFileRevisionDAO()).thenReturn((Object)this.fileRevisionDAO);
        this.svn2RepositoryEngineMock = (Svn2RepositoryEngine)Mockito.mock(Svn2RepositoryEngine.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.svn2RepositoryEngineMock.getRepositoryInfo().getServerPath((Path)org.mockito.Matchers.any(Path.class), org.mockito.Matchers.anyLong())).thenAnswer(invocation -> {
            Path localPath = (Path)invocation.getArguments()[0];
            return new Path(new Path((CharSequence)this.repositoryPrefix), localPath).getPath();
        });
        Mockito.when((Object)this.svn2RepositoryEngineMock.getRepositoryInfo().getLocalPath(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyLong())).thenAnswer(invocation -> {
            String serverPath = (String)invocation.getArguments()[0];
            if (!serverPath.startsWith(this.repositoryPrefix)) {
                throw new IllegalStateException("Path " + serverPath + " doesn't start with repository prefix " + this.repositoryPrefix);
            }
            return new Path((CharSequence)serverPath.substring(this.repositoryPrefix.length()));
        });
        Mockito.when((Object)this.svn2RepositoryEngineMock.getRepositoryInfo().getPathMatcher()).thenReturn((Object)pathMatcher);
        Mockito.when((Object)this.svn2RepositoryEngineMock.getInternalRevisionCache()).thenReturn((Object)this.svn2CacheMock);
        this.svnLogMessageMock = (SvnLogMessage)Mockito.mock(SvnLogMessage.class);
        Mockito.when((Object)this.svnLogMessageMock.getAuthor()).thenReturn((Object)"author1");
        Mockito.when((Object)this.svnLogMessageMock.getDate()).thenReturn((Object)new Date(0L));
        Mockito.when((Object)this.svnLogMessageMock.getMessage()).thenReturn((Object)"some commit message");
    }

    @Test
    public void testGetMostSpecificChange() throws Exception {
        Path path = new Path((CharSequence)"tags/t1/src/java/Test.java");
        Mockito.when((Object)this.svnLogMessageMock.getChangePaths()).thenReturn(Arrays.asList(new SvnChangePath(this.repositoryPrefix + "tags/t1", 1L, "", ChangePath.Action.modify, NodeKind.dir), new SvnChangePath(this.repositoryPrefix + "tags/t1/src", 1L, "", ChangePath.Action.modify, NodeKind.dir), new SvnChangePath(this.repositoryPrefix + "tags/t1/src/java", 1L, "", ChangePath.Action.modify, NodeKind.dir)));
        Svn2MessageContext svn2MessageContext = new Svn2MessageContext(this.svn2RepositoryEngineMock, this.diffTextCacheMock, this.svnLogMessageMock);
        svn2MessageContext.getMostSpecificChange(path);
    }

    @Test
    public void testInsertFileRevision_insertsFileAndParentDirsIfStartRevWithNoImport() throws Exception {
        Mockito.when((Object)this.svn2RepositoryEngineMock.getRepositoryInfo().getStartRev()).thenReturn((Object)7L);
        Mockito.when((Object)this.svn2RepositoryEngineMock.getRepositoryInfo().getImportMode()).thenReturn((Object)ImportMode.NO_IMPORT);
        Mockito.when((Object)this.svnLogMessageMock.getChangePaths()).thenReturn(Arrays.asList(new SvnChangePath(this.repositoryPrefix + "trunk/a", 1L, "", ChangePath.Action.modify, NodeKind.dir), new SvnChangePath(this.repositoryPrefix + "trunk/a/b/c/d.txt", 1L, "", ChangePath.Action.modify, NodeKind.file)));
        Mockito.when((Object)this.fileRevisionDAO.getLatestPathChange((Path)org.mockito.Matchers.any(Path.class))).thenReturn((Object)-1L);
        Mockito.when((Object)this.fileRevisionDAO.getPureRevId((Path)org.mockito.Matchers.any(Path.class), org.mockito.Matchers.anyLong())).thenReturn((Object)-1);
        Svn2MessageContext svn2MessageContext = new Svn2MessageContext(this.svn2RepositoryEngineMock, this.diffTextCacheMock, this.svnLogMessageMock);
        svn2MessageContext.setDb((ItemSpace)Mockito.mock(ItemSpace.class));
        Path path = new Path((CharSequence)"trunk/a/b/c/d.txt");
        SvnRevInfo revInfo = svn2MessageContext.createFileRevision(path);
        svn2MessageContext.insertFileRevision(revInfo);
        ((SvnRevInfoDAO)Mockito.verify((Object)this.fileRevisionDAO)).insertNew((SvnRevInfo)org.mockito.Matchers.argThat(this.revInfoWithPathMatcher(path)), (AncestorLink)org.mockito.Matchers.any(AncestorLink.class), org.mockito.Matchers.anyBoolean());
        ((SvnRevInfoDAO)Mockito.verify((Object)this.fileRevisionDAO)).insertNew((SvnRevInfo)org.mockito.Matchers.argThat(this.revInfoWithPathMatcher(path.getParent())), (AncestorLink)org.mockito.Matchers.any(AncestorLink.class), org.mockito.Matchers.anyBoolean());
        ((SvnRevInfoDAO)Mockito.verify((Object)this.fileRevisionDAO)).insertNew((SvnRevInfo)org.mockito.Matchers.argThat(this.revInfoWithPathMatcher(path.getParent().getParent())), (AncestorLink)org.mockito.Matchers.any(AncestorLink.class), org.mockito.Matchers.anyBoolean());
        ((SvnRevInfoDAO)Mockito.verify((Object)this.fileRevisionDAO, (VerificationMode)Mockito.never())).insertNew((SvnRevInfo)org.mockito.Matchers.argThat(this.revInfoWithPathMatcher(path.getParent().getParent().getParent())), (AncestorLink)org.mockito.Matchers.any(AncestorLink.class), org.mockito.Matchers.anyBoolean());
    }

    private Matcher<SvnRevInfo> revInfoWithPathMatcher(Path path) {
        return Matchers.hasProperty((String)"path", (Matcher)Matchers.is((Object)path));
    }
}

