/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.svn.Svn2ChangesetDiffSummary;
import com.atlassian.fisheye.svn.Svn2Infill2Processor;
import com.atlassian.fisheye.svn.Svn2MessageContext;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.AllowRules;
import com.cenqua.fisheye.svn.SvnChangePath;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnScmConfig;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.util.AntGlob;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class Svn2Infill2ProcessorTest {
    private Svn2Infill2Processor infillProcessor;
    private SvnThrottledClient svnClient;
    private Svn2MessageContext messageContext;
    private final Path rootPath = Path.ROOT;
    private final Path excludedFilePath = new Path((CharSequence)"excluded_file2.txt");
    private final Path includedFilePath = new Path((CharSequence)"included_file2.txt");

    @Before
    public void setUp() throws Exception {
        long rev1 = 1L;
        String rootUrl = "foo";
        String excludedFileSubPath = "/" + this.excludedFilePath;
        String excludedFileUrl = rootUrl + excludedFileSubPath;
        String includedFileSubPath = "/" + this.includedFilePath;
        String includedFileUrl = rootUrl + includedFileSubPath;
        Info rootInfo = Svn2Infill2ProcessorTest.newInfo(rootUrl, NodeKind.dir, rootUrl, 0L);
        Info excludedFileInfo = Svn2Infill2ProcessorTest.newInfo(excludedFileUrl, NodeKind.file, rootUrl, 15L);
        Info includedFileInfo = Svn2Infill2ProcessorTest.newInfo(includedFileUrl, NodeKind.file, rootUrl, 12L);
        RepositoryConfig repoConfig = (RepositoryConfig)Mockito.mock(RepositoryConfig.class);
        Mockito.when((Object)repoConfig.getTempDir()).thenReturn((Object)File.createTempFile("foo", "bar"));
        Mockito.when((Object)repoConfig.getAllowRules()).thenReturn((Object)new AllowRules((List)ImmutableList.of(), (List)ImmutableList.of((Object)new AntGlob("**/excluded_file*"))));
        SvnScmConfig svnScmConfig = (SvnScmConfig)Mockito.mock(SvnScmConfig.class);
        Mockito.when((Object)svnScmConfig.getRepoUrl()).thenReturn((Object)rootUrl);
        Mockito.when((Object)svnScmConfig.getPathMatcher()).thenReturn((Object)new SvnLogicalPathMatcher());
        Mockito.when((Object)repoConfig.getScmConfig()).thenReturn((Object)svnScmConfig);
        SvnRepositoryInfo repositoryInfo = new SvnRepositoryInfo(repoConfig);
        Revision.Number rev = new Revision.Number(rev1);
        this.svnClient = (SvnThrottledClient)Mockito.mock(SvnThrottledClient.class);
        ((SvnThrottledClient)Mockito.doAnswer(invocation -> {
            InfoCallback callback = (InfoCallback)invocation.getArgumentAt(4, InfoCallback.class);
            callback.singleInfo(rootInfo);
            callback.singleInfo(excludedFileInfo);
            callback.singleInfo(includedFileInfo);
            return null;
        }).when((Object)this.svnClient)).info((String)org.mockito.Matchers.eq((Object)rootUrl), (Revision)org.mockito.Matchers.eq((Object)rev), (Revision)org.mockito.Matchers.eq((Object)rev), (Depth)org.mockito.Matchers.eq((Object)Depth.infinity), (InfoCallback)org.mockito.Matchers.any(InfoCallback.class));
        SvnChangePath rootChangePath = new SvnChangePath("/", -1L, null, ChangePath.Action.add, NodeKind.dir);
        SvnChangePath includedFileChangePath = new SvnChangePath(includedFileSubPath, -1L, null, ChangePath.Action.add, NodeKind.file);
        this.messageContext = (Svn2MessageContext)Mockito.mock(Svn2MessageContext.class);
        Mockito.when((Object)this.messageContext.getRevision()).thenReturn((Object)rev1);
        Mockito.when((Object)this.messageContext.getRepositoryInfo()).thenReturn((Object)repositoryInfo);
        Mockito.when((Object)this.messageContext.getChangePaths()).thenReturn((Object)ImmutableList.of((Object)rootChangePath, (Object)includedFileChangePath));
        Mockito.when((Object)this.messageContext.isPartOfAdd(rootChangePath)).thenReturn((Object)false);
        Mockito.when((Object)this.messageContext.isPartOfAdd(includedFileChangePath)).thenReturn((Object)true);
        Mockito.when((Object)this.messageContext.getMostSpecificChange(this.rootPath)).thenReturn((Object)rootChangePath);
        Mockito.when((Object)this.messageContext.getMostSpecificChange(this.excludedFilePath)).thenReturn((Object)rootChangePath);
        Mockito.when((Object)this.messageContext.getMostSpecificChange(this.includedFilePath)).thenReturn((Object)includedFileChangePath);
        Svn2RepositoryEngine repositoryEngine = (Svn2RepositoryEngine)Mockito.mock(Svn2RepositoryEngine.class);
        Mockito.when((Object)repositoryEngine.getRepositoryInfo()).thenReturn((Object)repositoryInfo);
        this.infillProcessor = new Svn2Infill2Processor(repositoryEngine);
    }

    @Test
    public void testCreateDiffSummaryOnRootChange() throws Exception {
        Svn2ChangesetDiffSummary diffSummary = this.infillProcessor.createDiffSummary(this.messageContext, this.svnClient);
        Iterable diffPaths = diffSummary.getDiffPaths();
        Assert.assertThat((Object)diffPaths, (Matcher)Matchers.containsInAnyOrder((Object[])new Path[]{this.rootPath, this.includedFilePath}));
    }

    private static Info newInfo(String url, NodeKind nodeKind, String reposRootUrl, long reposSize) {
        return new Info(null, null, url, 1L, nodeKind, reposRootUrl, null, Long.MIN_VALUE, Long.MIN_VALUE, null, null, false, null, null, Long.MIN_VALUE, Long.MIN_VALUE, null, null, Long.MIN_VALUE, reposSize, null, null);
    }
}

