/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.svn.Svn2AncestryProcessor;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.cenqua.fisheye.Path;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class Svn2AncestryProcessorTest {
    @Test
    public void testGetLatestDirChangeUpto5_5_5() {
        this.testGetLatestDirChangeUpto(5, 5, 5);
    }

    @Test
    public void testGetLatestDirChangeUpto100_5_5() {
        this.testGetLatestDirChangeUpto(100, 5, 5);
    }

    @Test
    public void testGetLatestDirChangeUpto200_5_5() {
        this.testGetLatestDirChangeUpto(200, 5, 5);
    }

    @Test
    public void testGetLatestDirChangeUpto5_1_100() {
        this.testGetLatestDirChangeUpto(5, 1, 100);
    }

    public void testGetLatestDirChangeUpto(int noFiles, int noDirs, int depth) {
        Svn2Cache cacheMock = (Svn2Cache)Mockito.mock(Svn2Cache.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ArgumentCaptor filePathCaptor = ArgumentCaptor.forClass(Path.class);
        Mockito.when((Object)cacheMock.listFiles((Path)filePathCaptor.capture())).thenAnswer(invocation -> Svn2AncestryProcessorTest.listFilesForPath((Path)filePathCaptor.getValue(), noFiles));
        ArgumentCaptor dirPathCaptor = ArgumentCaptor.forClass(Path.class);
        Mockito.when((Object)cacheMock.listDirs((Path)dirPathCaptor.capture())).thenAnswer(invocation -> Svn2AncestryProcessorTest.listDirsForPath((Path)dirPathCaptor.getValue(), noDirs, depth));
        Mockito.when((Object)cacheMock.getFileRevisionDAO().getLatestPathChangeUpto((Path)Matchers.any(Path.class), Matchers.anyLong(), Matchers.anyBoolean())).thenReturn((Object)777L);
        Assert.assertThat((Object)Svn2AncestryProcessor.getLatestDirChangeUpto((Svn2Cache)cacheMock, (Path)new Path((CharSequence)"/root"), (long)0L), (Matcher)org.hamcrest.Matchers.equalTo((Object)777L));
    }

    private static Path[] listFilesForPath(Path path, int size) {
        Path[] paths = new Path[size];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = new Path(path, "abcefghijklmnopqrstuvxyzabcefghijklmnopqrstuvxyz.file" + i);
        }
        return paths;
    }

    private static Path[] listDirsForPath(Path path, int size, int depth) {
        if (path.numComponents() >= depth) {
            return new Path[0];
        }
        Path[] paths = new Path[size];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = new Path(path, "ABCEFGHIJKLMNOPQRSTUVXYZABCEFGHIJKLMNOPQRSTUVXYZ.dir" + i);
        }
        return paths;
    }
}

