/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.event.UserRenamedEvent;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.stars.DefaultStarManager;
import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.Star;
import com.atlassian.fisheye.stars.model.StarFactory;
import com.atlassian.fisheye.stars.model.StarKey;
import com.atlassian.fisheye.stars.model.UserStar;
import com.atlassian.fisheye.stars.model.UserStarFactory;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.user.UserTestHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class DefaultStarManagerTest {
    DefaultStarManager starManager;
    @Autowired
    CurrentSessionProvider currentSessionProvider;
    @Autowired
    TxTemplate txTemplate;

    @Before
    public void setUp() throws Exception {
        this.starManager = new DefaultStarManager((EventPublisher)Mockito.mock(EventPublisher.class), this.currentSessionProvider, this.txTemplate);
        UserStarFactory starFactory = new UserStarFactory();
        UserManager userManager = (UserManager)Mockito.mock(UserManager.class);
        starFactory.setUserManager(userManager);
        this.starManager.setStarFactories(new StarFactory[]{starFactory});
        Mockito.when((Object)userManager.existsLicensedUser(org.mockito.Matchers.anyString())).thenReturn((Object)true);
        ApplicationContext context = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        Mockito.when((Object)context.getBeansOfType(UserManager.class)).thenReturn((Object)ImmutableMap.of((Object)"userManager", (Object)userManager));
        SpringContext.setApplicationContext((ApplicationContext)context);
    }

    @After
    public void tearDown() throws Exception {
        SpringContext.setApplicationContext(null);
    }

    @Test
    public void shouldIgnoreUsernameCase() throws Exception {
        this.starManager.addStar((StarKey)UserStar.forUser((String)"BOB"), UserTestHelper.createPrincipal("TOM"));
        this.starManager.addStar((StarKey)UserStar.forUser((String)"JoHn"), UserTestHelper.createPrincipal("bob"));
        List tomStars = this.starManager.getStarsForUser("tom");
        List bobStars = this.starManager.getStarsForUser("BOB");
        List johnStars = this.starManager.getStarsForUser("john");
        UserStar recentBobStar = (UserStar)this.starManager.mostRecentlyAddedStar(StarType.USER, (Principal)UserTestHelper.createPrincipal("BoB"));
        Star bobStar = this.starManager.getStar((StarKey)recentBobStar, UserTestHelper.createPrincipal("bOB"));
        MatcherAssert.assertThat((Object)tomStars, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)bobStars, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)johnStars, (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)recentBobStar.getFEUsername(), (Matcher)Matchers.equalTo((Object)"john"));
        MatcherAssert.assertThat((Object)recentBobStar, (Matcher)Matchers.equalTo((Object)bobStar));
    }

    @Test
    public void shouldHandleRenames() throws Exception {
        this.starManager.addStar((StarKey)UserStar.forUser((String)"BOB"), UserTestHelper.createPrincipal("TOM"));
        this.starManager.addStar((StarKey)UserStar.forUser((String)"JoHn"), UserTestHelper.createPrincipal("bob"));
        this.starManager.onUserRenamedEvent(new UserRenamedEvent("BoB", "Bobby"));
        this.currentSessionProvider.currentSession().flush();
        this.currentSessionProvider.currentSession().clear();
        List bobbyStars = this.starManager.getStarsForUser("bobby");
        List bobStars = this.starManager.getStarsForUser("bob");
        List tomStars = this.starManager.getStarsForUser("tom");
        MatcherAssert.assertThat((Object)bobStars, (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)bobbyStars, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((UserStar)Iterables.getOnlyElement((Iterable)tomStars)).getFEUsername(), (Matcher)Matchers.equalTo((Object)"bobby"));
    }
}

