/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.impl;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.data.WatchData;
import com.atlassian.fisheye.spi.impl.WatchServiceImpl;
import com.atlassian.fisheye.spi.services.WatchService;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.Watch;
import com.cenqua.fisheye.web.WatchManager;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class WatchServiceImplTest {
    private static final FecruUser USER = new FecruUser("fred");
    private static final Watch WATCH1 = new Watch(USER, "repo1", Path.ROOT, new WaybackSpec());
    private static final Watch WATCH2 = new Watch(USER, "repo2", new Path((CharSequence)"trunk"), null);
    private static final WatchData WATCH_DATA_1 = new WatchData("repo1", "", "fred", "br=dev");
    private static final WatchData WATCH_DATA_2 = new WatchData("repo2", "trunk", "fred");
    private RepositoryHandle dummyRepo;
    @Mock
    private WatchManager watchManager;
    @Mock
    private UserManager userManager;
    @Mock
    private RepositoryManager repositoryManager;
    private WatchService watchService;

    @Before
    public void setUp() throws Exception {
        this.watchService = new WatchServiceImpl(this.watchManager, this.userManager, this.repositoryManager);
        this.dummyRepo = new RepositoryHandle(null, null, null, null);
    }

    @Test
    public void testGetWatchesForUser() throws Exception {
        this.addSuccessfulValidationExpectations();
        Mockito.when((Object)this.watchManager.getWatchesForUser("fred")).thenReturn((Object)ImmutableList.of((Object)WATCH1, (Object)WATCH2));
        Iterable fredsWatches = this.watchService.getWatchesForUser("fred");
        Assert.assertThat((Object)Iterables.size((Iterable)fredsWatches), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((Object)ImmutableSet.copyOf((Iterable)fredsWatches), (Matcher)Matchers.equalTo((Object)ImmutableSet.of((Object)WATCH_DATA_1, (Object)WATCH_DATA_2)));
    }

    @Test
    public void testGetWatchesForUser_wrongUser() throws Exception {
        this.addValidationExpectations(null, null);
        try {
            this.watchService.getWatchesForUser("barney");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.watchManager});
        }
    }

    @Test
    public void testGetWatchesForRepo() throws Exception {
        this.addSuccessfulValidationExpectations();
        Mockito.when((Object)this.watchManager.getWatchesForRep("repo2")).thenReturn((Object)ImmutableList.of((Object)WATCH2));
        Iterable repoWatches = this.watchService.getWatchesForRepo("repo2");
        Assert.assertThat((Object)Iterables.getOnlyElement((Iterable)repoWatches), (Matcher)Matchers.equalTo((Object)WATCH_DATA_2));
    }

    @Test
    public void testGetWatchesForRepo_wrongRepo() throws Exception {
        this.addValidationExpectations(null, null);
        try {
            this.watchService.getWatchesForRepo("norepo");
        }
        catch (IllegalArgumentException e) {
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.watchManager});
        }
    }

    @Test
    public void testRemoveWatch() {
        Mockito.when((Object)this.watchManager.getWatch(WATCH1.getUser().getUsername(), WATCH1.getRep(), WATCH1.getPath(), WATCH1.getConstraint())).thenReturn((Object)WATCH1);
        this.watchService.removeWatch(WATCH_DATA_1);
        ((WatchManager)Mockito.verify((Object)this.watchManager)).deleteWatch(WATCH1.getId().longValue());
    }

    @Test
    public void testAddWatch() throws Exception {
        this.addSuccessfulValidationExpectations();
        Mockito.when((Object)this.watchManager.getWatch("fred", "repo1", new Path((CharSequence)"trunk"), WATCH1.getConstraint())).thenReturn(null);
        Mockito.when((Object)this.watchManager.addWatch("fred", "repo1", new Path((CharSequence)"trunk"), WATCH1.getConstraint())).thenReturn((Object)WATCH1);
        boolean added = this.watchService.addWatch(new WatchData("repo1", "trunk", "fred", "br=dev"));
        Assert.assertThat((Object)added, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAddWatch_alreadyExists() throws Exception {
        this.addSuccessfulValidationExpectations();
        Mockito.when((Object)this.watchManager.getWatch("fred", "repo1", new Path((CharSequence)"trunk"), WATCH1.getConstraint())).thenReturn((Object)WATCH1);
        boolean added = this.watchService.addWatch(new WatchData("repo1", "trunk", "fred", "br=dev"));
        Assert.assertThat((Object)added, (Matcher)Matchers.is((Object)false));
        ((WatchManager)Mockito.verify((Object)this.watchManager, (VerificationMode)Mockito.never())).addWatch(org.mockito.Matchers.anyString(), org.mockito.Matchers.anyString(), (Path)org.mockito.Matchers.any(Path.class), (WaybackSpec)org.mockito.Matchers.any(WaybackSpec.class));
    }

    @Test
    public void testAddWatch_invalidUser() throws Exception {
        this.addValidationExpectations(null, this.dummyRepo);
        try {
            this.watchService.addWatch(WATCH_DATA_1);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.watchManager});
        }
    }

    @Test
    public void testAddWatch_invalidRepo() throws Exception {
        this.addValidationExpectations(USER, null);
        try {
            this.watchService.addWatch(WATCH_DATA_1);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.watchManager});
        }
    }

    private void addSuccessfulValidationExpectations() throws Exception {
        this.addValidationExpectations(USER, this.dummyRepo);
    }

    private void addValidationExpectations(FecruUser fred, RepositoryHandle repositoryHandle) throws Exception {
        Mockito.when((Object)this.userManager.getLicensedUser(org.mockito.Matchers.anyString())).thenReturn((Object)fred);
        Mockito.when((Object)this.userManager.existsLicensedUser(org.mockito.Matchers.anyString())).thenReturn((Object)(fred != null ? 1 : 0));
        Mockito.when((Object)this.repositoryManager.getRepository(org.mockito.Matchers.anyString())).thenReturn((Object)repositoryHandle);
    }

    static {
        WATCH1.getConstraint().setBranch("dev");
        WATCH1.setId(Long.valueOf(1L));
        WATCH2.setId(Long.valueOf(2L));
    }
}

