/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.impl;

import com.atlassian.crucible.spi.impl.DefaultSPIUtils;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.fisheye.spi.data.CvsRepositoryData;
import com.atlassian.fisheye.spi.data.GitRepositoryData;
import com.atlassian.fisheye.spi.data.HgRepositoryData;
import com.atlassian.fisheye.spi.data.P4RepositoryData;
import com.atlassian.fisheye.spi.data.RepositoryDataFE;
import com.atlassian.fisheye.spi.data.SvnRepositoryData;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.CvsRepType;
import com.cenqua.fisheye.config1.GitRepType;
import com.cenqua.fisheye.config1.HgRepType;
import com.cenqua.fisheye.config1.P4RepType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.google.common.base.Function;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SpiUtilsTest {
    private static final String REPOSITORY_NAME = "test";
    private RepositoryHandle repositoryHandle;
    private RepositoryEngine repositoryEngine;
    private RepositoryConfig repositoryConfig;
    private RepositoryStatus repositoryStatus;
    private RepositoryType repositoryType;
    private DefaultSPIUtils spiUtils;
    private SPIUserUtils spiUserUtils;
    private RootConfig rootConfig;
    private SourceFactory sourceFactory;
    private RepositoryManager repositoryManager;

    @Before
    public void setUp() throws Exception {
        this.repositoryHandle = (RepositoryHandle)Mockito.mock(RepositoryHandle.class);
        this.repositoryEngine = (RepositoryEngine)Mockito.mock(RepositoryEngine.class);
        this.repositoryManager = (RepositoryManager)Mockito.mock(RepositoryManager.class);
        this.repositoryConfig = (RepositoryConfig)Mockito.mock(RepositoryConfig.class);
        this.repositoryStatus = (RepositoryStatus)Mockito.mock(RepositoryStatus.class);
        this.repositoryType = (RepositoryType)Mockito.mock(RepositoryType.class);
        this.spiUserUtils = (SPIUserUtils)Mockito.mock(SPIUserUtils.class);
        this.rootConfig = (RootConfig)Mockito.mock(RootConfig.class);
        this.sourceFactory = (SourceFactory)Mockito.mock(SourceFactory.class);
        Mockito.when((Object)this.repositoryHandle.getName()).thenReturn((Object)REPOSITORY_NAME);
        Mockito.when((Object)this.repositoryHandle.getCfg()).thenReturn((Object)this.repositoryConfig);
        Mockito.when((Object)this.repositoryHandle.getStatus()).thenReturn((Object)this.repositoryStatus);
        Mockito.when((Object)this.repositoryHandle.getStateDescription()).thenReturn((Object)RepositoryDataFE.RepositoryState.RUNNING.getDescription());
        Mockito.when((Object)this.repositoryConfig.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryConfig.getRepositoryTypeConfig()).thenReturn((Object)this.repositoryType);
        Mockito.when((Object)this.repositoryStatus.isInitialCrucibleIndexingComplete()).thenReturn((Object)true);
        Mockito.when((Object)this.rootConfig.getRepositoryManager()).thenReturn((Object)this.repositoryManager);
        Mockito.when((Object)this.repositoryManager.getRepository((String)Matchers.eq((Object)REPOSITORY_NAME))).thenReturn((Object)this.repositoryHandle);
        Mockito.when((Object)this.repositoryHandle.withEngine((Function)Matchers.any(Function.class))).thenAnswer(invocation -> {
            Function operation = (Function)invocation.getArguments()[0];
            return operation.apply((Object)this.repositoryEngine);
        });
        this.spiUtils = new DefaultSPIUtils(this.rootConfig, this.sourceFactory, this.spiUserUtils, null);
    }

    @Test
    public void testCreateRepositoryDataObject_CVS() throws Exception {
        CvsRepType cvsRepository = (CvsRepType)Mockito.mock(CvsRepType.class);
        Mockito.when((Object)this.repositoryConfig.getRepositoryType()).thenReturn((Object)ScmType.CVS);
        Mockito.when((Object)this.repositoryType.getCvs()).thenReturn((Object)cvsRepository);
        Mockito.when((Object)cvsRepository.getDir()).thenReturn((Object)"test.dir");
        RepositoryDataFE repositoryData = this.spiUtils.createRepositoryDataFEFrom(this.repositoryHandle);
        junit.framework.Assert.assertTrue((boolean)(repositoryData instanceof CvsRepositoryData));
        Assert.assertEquals((Object)REPOSITORY_NAME, (Object)repositoryData.getName());
        Assert.assertEquals((Object)RepositoryDataFE.RepositoryState.RUNNING, (Object)repositoryData.getState());
        Assert.assertEquals((Object)true, (Object)repositoryData.isEnabled());
        Assert.assertEquals((Object)true, (Object)repositoryData.isFinishedFullSlurp());
        Assert.assertEquals((Object)"test.dir", (Object)((CvsRepositoryData)repositoryData).getDir());
    }

    @Test
    public void testCreateRepositoryDataObject_SVN() throws Exception {
        SvnRepType svnRepository = (SvnRepType)Mockito.mock(SvnRepType.class);
        Mockito.when((Object)this.repositoryConfig.getRepositoryType()).thenReturn((Object)ScmType.SVN);
        Mockito.when((Object)this.repositoryType.getSvn()).thenReturn((Object)svnRepository);
        Mockito.when((Object)svnRepository.getPath()).thenReturn((Object)"test.path");
        Mockito.when((Object)svnRepository.getUrl()).thenReturn((Object)"test.url");
        RepositoryDataFE repositoryData = this.spiUtils.createRepositoryDataFEFrom(this.repositoryHandle);
        junit.framework.Assert.assertTrue((boolean)(repositoryData instanceof SvnRepositoryData));
        Assert.assertEquals((Object)REPOSITORY_NAME, (Object)repositoryData.getName());
        Assert.assertEquals((Object)RepositoryDataFE.RepositoryState.RUNNING, (Object)repositoryData.getState());
        Assert.assertEquals((Object)true, (Object)repositoryData.isEnabled());
        Assert.assertEquals((Object)true, (Object)repositoryData.isFinishedFullSlurp());
        Assert.assertEquals((Object)"test.path", (Object)((SvnRepositoryData)repositoryData).getPath());
        Assert.assertEquals((Object)"test.url", (Object)((SvnRepositoryData)repositoryData).getUrl());
    }

    @Test
    public void testCreateRepositoryDataObject_Hg() throws Exception {
        HgRepType hgRepository = (HgRepType)Mockito.mock(HgRepType.class);
        Mockito.when((Object)this.repositoryConfig.getRepositoryType()).thenReturn((Object)ScmType.HG);
        Mockito.when((Object)this.repositoryType.getHg()).thenReturn((Object)hgRepository);
        Mockito.when((Object)hgRepository.getLocation()).thenReturn((Object)"test.location");
        RepositoryDataFE repositoryData = this.spiUtils.createRepositoryDataFEFrom(this.repositoryHandle);
        junit.framework.Assert.assertTrue((boolean)(repositoryData instanceof HgRepositoryData));
        Assert.assertEquals((Object)REPOSITORY_NAME, (Object)repositoryData.getName());
        Assert.assertEquals((Object)RepositoryDataFE.RepositoryState.RUNNING, (Object)repositoryData.getState());
        Assert.assertEquals((Object)true, (Object)repositoryData.isEnabled());
        Assert.assertEquals((Object)true, (Object)repositoryData.isFinishedFullSlurp());
        Assert.assertEquals((Object)"test.location", (Object)((HgRepositoryData)repositoryData).getLocation());
    }

    @Test
    public void testCreateRepositoryDataObject_P4() throws Exception {
        P4RepType p4Repository = (P4RepType)Mockito.mock(P4RepType.class);
        Mockito.when((Object)this.repositoryConfig.getRepositoryType()).thenReturn((Object)ScmType.P4);
        Mockito.when((Object)this.repositoryType.getPerforce()).thenReturn((Object)p4Repository);
        Mockito.when((Object)p4Repository.getPath()).thenReturn((Object)"test.path");
        Mockito.when((Object)p4Repository.getPort()).thenReturn((Object)BigInteger.valueOf(1L));
        Mockito.when((Object)p4Repository.isSetPort()).thenReturn((Object)true);
        Mockito.when((Object)p4Repository.getServer()).thenReturn((Object)"test.server");
        RepositoryDataFE repositoryData = this.spiUtils.createRepositoryDataFEFrom(this.repositoryHandle);
        junit.framework.Assert.assertTrue((boolean)(repositoryData instanceof P4RepositoryData));
        Assert.assertEquals((Object)REPOSITORY_NAME, (Object)repositoryData.getName());
        Assert.assertEquals((Object)RepositoryDataFE.RepositoryState.RUNNING, (Object)repositoryData.getState());
        Assert.assertEquals((Object)true, (Object)repositoryData.isEnabled());
        Assert.assertEquals((Object)true, (Object)repositoryData.isFinishedFullSlurp());
        Assert.assertEquals((Object)"test.path", (Object)((P4RepositoryData)repositoryData).getPath());
        Assert.assertEquals((long)1L, (long)((P4RepositoryData)repositoryData).getPort().intValue());
        Assert.assertEquals((Object)"test.server", (Object)((P4RepositoryData)repositoryData).getServer());
    }

    @Test
    public void testCreateRepositoryDataObject_GIT() throws Exception {
        GitRepType gitRepository = (GitRepType)Mockito.mock(GitRepType.class);
        Mockito.when((Object)this.repositoryConfig.getRepositoryType()).thenReturn((Object)ScmType.GIT);
        Mockito.when((Object)this.repositoryType.getGit()).thenReturn((Object)gitRepository);
        Mockito.when((Object)gitRepository.getLocation()).thenReturn((Object)"test.location");
        Mockito.when((Object)gitRepository.getPath()).thenReturn((Object)"test.path");
        RepositoryDataFE repositoryData = this.spiUtils.createRepositoryDataFEFrom(this.repositoryHandle);
        junit.framework.Assert.assertTrue((boolean)(repositoryData instanceof GitRepositoryData));
        Assert.assertEquals((Object)REPOSITORY_NAME, (Object)repositoryData.getName());
        Assert.assertEquals((Object)RepositoryDataFE.RepositoryState.RUNNING, (Object)repositoryData.getState());
        Assert.assertEquals((Object)true, (Object)repositoryData.isEnabled());
        Assert.assertEquals((Object)true, (Object)repositoryData.isFinishedFullSlurp());
        Assert.assertEquals((Object)"test.location", (Object)((GitRepositoryData)repositoryData).getLocation());
        Assert.assertEquals((Object)"test.path", (Object)((GitRepositoryData)repositoryData).getPath());
    }

    @Test
    public void testWithRepository() throws Exception {
        Function repoOperation = (Function)Mockito.mock(Function.class);
        this.spiUtils.withRepository(REPOSITORY_NAME, repoOperation);
        ((SPIUserUtils)Mockito.verify((Object)this.spiUserUtils, (VerificationMode)Mockito.times((int)1))).requireUserHasPermissionToAccess((String)Matchers.eq((Object)REPOSITORY_NAME));
        ((Function)Mockito.verify((Object)repoOperation, (VerificationMode)Mockito.times((int)1))).apply(Matchers.any(RepositoryEngine.class));
    }
}

