/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.impl;

import com.atlassian.crucible.spi.impl.DefaultSPIUserUtils;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SPIUserUtilsTest {
    private RootConfig oldRootConfig;
    private SPIUserUtils spiUserUtils;
    private EffectiveUserProvider effectiveUserProvider;
    private UserManager userManager;
    private GlobalPermissionManager globalPermissionManager;

    @Before
    public void setUp() throws Exception {
        this.oldRootConfig = AppConfig.getsConfig();
        RootConfig rootConfig = (RootConfig)Mockito.mock(RootConfig.class);
        Mockito.when((Object)rootConfig.getTimezone()).thenReturn((Object)TimeZone.getTimeZone("GMT-8:00"));
        AppConfig.resetConfig((RootConfig)rootConfig);
        this.userManager = (UserManager)Mockito.mock(UserManager.class);
        this.effectiveUserProvider = (EffectiveUserProvider)Mockito.mock(EffectiveUserProvider.class);
        this.globalPermissionManager = (GlobalPermissionManager)Mockito.mock(GlobalPermissionManager.class);
        this.spiUserUtils = new DefaultSPIUserUtils(this.userManager, this.effectiveUserProvider, this.globalPermissionManager);
    }

    @After
    public void tearDown() throws Exception {
        AppConfig.resetConfig((RootConfig)this.oldRootConfig);
    }

    @Test
    public void testGetUserTimezone() throws Exception {
        Mockito.when((Object)this.effectiveUserProvider.getEffectivePrincipal()).thenReturn((Object)Principal.Anonymous.ANON);
        Assert.assertEquals((String)"Anonymous timezone is the server timezone", (Object)TimeZone.getTimeZone("GMT-8:00"), (Object)this.spiUserUtils.getUserTimezone());
        String username = "seb";
        FecruUser user = new FecruUser(username);
        Mockito.when((Object)this.userManager.getLicensedUser(username)).thenReturn((Object)user);
        user.setUserProfile(new UserProfile());
        UserLogin login = new UserLogin(new FecruUser(username), null, null);
        Mockito.when((Object)this.effectiveUserProvider.getEffectivePrincipal()).thenReturn((Object)login);
        Assert.assertEquals((String)"User default is the server timezone", (Object)TimeZone.getTimeZone("GMT-8:00"), (Object)this.spiUserUtils.getUserTimezone());
        this.userManager.getLicensedUser(username).getUserProfile().setTimezone("GMT+10:00");
        Assert.assertEquals((String)"User timezone is the user profile timezone", (Object)TimeZone.getTimeZone("GMT+10:00"), (Object)this.spiUserUtils.getUserTimezone());
        this.userManager.getLicensedUser(username).getUserProfile().setTimezone("");
        Assert.assertEquals((String)"Empty user timezone defaults to server timezone", (Object)TimeZone.getTimeZone("GMT-8:00"), (Object)this.spiUserUtils.getUserTimezone());
    }
}

