/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.impl;

import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.spi.impl.DefaultRepositoryService;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultRepositoryServiceTest {
    public static final String REPO_NAME = "repo1";
    @Mock
    SPIUtils spiUtils;
    @Mock
    UserManager userManager;
    @Mock
    EffectiveUserProvider effectiveUserProvider;
    @Mock
    RepositoryManager repositoryManager;
    @Mock
    RepositoryHandle repositoryHandle;
    @Mock
    RepositoryEngine repositoryEngine;
    @Mock
    RevisionCache revisionCache;
    @Mock
    Principal principal;
    DefaultRepositoryService repositoryService;

    @Before
    public void setUp() throws Exception {
        this.repositoryService = new DefaultRepositoryService(this.spiUtils, this.userManager, this.effectiveUserProvider, this.repositoryManager);
        Mockito.when((Object)this.effectiveUserProvider.getEffectivePrincipal()).thenReturn((Object)this.principal);
        Mockito.when((Object)this.repositoryEngine.getRevisionCache()).thenReturn((Object)this.revisionCache);
        Mockito.when((Object)this.repositoryHandle.withEngine((Function)org.mockito.Matchers.any(Function.class))).thenAnswer(invocation -> {
            Function o = (Function)invocation.getArguments()[0];
            return o.apply((Object)this.repositoryEngine);
        });
    }

    @Test
    public void testListCommittersForPath() throws Exception {
        ImmutableList authorList = ImmutableList.of((Object)"author1", (Object)"author2");
        Path path = new Path((CharSequence)"foo");
        Mockito.when((Object)this.revisionCache.findAuthors(path)).thenReturn((Object)authorList);
        this.mockRepoAvailability(true, true);
        List result = this.repositoryService.listCommitters(REPO_NAME, path);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)authorList));
    }

    @Test
    public void testListCommitters() throws Exception {
        ImmutableList authorList = ImmutableList.of((Object)"author3", (Object)"author4");
        Mockito.when((Object)this.revisionCache.findAuthors(Path.ROOT)).thenReturn((Object)authorList);
        this.mockRepoAvailability(true, true);
        List result = this.repositoryService.listCommitters(REPO_NAME);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)authorList));
    }

    @Test
    public void testCountCommitters() throws Exception {
        ImmutableList authorList = ImmutableList.of((Object)"author3", (Object)"author4", (Object)"author1");
        Path path = new Path((CharSequence)"foo");
        ((RevisionCache)Mockito.doAnswer(arg_0 -> DefaultRepositoryServiceTest.lambda$testCountCommitters$78((List)authorList, arg_0)).when((Object)this.revisionCache)).visitAuthors((Path)org.mockito.Matchers.same((Object)path), (StoppableVisitor)org.mockito.Matchers.any(StoppableVisitor.class));
        this.mockRepoAvailability(true, true);
        int count = this.repositoryService.countCommitters(REPO_NAME, path);
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test(expected=IllegalStateException.class)
    public void testListCommitters_failsWhenStopped() throws Exception {
        this.mockRepoAvailability(false, true);
        this.repositoryService.listCommitters(REPO_NAME);
    }

    @Test(expected=IllegalStateException.class)
    public void testListCommitters_failsWhenNonExistant() throws Exception {
        Mockito.when((Object)this.repositoryManager.getRepository(REPO_NAME)).thenReturn(null);
        this.repositoryService.listCommitters(REPO_NAME);
    }

    @Test(expected=IllegalStateException.class)
    public void testListCommitters_failsWhenNotPermitted() throws Exception {
        this.mockRepoAvailability(true, false);
        this.repositoryService.listCommitters(REPO_NAME);
    }

    private void mockRepoAvailability(boolean running, boolean permitted) {
        Mockito.when((Object)this.repositoryManager.getRepository(REPO_NAME)).thenReturn((Object)this.repositoryHandle);
        Mockito.when((Object)this.repositoryHandle.isRunning()).thenReturn((Object)running);
        Mockito.when((Object)this.userManager.hasPermissionToAccess(this.principal, this.repositoryHandle)).thenReturn((Object)permitted);
    }

    private static /* synthetic */ Object lambda$testCountCommitters$78(List authorList, InvocationOnMock invocation) throws Throwable {
        StoppableVisitor visitor = (StoppableVisitor)invocation.getArguments()[1];
        for (String author : authorList) {
            visitor.visit((Object)author);
        }
        return null;
    }
}

