/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.impl;

import com.atlassian.fecru.security.SshKeyManager;
import com.atlassian.fisheye.spi.admin.impl.DefaultSshKeyService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultSshKeyServiceTest {
    private DefaultSshKeyService sshKeyService;
    private SshKeyManager sshKeyManagerMock;

    @Before
    public void before() {
        this.sshKeyManagerMock = (SshKeyManager)Mockito.mock(SshKeyManager.class);
        this.sshKeyService = new DefaultSshKeyService(this.sshKeyManagerMock);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGenerateKeyPairWithIllegalKeyNameFails() throws Exception {
        this.sshKeyService.generateKeyPair("../my/passwords");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetPublicKeyContentsWithIllegalKeyNameFails() throws Exception {
        this.sshKeyService.getPublicKeyContents("../my/passwords");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHasPublicKeyWithIllegalKeyNameFails() throws Exception {
        this.sshKeyService.hasPublicKey("../my/passwords");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGenerateKeyPairWithIllegalKeyNameFailsDollar() throws Exception {
        this.sshKeyService.generateKeyPair("$HOME");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetPublicKeyContentsWithIllegalKeyNameFailsDollar() throws Exception {
        this.sshKeyService.getPublicKeyContents("$HOME");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHasPublicKeyWithIllegalKeyNameFailsDollar() throws Exception {
        this.sshKeyService.hasPublicKey("$HOME");
    }

    @Test
    public void testGenerateKeyPair() throws Exception {
        this.sshKeyService.generateKeyPair("valid-.valid");
        ((SshKeyManager)Mockito.verify((Object)this.sshKeyManagerMock, (VerificationMode)Mockito.times((int)1))).generateKeyPair("valid-.valid");
    }

    @Test
    public void testGetPublicKeyContents() throws Exception {
        this.sshKeyService.getPublicKeyContents("valid-.valid");
        ((SshKeyManager)Mockito.verify((Object)this.sshKeyManagerMock, (VerificationMode)Mockito.times((int)1))).getPublicKeyContents("valid-.valid");
    }

    @Test
    public void testHasPublicKey() throws Exception {
        this.sshKeyService.hasPublicKey("valid-.valid");
        ((SshKeyManager)Mockito.verify((Object)this.sshKeyManagerMock, (VerificationMode)Mockito.times((int)1))).getPublicKey("valid-.valid");
    }
}

