/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.impl;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.spi.admin.data.AdvancedLinker;
import com.atlassian.fisheye.spi.admin.data.CaseAwarePath;
import com.atlassian.fisheye.spi.admin.data.CaseAwarePathGlob;
import com.atlassian.fisheye.spi.admin.data.CommitMessageSyntaxSettings;
import com.atlassian.fisheye.spi.admin.data.CustomAuthSettings;
import com.atlassian.fisheye.spi.admin.data.CvsUpdateOptions;
import com.atlassian.fisheye.spi.admin.data.DefaultRepositoryOptions;
import com.atlassian.fisheye.spi.admin.data.DefaultUpdateOptions;
import com.atlassian.fisheye.spi.admin.data.ExternalAuthSettings;
import com.atlassian.fisheye.spi.admin.data.ImportMode;
import com.atlassian.fisheye.spi.admin.data.PolledUpdateOptions;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.atlassian.fisheye.spi.admin.data.RepositoryOptions;
import com.atlassian.fisheye.spi.admin.data.RepositoryUpdateResult;
import com.atlassian.fisheye.spi.admin.data.SimpleLinker;
import com.atlassian.fisheye.spi.admin.data.SvnRepositoryData;
import com.atlassian.fisheye.spi.admin.data.TarballSettings;
import com.atlassian.fisheye.spi.admin.data.UpdateOptions;
import com.atlassian.fisheye.spi.admin.impl.DefaultRepositoryAdminService;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config1.CvsRepType;
import com.cenqua.fisheye.config1.GitRepType;
import com.cenqua.fisheye.config1.HgRepType;
import com.cenqua.fisheye.config1.P4RepType;
import com.cenqua.fisheye.config1.RenameOptions;
import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.config1.SvnSymbolicRuleType;
import com.cenqua.fisheye.config1.SvnSymbolicType;
import com.cenqua.fisheye.config1.UserPassAuthType;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.StringUtil;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.math.BigInteger;
import java.util.Collections;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultRepositoryAdminServiceTest {
    private RepositoryManager repositoryManager = (RepositoryManager)Mockito.mock(RepositoryManager.class);
    private EffectiveUserProvider effectiveUserProvider = (EffectiveUserProvider)Mockito.mock(EffectiveUserProvider.class);
    private UserManager userManager = (UserManager)Mockito.mock(UserManager.class);

    @Test
    public void testGetEffectiveOptions() {
        PolledUpdateOptions polledUpdateOptions = new PolledUpdateOptions("pollInterval");
        final PolledUpdateOptions polledUpdateOptions2 = new PolledUpdateOptions("pollInterval2");
        final RepositoryOptions defaultOptions = this.createDefaultRepositoryOptions(polledUpdateOptions);
        DefaultRepositoryAdminService repositoryAdminService = new DefaultRepositoryAdminService(this.repositoryManager, null, (EventPublisher)Mockito.mock(EventPublisher.class), this.effectiveUserProvider, null, null, this.userManager){

            public DefaultRepositoryOptions getDefaultOptions() {
                return new DefaultRepositoryOptions(defaultOptions);
            }

            public RepositoryOptions getRepositoryOptions(String repoName) {
                RepositoryOptions ro = new RepositoryOptions();
                ro.setUsingDefaultsPermissions(true);
                return ro;
            }

            public RepositoryData getRepositoryData(String name) {
                return new SvnRepositoryData("foo", "url");
            }
        };
        Mockito.when((Object)this.effectiveUserProvider.isAdmin()).thenReturn((Object)true);
        RepositoryOptions opts = repositoryAdminService.getEffectiveOptions("foo");
        Assert.assertEquals((Object)polledUpdateOptions, (Object)opts.getUpdateOptions());
        opts.setUpdateOptions(null);
        defaultOptions.setUpdateOptions(null);
        Assert.assertEquals((Object)defaultOptions, (Object)opts);
        final RepositoryOptions defaultOptions2 = this.createDefaultRepositoryOptions(polledUpdateOptions);
        repositoryAdminService = new DefaultRepositoryAdminService(this.repositoryManager, null, (EventPublisher)Mockito.mock(EventPublisher.class), this.effectiveUserProvider, null, null, this.userManager){

            public DefaultRepositoryOptions getDefaultOptions() {
                return new DefaultRepositoryOptions(defaultOptions2);
            }

            public RepositoryOptions getRepositoryOptions(String repoName) {
                RepositoryOptions ro = new RepositoryOptions();
                ro.setCheckoutURL(Collections.singletonMap("foo", "bar"));
                ro.setAdvancedLinkers(Collections.singletonList(new AdvancedLinker("linker def 2")));
                ro.setSimpleLinkers(Collections.singletonList(new SimpleLinker(Pattern.compile(".*"), "http://simplelinker2")));
                ro.setAllowAnon(false);
                ro.setAllowExcludes(Collections.singletonList(new CaseAwarePathGlob("exclude2")));
                ro.setAllowIncludes(Collections.singletonList(new CaseAwarePath("include2")));
                ro.setAllowLoggedUsers(false);
                ro.setChangesetDiscussionsEnabled(Boolean.valueOf(false));
                ro.setCommitMessageSyntaxSettings(new CommitMessageSyntaxSettings(CommitMessageSyntaxSettings.SyntaxType.WIKI, null));
                ro.setExternalAuthSettings((ExternalAuthSettings)new CustomAuthSettings("group"));
                ro.setHiddenDirectories(Collections.singletonList(new CaseAwarePath("hidden2")));
                ro.setMaxIndexableSize(Long.valueOf(2000L));
                ro.setTarballSettings(new TarballSettings(Collections.singletonList(new TarballSettings.Exclude("tarballExclude2"))));
                ro.setUpdateOptions((UpdateOptions)polledUpdateOptions2);
                ro.setRequiredGroups(Collections.singleton("group2"));
                ro.setWatchesEnabled(Boolean.valueOf(false));
                ro.setUsingDefaultsPermissions(false);
                return ro;
            }

            public RepositoryData getRepositoryData(String name) {
                return new SvnRepositoryData("foo", "url");
            }
        };
        opts = repositoryAdminService.getEffectiveOptions("foo");
        Assert.assertEquals(Collections.singletonMap("foo", "bar"), (Object)opts.getCheckoutURL());
        Assert.assertFalse((boolean)opts.isAllowAnon());
        Assert.assertFalse((boolean)opts.isAllowLoggedUsers());
        Assert.assertEquals((int)2, (int)opts.getAdvancedLinkers().size());
        Assert.assertEquals((int)2, (int)opts.getSimpleLinkers().size());
        Assert.assertEquals((int)2, (int)opts.getAllowExcludes().size());
        Assert.assertEquals((int)2, (int)opts.getAllowIncludes().size());
        Assert.assertFalse((boolean)opts.isChangesetDiscussionsEnabled());
        Assert.assertEquals((Object)CommitMessageSyntaxSettings.SyntaxType.WIKI, (Object)opts.getCommitMessageSyntaxSettings().getSyntaxType());
        Assert.assertEquals((Object)new CustomAuthSettings("group"), (Object)opts.getExternalAuthSettings());
        Assert.assertEquals((int)2, (int)opts.getHiddenDirectories().size());
        Assert.assertEquals((long)2000L, (long)opts.getMaxIndexableSize());
        Assert.assertEquals((int)2, (int)opts.getTarballSettings().getExcludes().size());
        Assert.assertEquals((Object)polledUpdateOptions2, (Object)opts.getUpdateOptions());
        Assert.assertEquals((int)1, (int)opts.getRequiredGroups().size());
        Assert.assertEquals((String)"group2", (String)((String)opts.getRequiredGroups().iterator().next()));
        Assert.assertFalse((boolean)opts.isWatchesEnabled());
    }

    private RepositoryOptions createDefaultRepositoryOptions(PolledUpdateOptions polledUpdateOptions) {
        RepositoryOptions defaultOptions = new RepositoryOptions();
        defaultOptions.setCheckoutURL(null);
        defaultOptions.setShowCheckoutURL(Boolean.valueOf(true));
        defaultOptions.setSimpleLinkers(Collections.singletonList(new SimpleLinker(Pattern.compile(".*"), "http://simplelinker")));
        defaultOptions.setAdvancedLinkers(Collections.singletonList(new AdvancedLinker("linker syntax def")));
        defaultOptions.setAllowAnon(true);
        defaultOptions.setAllowExcludes(Collections.singletonList(new CaseAwarePathGlob("exclude")));
        defaultOptions.setAllowIncludes(Collections.singletonList(new CaseAwarePath("include")));
        defaultOptions.setAllowLoggedUsers(true);
        defaultOptions.setChangesetDiscussionsEnabled(Boolean.valueOf(true));
        defaultOptions.setCommitMessageSyntaxSettings(new CommitMessageSyntaxSettings(CommitMessageSyntaxSettings.SyntaxType.PLAIN, null));
        defaultOptions.setExternalAuthSettings(null);
        defaultOptions.setHiddenDirectories(Collections.singletonList(new CaseAwarePath("hidden")));
        defaultOptions.setMaxIndexableSize(Long.valueOf(1000L));
        defaultOptions.setTarballSettings(new TarballSettings(Collections.singletonList(new TarballSettings.Exclude("tarballExclude"))));
        defaultOptions.setUpdateOptions((UpdateOptions)new DefaultUpdateOptions(new CvsUpdateOptions("interval", "fullInterval", "history", "prefix"), polledUpdateOptions));
        defaultOptions.setRequiredGroups(Collections.singleton("group"));
        defaultOptions.setWatchesEnabled(Boolean.valueOf(true));
        return defaultOptions;
    }

    @Test
    public void checkCvsReindexRestartConditions() {
        this.checkRestartReindex(new Field[]{this.stringFieldValues("dir", true, true)}, values -> this.newCvsRepoType((String)values[0]), (a, b) -> this.newRepoAdminService().checkForCvsRestartReindex(a, b));
    }

    private DefaultRepositoryAdminService newRepoAdminService() {
        return new DefaultRepositoryAdminService(this.repositoryManager, null, (EventPublisher)Mockito.mock(EventPublisher.class), this.effectiveUserProvider, null, null, this.userManager);
    }

    @Test
    public void checkHgReindexRestartConditions() {
        this.checkRestartReindex(new Field[]{this.bigIntegerFieldValues("blockSize", true, false), this.stringFieldValues("commandTimeout", true, false), this.stringFieldValues("location", true, false)}, values -> this.newHgRepoType((BigInteger)values[0], (String)values[1], (String)values[2]), (a, b) -> this.newRepoAdminService().checkForHgRestartReindex(a, b));
    }

    @Test
    public void checkGitReindexRestartConditions() {
        this.checkRestartReindex(new Field[]{this.bigIntegerFieldValues("blockSize", true, false), this.stringFieldValues("commandTimeout", true, false), this.stringFieldValues("location", true, false), this.stringFieldValues("path", false, true), this.gitRenameOptions("renames", true, false)}, values -> this.newGitRepoType((BigInteger)values[0], (String)values[1], (String)values[2], (String)values[3], (RenameOptions.Enum)values[4]), (a, b) -> this.newRepoAdminService().checkForGitRestartReindex(a, b));
    }

    @Test
    public void checkSvnReindexRestartConditions() {
        this.checkRestartReindex(new Field[]{this.floatFieldValues("cps", true, false), this.stringFieldValues("path", true, false), this.stringFieldValues("url", true, false), this.bigIntegerFieldValues("blockSize", true, false), this.stringFieldValues("charset", true, false), this.stringFieldValues("access", true, false), this.stringFieldValues("commandTimeout", true, false), this.bigIntegerFieldValues("startRevision", false, true), this.stringFieldValues("username", true, false), this.stringFieldValues("password", true, false), this.boolFieldValues("followBase", false, true), this.svnInitialFieldValues()}, values -> this.newSvnRepoType(((Float)values[0]).floatValue(), (String)values[1], (String)values[2], (BigInteger)values[3], (String)values[4], (String)values[5], (String)values[6], (BigInteger)values[7], (String)values[8], (String)values[9], (Boolean)values[10], (String)values[11], null, null, null, null), (a, b) -> this.newRepoAdminService().checkForSvnRestartReindex(a, b));
        this.assertRestartReindex(false, true, this.newRepoAdminService().checkForSvnRestartReindex(this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, Boolean.FALSE, null, null, null), this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, Boolean.TRUE, null, null, null)));
        this.assertRestartReindex(false, true, this.newRepoAdminService().checkForSvnRestartReindex(this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, null, null, null, null), this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, Boolean.TRUE, null, null, null)));
        this.assertRestartReindex(false, false, this.newRepoAdminService().checkForSvnRestartReindex(this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, Boolean.FALSE, null, null, null), this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, Boolean.FALSE, null, null, null)));
        this.assertRestartReindex(false, false, this.newRepoAdminService().checkForSvnRestartReindex(this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, Boolean.TRUE, null, null, null), this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, Boolean.TRUE, null, null, null)));
        this.assertRestartReindex(false, false, this.newRepoAdminService().checkForSvnRestartReindex(this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, Boolean.FALSE, null, null, null), this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, null, null, null, null)));
        this.assertRestartReindex(false, false, this.newRepoAdminService().checkForSvnRestartReindex(this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, Boolean.FALSE, null, null, null), this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, null, null, null, null)));
        this.assertRestartReindex(false, true, this.newRepoAdminService().checkForSvnRestartReindex(this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, null, new String[]{"123", "456", "789"}, null, null), this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, null, new String[]{"abc", "def", "ghi"}, null, null)));
        this.assertRestartReindex(false, true, this.newRepoAdminService().checkForSvnRestartReindex(this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, null, null, new String[]{"123", "456", "789"}, null), this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, null, null, new String[]{"abc", "def", "ghi"}, null)));
        this.assertRestartReindex(false, true, this.newRepoAdminService().checkForSvnRestartReindex(this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, null, null, null, new String[]{"123", "456", "789"}), this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, null, null, null, new String[]{"abc", "def", "ghi"})));
        this.assertRestartReindex(false, true, this.newRepoAdminService().checkForSvnRestartReindex(this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, Boolean.FALSE, new String[]{"123", "456", "789"}, null, null), this.newSvnRepoType(0.0f, null, null, BigInteger.valueOf(0L), null, null, null, BigInteger.valueOf(0L), null, null, false, null, Boolean.TRUE, new String[]{"123", "456", "789"}, null, null)));
    }

    @Test
    public void checkP4ReindexRestartConditions() {
        this.checkRestartReindex(new Field[]{this.floatFieldValues("cps", true, false), this.bigIntegerFieldValues("port", true, false), this.stringFieldValues("path", true, false), this.stringFieldValues("server", true, false), this.bigIntegerFieldValues("blockSize", true, false), this.bigIntegerFieldValues("fileLogLimit", true, false), this.stringFieldValues("charset", true, false), this.stringFieldValues("commandTimeout", true, false), this.stringFieldValues("username", true, false), this.stringFieldValues("password", true, false), this.boolFieldValues("unicode", false, true), this.boolFieldValues("caseSensitive", false, true)}, values -> this.newP4RepoType(((Float)values[0]).floatValue(), (BigInteger)values[1], (String)values[2], (String)values[3], (BigInteger)values[4], (BigInteger)values[5], (String)values[6], (String)values[7], (String)values[8], (String)values[9], (Boolean)values[10], (Boolean)values[11], false, null), (a, b) -> this.newRepoAdminService().checkForP4RestartReindex(a, b));
        this.assertRestartReindex(false, true, this.newRepoAdminService().checkForP4RestartReindex(this.newP4RepoType(0.0f, BigInteger.valueOf(0L), null, null, BigInteger.valueOf(0L), BigInteger.valueOf(0L), null, null, null, null, false, false, false, null), this.newP4RepoType(0.0f, BigInteger.valueOf(0L), null, null, BigInteger.valueOf(0L), BigInteger.valueOf(0L), null, null, null, null, false, false, true, BigInteger.valueOf(0L))));
    }

    private void assertRestartReindex(boolean restart, boolean reindex, RepositoryUpdateResult result) {
        Assert.assertEquals((boolean)restart, (boolean)result.isRestartRequired());
        Assert.assertEquals((boolean)reindex, (boolean)result.isReindexRequired());
    }

    private Field<String> stringFieldValues(String paramName, boolean affectsRestart, boolean affectsReindex) {
        return new Field<String>(paramName, affectsRestart, affectsReindex){

            public String[] enumerateLegalValues() {
                return new String[]{null, "", "foo"};
            }

            @Override
            public boolean areEquivalent(String one, String other) {
                return StringUtil.equalsWithNullsAsEmpty((String)one, (String)other);
            }
        };
    }

    private Field<BigInteger> bigIntegerFieldValues(String paramName, boolean affectsRestart, boolean affectsReindex) {
        return new Field<BigInteger>(paramName, affectsRestart, affectsReindex){

            public BigInteger[] enumerateLegalValues() {
                return new BigInteger[]{BigInteger.valueOf(0L), BigInteger.valueOf(1L)};
            }

            @Override
            public boolean areEquivalent(BigInteger one, BigInteger other) {
                return one.equals(other);
            }
        };
    }

    private Field<RenameOptions.Enum> gitRenameOptions(String paramName, boolean affectsRestart, boolean affectsReindex) {
        return new Field<RenameOptions.Enum>(paramName, affectsRestart, affectsReindex){

            public RenameOptions.Enum[] enumerateLegalValues() {
                int size = RenameOptions.Enum.table.lastInt() + 1;
                RenameOptions.Enum[] ret = new RenameOptions.Enum[size];
                ret[0] = null;
                for (int i = 1; i < size; ++i) {
                    ret[i] = RenameOptions.Enum.forInt((int)i);
                }
                return ret;
            }

            @Override
            public boolean areEquivalent(RenameOptions.Enum one, RenameOptions.Enum other) {
                return ((RenameOptions.Enum)Objects.firstNonNull((Object)one, (Object)RenameOptions.NONE)).intValue() == ((RenameOptions.Enum)Objects.firstNonNull((Object)other, (Object)RenameOptions.NONE)).intValue();
            }
        };
    }

    private Field<String> svnInitialFieldValues() {
        return new Field<String>("initialImport", false, true){

            public String[] enumerateLegalValues() {
                return new String[]{ImportMode.NO_IMPORT.getKey(), null, "", "param:" + this.getName()};
            }

            @Override
            public boolean areEquivalent(String one, String other) {
                return ImportMode.fromString((String)one) == ImportMode.fromString((String)other);
            }
        };
    }

    private Field<Boolean> boolFieldValues(String paramName, boolean affectsRestart, boolean affectsReindex) {
        return new Field<Boolean>(paramName, affectsRestart, affectsReindex){

            public Boolean[] enumerateLegalValues() {
                return new Boolean[]{Boolean.TRUE, Boolean.FALSE};
            }

            @Override
            public boolean areEquivalent(Boolean one, Boolean other) {
                return one.equals(other);
            }
        };
    }

    private Field<Float> floatFieldValues(String paramName, boolean affectsRestart, boolean affectsReindex) {
        return new Field<Float>(paramName, affectsRestart, affectsReindex){

            public Float[] enumerateLegalValues() {
                return new Float[]{Float.valueOf(0.0f), Float.valueOf(1.0f)};
            }

            @Override
            public boolean areEquivalent(Float one, Float other) {
                return one.equals(other);
            }
        };
    }

    public <T> void checkRestartReindex(Field[] paramSpecs, RepoTypeBuilder<T> typeBuilder, UpdateChecker<T> updateChecker) {
        Object[] arguments1 = new Object[paramSpecs.length];
        Object[] arguments2 = new Object[paramSpecs.length];
        for (int paramIdxToVary = 0; paramIdxToVary < paramSpecs.length; ++paramIdxToVary) {
            for (int j = 0; j < paramSpecs.length; ++j) {
                if (paramIdxToVary == j) continue;
                arguments1[j] = paramSpecs[j].enumerateLegalValues()[0];
                arguments2[j] = paramSpecs[j].enumerateLegalValues()[0];
            }
            Field variedParamSpec = paramSpecs[paramIdxToVary];
            T[] variedArguments = variedParamSpec.enumerateLegalValues();
            for (int k = 0; k < variedArguments.length; ++k) {
                arguments1[paramIdxToVary] = variedArguments[k];
                for (int l = k; l < variedArguments.length; ++l) {
                    arguments2[paramIdxToVary] = variedArguments[l];
                    RepositoryUpdateResult updateResult = updateChecker.check(typeBuilder.build(arguments1), typeBuilder.build(arguments2));
                    if (l == k || variedParamSpec.areEquivalent(arguments1[paramIdxToVary], arguments2[paramIdxToVary])) {
                        Assert.assertFalse((String)String.format("Reindex should not be required for identical or equivalent values. Parameter under test: %s", variedParamSpec.getName()), (boolean)updateResult.isReindexRequired());
                        Assert.assertFalse((String)String.format("Restart should not be required for identical or equivalent values. Parameter under test: %s", variedParamSpec.getName()), (boolean)updateResult.isRestartRequired());
                        continue;
                    }
                    Assert.assertFalse((String)String.format("Reindex should be required for non-identical non-equivalent values %s & %s. Parameter under test: %s", String.valueOf(arguments1[paramIdxToVary]), String.valueOf(arguments2[paramIdxToVary]), String.valueOf(variedParamSpec.getName())), (boolean)(updateResult.isReindexRequired() ^ variedParamSpec.isAffectsReindex()));
                    Assert.assertFalse((String)String.format("Restart should be required for non-identical non-equivalent values %s & %s. Parameter under test: %s", String.valueOf(arguments1[paramIdxToVary]), String.valueOf(arguments2[paramIdxToVary]), String.valueOf(variedParamSpec.getName())), (boolean)(updateResult.isRestartRequired() ^ variedParamSpec.isAffectsRestart()));
                }
            }
        }
    }

    private CvsRepType newCvsRepoType(String dir) {
        CvsRepType cvs = CvsRepType.Factory.newInstance();
        cvs.setDir(dir);
        return cvs;
    }

    private SvnRepType newSvnRepoType(float cps, String path, String url, BigInteger blockSize, String charset, String access, String commandTimeout, BigInteger startRev, String username, String password, boolean followBase, String initialImport, Boolean useAutoRules, String[] trunkRule, String[] branchRule, String[] tagRule) {
        SvnRepType svn = SvnRepType.Factory.newInstance();
        svn.setCps(cps);
        svn.setPath(path);
        svn.setUrl(url);
        svn.setBlocksize(blockSize);
        svn.setCharset(charset);
        svn.setAccess(access);
        svn.setCommandTimeout(commandTimeout);
        svn.setStartRev(startRev);
        if (!Strings.isNullOrEmpty((String)username) || !Strings.isNullOrEmpty((String)password)) {
            UserPassAuthType authType = UserPassAuthType.Factory.newInstance();
            authType.setUsername(username);
            authType.setPassword(password);
            svn.setAuth(authType);
        }
        svn.setFollowBase(followBase);
        svn.setInitialImport(initialImport);
        if (useAutoRules != null || trunkRule != null || branchRule != null || tagRule != null) {
            SvnSymbolicType svnSymbolicType = SvnSymbolicType.Factory.newInstance();
            if (useAutoRules != null) {
                svnSymbolicType.setAutoRules(useAutoRules.booleanValue());
            }
            if (trunkRule != null) {
                SvnSymbolicRuleType trunkRuleType = SvnSymbolicRuleType.Factory.newInstance();
                trunkRuleType.setRegex(trunkRule[0]);
                trunkRuleType.setName(trunkRule[1]);
                trunkRuleType.setLogical(trunkRule[2]);
                svnSymbolicType.setTrunkArray(new SvnSymbolicRuleType[]{trunkRuleType});
            }
            if (branchRule != null) {
                SvnSymbolicRuleType branchRuleType = SvnSymbolicRuleType.Factory.newInstance();
                branchRuleType.setRegex(branchRule[0]);
                branchRuleType.setName(branchRule[1]);
                branchRuleType.setLogical(branchRule[2]);
                svnSymbolicType.setBranchArray(new SvnSymbolicRuleType[]{branchRuleType});
            }
            if (tagRule != null) {
                SvnSymbolicRuleType tagRuleType = SvnSymbolicRuleType.Factory.newInstance();
                tagRuleType.setRegex(tagRule[0]);
                tagRuleType.setName(tagRule[1]);
                tagRuleType.setLogical(tagRule[2]);
                svnSymbolicType.setTagArray(new SvnSymbolicRuleType[]{tagRuleType});
            }
            svn.setSymbolic(svnSymbolicType);
        }
        return svn;
    }

    private P4RepType newP4RepoType(float cps, BigInteger port, String path, String server, BigInteger blockSize, BigInteger fileLogLimit, String charset, String commandTimeout, String username, String password, boolean unicode, boolean caseSensitive, boolean initialImport, BigInteger startRev) {
        P4RepType p4 = P4RepType.Factory.newInstance();
        p4.setCps(cps);
        p4.setPort(port);
        p4.setPath(path);
        p4.setServer(server);
        p4.setBlocksize(blockSize);
        p4.setFileloglimit(fileLogLimit);
        p4.setCharset(charset);
        p4.setUnicode(unicode);
        p4.setCasesensitive(caseSensitive);
        p4.setCommandTimeout(commandTimeout);
        if (!Strings.isNullOrEmpty((String)username) || !Strings.isNullOrEmpty((String)password)) {
            UserPassAuthType authType = UserPassAuthType.Factory.newInstance();
            authType.setUsername(username);
            authType.setPassword(password);
            p4.setAuth(authType);
        }
        p4.setInitialImport(initialImport);
        if (startRev != null) {
            p4.setStartRev(startRev);
        }
        return p4;
    }

    private HgRepType newHgRepoType(BigInteger blockSize, String commandTimeout, String location) {
        HgRepType hg = HgRepType.Factory.newInstance();
        hg.setBlocksize(blockSize);
        hg.setCommandTimeout(commandTimeout);
        hg.setLocation(location);
        return hg;
    }

    private GitRepType newGitRepoType(BigInteger blockSize, String commandTimeout, String location, String path, RenameOptions.Enum renameOption) {
        GitRepType git = GitRepType.Factory.newInstance();
        git.setBlocksize(blockSize);
        git.setCommandTimeout(commandTimeout);
        git.setLocation(location);
        git.setPath(path);
        git.setRenames(renameOption);
        return git;
    }

    public static interface UpdateChecker<T> {
        public RepositoryUpdateResult check(T var1, T var2);
    }

    public static interface RepoTypeBuilder<T> {
        public T build(Object[] var1);
    }

    public abstract class Field<T> {
        private String name;
        private boolean affectsRestart;
        private boolean affectsReindex;

        protected Field(String name, boolean affectsRestart, boolean affectsReindex) {
            this.name = name;
            this.affectsRestart = affectsRestart;
            this.affectsReindex = affectsReindex;
        }

        public abstract T[] enumerateLegalValues();

        public abstract boolean areEquivalent(T var1, T var2);

        public String getName() {
            return this.name;
        }

        public boolean isAffectsRestart() {
            return this.affectsRestart;
        }

        public boolean isAffectsReindex() {
            return this.affectsReindex;
        }
    }
}

