/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin;

import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.cenqua.fisheye.util.TestUtil;
import junit.framework.TestCase;

public class RepositoryNameRegexTest
extends TestCase {
    private static void assertValidNames(String ... names) {
        TestUtil.assertRegexMatches(RepositoryData.NAME_REGEX, names);
    }

    private static void assertInvalidNames(String ... names) {
        TestUtil.assertRegexFails(RepositoryData.NAME_REGEX, names);
    }

    public void testInvalidWhitespace() {
        RepositoryNameRegexTest.assertInvalidNames("", " ", "\t \n", "sanity  1", " sanity-1", "sanity-1 ", " sanity-1 ");
    }

    public void testSimpleNames() {
        RepositoryNameRegexTest.assertValidNames("a", "foo", "sanity-1", "sanity_1", "sanity.1");
    }

    public void testValidNonAlpha() {
        RepositoryNameRegexTest.assertValidNames(".", "_", "-", "._-", "123");
    }

    public void testInvalidNonAlpha() {
        RepositoryNameRegexTest.assertInvalidNames("sanity@repo.org");
    }
}

