/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.scm;

import com.atlassian.fisheye.scm.DirNodeData;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.util.Pair;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DirNodeDataTest {
    private DirNodeData createNode(String path, DirNodeData parent, String selectedPath) {
        return new DirNodeData(new Path((CharSequence)path), false, false, parent, 0, new Path((CharSequence)selectedPath), new Pair[0]);
    }

    @Test
    public void testIsAtSelectedPathWhenSelectedPathAndNodePathAreEqual() {
        String selectedPath = "depth1/depth2";
        DirNodeData rootNode = this.createNode("depth1", null, selectedPath);
        DirNodeData nodeAtSelectedPath = this.createNode("depth1/depth2", rootNode, selectedPath);
        DirNodeData childNode = this.createNode("depth1/depth2/depth3", nodeAtSelectedPath, selectedPath);
        DirNodeData nodeInDifferentPath = this.createNode("depth1/depth2-diff", rootNode, selectedPath);
        DirNodeData nodeWithoutSelectedPath = this.createNode("depth1/depth2", rootNode, null);
        Assert.assertThat((Object)nodeAtSelectedPath.isAtSelectedPath(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)nodeInDifferentPath.isAtSelectedPath(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)nodeWithoutSelectedPath.isAtSelectedPath(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)childNode.isAtSelectedPath(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)rootNode.isAtSelectedPath(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsAtSelectedPathWhenSelectPathAndNodeWithManyGroupedNodesAreIntersecting() {
        String selectedPath = "depth1/depth2";
        String selectedRootNodePath = "depth1";
        DirNodeData rootNode = this.createNode("depth1", null, selectedPath);
        DirNodeData selectedRootNode = this.createNode("depth1", null, selectedRootNodePath);
        DirNodeData groupedNodesWithOneLevelsDiff = this.createNode("depth1/depth2/depth3", rootNode, selectedPath);
        DirNodeData groupedNodesWithTwoLevelsDiff = this.createNode("depth1/depth2/depth3/depth4", rootNode, selectedPath);
        DirNodeData groupedNodesWithOneLevelsDiffAndDifferentPath = this.createNode("depth1/depth2-diff/depth3", rootNode, selectedPath);
        DirNodeData groupedNodesWithSelectedParent = this.createNode("depth1/depth2/depth3/depth4", selectedRootNode, selectedRootNodePath);
        Assert.assertThat((Object)groupedNodesWithOneLevelsDiff.isAtSelectedPath(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)groupedNodesWithTwoLevelsDiff.isAtSelectedPath(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)groupedNodesWithOneLevelsDiffAndDifferentPath.isAtSelectedPath(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)groupedNodesWithSelectedParent.isAtSelectedPath(), (Matcher)Matchers.is((Object)false));
    }
}

