/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.reptest;

import com.atlassian.fisheye.activity.ActivityItem;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemProvider;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DelegatingRepositorySearcher;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import com.cenqua.fisheye.web.ChangeSetHolder;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class SpecificRepositorySearcherTest {
    private ActivityItemProvider searcher;

    @Before
    public void setUp() throws Exception {
        Disposer.pushThreadInstance();
        TestFishEyeInstances.loadSanity1();
        this.searcher = (ActivityItemProvider)SpringContext.getComponentByClass(DelegatingRepositorySearcher.class);
    }

    private ActivityItemSearchParams makeParams(String committer, SearchSortOrder direction, Date min, Date max) {
        return this.makeParams(committer, direction, min, max, null, null);
    }

    private ActivityItemSearchParams makeParams(String committer, SearchSortOrder direction, Date min, Date max, Path path, String rep) {
        ActivityItemSearchParams.Builder builder = new ActivityItemSearchParams.Builder();
        builder.anyCommitter("cvs", committer);
        builder.searchDirection(direction);
        builder.timeZone((TimeZone)new SimpleTimeZone(0, "GMT"));
        builder.maxItems(10);
        builder.includeFisheye();
        if (path != null) {
            builder.path(rep, path);
        }
        if (min != null) {
            builder.minDate(min);
        }
        if (max != null) {
            builder.maxDate(max);
        }
        return builder.build();
    }

    private ActivityItemSearchParams makeParams(String committer, SearchSortOrder direction) {
        return this.makeParams(committer, direction, null, null);
    }

    @Test
    public void testLatestChangesetByCommitter() throws Exception {
        RepositoryHandle handle = TestFishEyeInstances.getSanity1Repos();
        RepositoryEngine engine = handle.acquireEngine();
        RevisionCache cache = engine.getRevisionCache();
        ChangeSet cs = cache.findEarliestChangesetForCommitter("matt");
        ActivityItemList items = this.searcher.findActivityItems(this.makeParams("matt", SearchSortOrder.TOWARDS_FUTURE, new Date(0L), null), null, new ActivitySearchMonitor());
        String repoName = engine.getName();
        this.assertChangeSet(items.firstItem(), cs.getId(), repoName);
        cs = cache.findLatestChangesetForCommitter("matt");
        items = this.searcher.findActivityItems(this.makeParams("matt", SearchSortOrder.TOWARDS_PAST, null, new Date()), null, new ActivitySearchMonitor());
        this.assertChangeSet(items.firstItem(), cs.getId(), repoName);
        cs = cache.findEarliestChangesetForCommitter("brendan");
        this.searcher = (ActivityItemProvider)SpringContext.getComponentByClass(DelegatingRepositorySearcher.class);
        items = this.searcher.findActivityItems(this.makeParams("brendan", SearchSortOrder.TOWARDS_FUTURE, new Date(0L), null), null, new ActivitySearchMonitor());
        this.assertChangeSet(items.firstItem(), cs.getId(), repoName);
        cs = cache.findLatestChangesetForCommitter("brendan");
        items = this.searcher.findActivityItems(this.makeParams("brendan", SearchSortOrder.TOWARDS_PAST, null, new Date()), null, new ActivitySearchMonitor());
        this.assertChangeSet(items.firstItem(), cs.getId(), repoName);
    }

    @Test
    public void testLatestChangeset() throws Exception {
        RepositoryHandle handle = TestFishEyeInstances.getSanity1Repos();
        RepositoryEngine engine = handle.acquireEngine();
        RevisionCache cache = engine.getRevisionCache();
        ChangeSet cs = cache.findLatestChangeset(Path.ROOT);
        ActivityItemList items = this.searcher.findActivityItems(this.makeParams(null, SearchSortOrder.TOWARDS_PAST, null, new Date()), null, new ActivitySearchMonitor());
        this.assertChangeSet(items.firstItem(), cs.getId(), engine.getName());
        Path path = new Path((CharSequence)"/test/test");
        cs = cache.findLatestChangeset(path);
        items = this.searcher.findActivityItems(this.makeParams(null, SearchSortOrder.TOWARDS_PAST, null, new Date(), path, engine.getName()), null, new ActivitySearchMonitor());
        this.assertChangeSet(items.firstItem(), cs.getId(), engine.getName());
        cs = cache.findLatestChangeset(new Path((CharSequence)"/fake"));
        Assert.assertEquals(null, (Object)cs);
    }

    @Test
    public void testCommitterConstrainedChangesets() throws Exception {
        Iterator it = this.searcher.findActivityItems(this.makeParams("matt", SearchSortOrder.TOWARDS_PAST), null, new ActivitySearchMonitor()).getItems().iterator();
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_2_2:matt:20050517064053", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_2:matt:20050323231241", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH1:matt:20050113032802", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20050113032653", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20050113032614", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20050106031006", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041205010425", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041117000354", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041116235525", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041116235525", "cvs");
        List activityItems = this.searcher.findActivityItems(this.makeParams("matt", SearchSortOrder.TOWARDS_FUTURE, ISO8601DateHelper.parseAsUTC((String)"2004-11-16T23:55:24+1100"), null), null, new ActivitySearchMonitor()).getItems();
        it = activityItems.iterator();
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041116234830", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041116234847", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041116234945", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041116235236", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041116235307", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041116235525", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041116235525", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "BRANCH_1:matt:20041117000354", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20041205010425", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20050106031006", "cvs");
        it = this.searcher.findActivityItems(this.makeParams("matt", SearchSortOrder.TOWARDS_PAST, null, ISO8601DateHelper.parseAsUTC((String)"2003-02-15T00:00:00+1100")), null, new ActivitySearchMonitor()).getItems().iterator();
        this.assertChangeSet((ActivityItem)it.next(), "yoyo:matt:20030214060223", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20030214060223", "cvs");
        this.assertChangeSet((ActivityItem)it.next(), "MAIN:matt:20021216102031", "cvs");
        Assert.assertFalse((boolean)it.hasNext());
        ActivityItemList list = this.searcher.findActivityItems(this.makeParams("matt", SearchSortOrder.TOWARDS_PAST, ISO8601DateHelper.parseAsUTC((String)"2001-01-01T00:00:00+1100"), ISO8601DateHelper.parseAsUTC((String)"2004-01-01T00:00:00+1100")), null, new ActivitySearchMonitor());
        Iterator i = list.getItems().iterator();
        Assert.assertEquals((int)0, (int)list.getExceptions().size());
        Assert.assertEquals((int)10, (int)list.getItems().size());
        System.err.println(list.getItems());
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:matt:20031210010331", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:matt:20031210005747", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:matt:20031208013451", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:matt:20031208013443", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:matt:20031208013414", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:matt:20031208013349", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:matt:20031204072059", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:matt:20031204035415", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:matt:20031204035028", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "yoyo:matt:20031204035011", "cvs");
        ActivityItemSearchParams.Builder activityParams = new ActivityItemSearchParams.Builder();
        activityParams.path("cvs", new Path((CharSequence)"/test/CleanSweeper.java")).maxItems(10).minDate(ISO8601DateHelper.parseAsUTC((String)"2001-01-01T00:00:00+1100")).maxDate(ISO8601DateHelper.parseAsUTC((String)"2004-01-01T00:00:00+1100"));
        activityParams.timeZone((TimeZone)new SimpleTimeZone(0, "GMT"));
        activityParams.searchDirection(SearchSortOrder.TOWARDS_PAST);
        activityParams.includeFisheye();
        list = this.searcher.findActivityItems(activityParams.build(), null, new ActivitySearchMonitor());
        i = list.getItems().iterator();
        Assert.assertEquals((int)10, (int)list.getItems().size());
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "PROD_136:brendan:20031127062444", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "PROD_136:brendan:20031120042248", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:brendan:20030410072242", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:anthony:20030325235829", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:anthony:20030214044800", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:anthony:20030211000212", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:anthony:20030114072630", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:matt:20021216102031", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:anthony:20021216002439", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:anthony:20021204045947", "cvs");
        activityParams = new ActivityItemSearchParams.Builder();
        activityParams.path("cvs", Path.ROOT).maxItems(10).minDate(ISO8601DateHelper.parseAsUTC((String)"2001-01-01T00:00:00+1100")).maxDate(ISO8601DateHelper.parseAsUTC((String)"2004-01-01T00:00:00+1100")).timeZone((TimeZone)new SimpleTimeZone(0, "GMT"));
        activityParams.includeFisheye();
        activityParams.searchDirection(SearchSortOrder.TOWARDS_PAST);
        ActivityItemSearchParams.Builder unconstrainedBuilder = ActivityItemSearchParams.builder().repository("cvs").maxItems(10).minDate(ISO8601DateHelper.parseAsUTC((String)"2001-01-01T00:00:00+1100")).maxDate(ISO8601DateHelper.parseAsUTC((String)"2004-01-01T00:00:00+1100")).timeZone((TimeZone)new SimpleTimeZone(0, "GMT"));
        unconstrainedBuilder.searchDirection(SearchSortOrder.TOWARDS_PAST);
        list = this.searcher.findActivityItems(activityParams.build(), null, new ActivitySearchMonitor());
        ActivityItemList unconstrainedList = this.searcher.findActivityItems(unconstrainedBuilder.includeFisheye().build(), null, new ActivitySearchMonitor());
        Assert.assertEquals((int)unconstrainedList.getItems().size(), (int)list.getItems().size());
        int index = 0;
        for (ActivityItem ai : list.getItems()) {
            ChangeSetHolder csh = (ChangeSetHolder)ai;
            ChangeSetHolder csh2 = (ChangeSetHolder)unconstrainedList.getItems().get(index++);
            Assert.assertEquals((String)csh.getChangeset().getId(), (String)csh2.getChangeset().getId());
        }
        i = list.getItems().iterator();
        Assert.assertEquals((int)10, (int)list.getItems().size());
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "CVSNT_2_0_x:tmh:20031226154400", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:bill:20031224073112", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:cris:20031218100736", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "dsnet:cris:20031216051129", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:cris:20031216051129", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:matt:20031210010331", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:matt:20031210005747", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:verdyp:20031210004159", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:verdyp:20031209211425", "cvs");
        this.assertChangeSet((ActivityItem)((ChangeSetHolder)i.next()), "MAIN:verdyp:20031209190249", "cvs");
    }

    private void assertChangeSet(ActivityItem holder, String csid, String repoName) {
        Assert.assertEquals((String)csid, (String)((ChangeSetHolder)holder).getChangeset().getId());
        Assert.assertEquals((String)repoName, (String)((ChangeSetHolder)holder).getContext().getRepoName());
    }

    @After
    public void tearDown() throws Exception {
        HibernateUtil.closeSession();
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
    }
}

