/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.reptest;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.util.Disposer;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class RecentChangesSearcherTest {
    private RepositoryEngine engine;

    @Before
    public void setUp() throws Exception {
        Disposer.pushThreadInstance();
        RepositoryHandle handle = TestFishEyeInstances.getSanity1Repos();
        this.engine = handle.acquireEngine();
    }

    @After
    public void tearDown() throws Exception {
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testFileChangeSetSearch() throws Exception {
        String[] AUTHORS = new String[]{"brendan", "brendan", "brendan", "anthony", "anthony"};
        String[] COMMENTS = new String[]{"NONE: fix doofus bug", "NONE: replaced problematic JMS queue with db-driven queue", "NONE: remove printlns, new log4j cfg", "6821: remodel, to not return deleted users to the entity bean level (from session bean level", "ONE: made deleteCompleteJobs a jmx method"};
        String[] DATES = new String[]{"2003-11-27 17:24:44", "2003-11-20 15:22:48", "2003-04-10 17:22:42", "2003-03-26 10:58:29", "2003-02-14 15:48:00"};
        String[] BRANCH = new String[]{"PROD_136", "PROD_136", "MAIN", "MAIN", "MAIN"};
        int MAX_RETURN = 5;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("Australia/Sydney"));
        RecentChangesParams2 params = new RecentChangesParams2();
        params.setMaxReturn(5);
        params.setSearchDirection(0);
        params.setBasePath(new Path((CharSequence)"/test/CleanSweeper.java"));
        RevisionCache revisionCache = this.engine.getRevisionCache();
        List changeSets = revisionCache.findRecentChangeSets(params);
        Assert.assertEquals((int)5, (int)changeSets.size());
        for (int i = 0; i < 3; ++i) {
            ChangeSet changeset = (ChangeSet)changeSets.get(i);
            Assert.assertEquals((String)AUTHORS[i].trim(), (String)changeset.getAuthor().trim());
            Assert.assertEquals((String)COMMENTS[i].trim(), (String)changeset.getComment().trim());
            Assert.assertEquals((String)DATES[i].trim(), (String)formatter.format(changeset.getDateValue()).trim());
        }
    }

    @Test
    public void testChangesetSearch() throws Exception {
        RecentChangesParams2 params = new RecentChangesParams2();
        params.setMaxReturn(3);
        RevisionCache revisionCache = this.engine.getRevisionCache();
        List changeSets = revisionCache.findRecentChangeSets(params);
        Assert.assertEquals((int)3, (int)changeSets.size());
        ChangeSet cs1 = (ChangeSet)changeSets.get(0);
        ChangeSet cs2 = (ChangeSet)changeSets.get(1);
        ChangeSet cs3 = (ChangeSet)changeSets.get(2);
        this.assertPrevChangeset(cs2, revisionCache, cs3);
        this.assertNextChangeset(cs2, revisionCache, cs1);
    }

    @Test
    public void testFSH235() throws Exception {
        this.subtestFSH235("MAIN:matt:20041116234847", Path.ROOT);
        this.subtestFSH235("MAIN:matt:20041116234847", new Path((CharSequence)"emptytests/empty_on_branch"));
        this.subtestFSH235("MAIN:matt:20041116234847", new Path((CharSequence)"test/branching"));
    }

    private void subtestFSH235(String csid, Path path) throws DbException {
        RevisionCache revisionCache = this.engine.getRevisionCache();
        RecentChangesParams2 params = new RecentChangesParams2();
        ChangeSet cs = revisionCache.getChangeSet(csid);
        params.setBasePath(path);
        params.setMaxChangeset(cs, true);
        params.setMinChangeset(cs, true);
        List changeSets = revisionCache.findRecentChangeSets(params);
        Assert.assertEquals((int)1, (int)changeSets.size());
        ChangeSet result = (ChangeSet)changeSets.get(0);
        Assert.assertEquals((String)csid, (String)result.getId());
    }

    private void assertNextChangeset(ChangeSet cs2, RevisionCache revisionCache, ChangeSet cs1) throws DbException {
        ChangeSet nextChangeset = this.findNextChangeset(cs2, revisionCache, null);
        Assert.assertEquals((String)cs1.getId(), (String)nextChangeset.getId());
    }

    private ChangeSet findNextChangeset(ChangeSet cs2, RevisionCache revisionCache, Path path) throws DbException {
        RecentChangesParams2 nextParams = new RecentChangesParams2();
        nextParams.setBasePath(path);
        nextParams.setMaxReturn(1);
        nextParams.setSearchDirection(1);
        nextParams.setMaxChangeset(null, false);
        nextParams.setMinChangeset(cs2, false);
        List nextChangesets = revisionCache.findRecentChangeSets(nextParams);
        return (ChangeSet)nextChangesets.get(0);
    }

    private void assertPrevChangeset(ChangeSet cs2, RevisionCache revisionCache, ChangeSet cs3) throws DbException {
        ChangeSet prevChangeset = this.findPrevChangeset(cs2, revisionCache, null);
        Assert.assertEquals((String)cs3.getId(), (String)prevChangeset.getId());
    }

    private ChangeSet findPrevChangeset(ChangeSet cs2, RevisionCache revisionCache, Path path) throws DbException {
        RecentChangesParams2 prevParams = new RecentChangesParams2();
        prevParams.setBasePath(path);
        prevParams.setMaxReturn(1);
        prevParams.setSearchDirection(0);
        prevParams.setMinChangeset(null, false);
        prevParams.setMaxChangeset(cs2, false);
        List prevChangesets = revisionCache.findRecentChangeSets(prevParams);
        return (ChangeSet)prevChangesets.get(0);
    }

    @Test
    public void testNextPrevChangeset() throws Exception {
        RevisionCache revisionCache = this.engine.getRevisionCache();
        ChangeSet currCs = revisionCache.getChangeSet("MAIN:matt:20030214060223");
        Path path = new Path((CharSequence)"");
        ChangeSet nextCs = this.findNextChangeset(currCs, revisionCache, path);
        ChangeSet prevCs = this.findPrevChangeset(currCs, revisionCache, path);
        Assert.assertFalse((boolean)nextCs.getId().equals(prevCs.getId()));
        Assert.assertFalse((boolean)currCs.getId().equals(prevCs.getId()));
        Assert.assertFalse((boolean)currCs.getId().equals(nextCs.getId()));
        Assert.assertEquals((String)"yoyo:matt:20030214060223", (String)nextCs.getId());
        Assert.assertEquals((String)"MAIN:anthony:20030214044800", (String)prevCs.getId());
    }
}

