/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.reptest;

import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.csindex.RecentChangesSearcher2;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.Disposer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public final class RecentChangesSearcher2Test {
    private RepositoryEngine engine;

    @BeforeClass
    public static void setUpClass() throws Exception {
        Disposer.pushThreadInstance();
        TestFishEyeInstances.loadSanity1();
    }

    @Before
    public void setUp() throws Exception {
        this.engine = ((RepositoryManager)SpringContext.getComponent(RepositoryManager.class, (String)"repositoryManager")).getRepository("cvs").acquireEngine();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testFileChangeSetSearch() throws Exception {
        String[] COMMITTERS = new String[]{"brendan", "brendan", "brendan", "anthony", "anthony"};
        String[] COMMENTS = new String[]{"NONE: fix doofus bug", "NONE: replaced problematic JMS queue with db-driven queue", "NONE: remove printlns, new log4j cfg", "6821: remodel, to not return deleted users to the entity bean level (from session bean level", "ONE: made deleteCompleteJobs a jmx method"};
        String[] DATES = new String[]{"2003-11-27 17:24:44", "2003-11-20 15:22:48", "2003-04-10 17:22:42", "2003-03-26 10:58:29", "2003-02-14 15:48:00"};
        int MAX_RETURN = 5;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("Australia/Sydney"));
        RecentChangesParams2 params = new RecentChangesParams2();
        params.setMaxReturn(5);
        params.setSearchDirection(0);
        params.setBasePath(new Path((CharSequence)"/test/CleanSweeper.java"));
        RecentChangesSearcher2 searcher = new RecentChangesSearcher2(this.engine.getInternalRevisionCache());
        List changeSets = searcher.findRecentChangeSets(params);
        Assert.assertEquals((int)5, (int)changeSets.size());
        for (int i = 0; i < 3; ++i) {
            ChangeSet changeset = (ChangeSet)changeSets.get(i);
            Assert.assertEquals((String)COMMITTERS[i].trim(), (String)changeset.getAuthor().trim());
            Assert.assertEquals((String)COMMENTS[i].trim(), (String)changeset.getComment().trim());
            Assert.assertEquals((String)DATES[i].trim(), (String)formatter.format(changeset.getDateValue()).trim());
        }
    }

    @Test
    public void testConstraintsImposedByUser() throws Exception {
        ActivityItemSearchParams.Builder userParamBuilder = ActivityItemSearchParams.builder();
        userParamBuilder.includeFisheye();
        userParamBuilder.maxItems(6);
        userParamBuilder.timeZone(AppConfig.getsConfig().getTimezone());
        userParamBuilder.setCompulsoryCommitter("brendan");
        userParamBuilder.repository("cvs");
        userParamBuilder.maxDate(new Date(System.currentTimeMillis()));
        userParamBuilder.searchDirection(SearchSortOrder.TOWARDS_PAST);
        RecentChangesParams2 searchParams = userParamBuilder.build().generateChangelogParams("cvs");
        RecentChangesSearcher2 searcher = new RecentChangesSearcher2(this.engine.getInternalRevisionCache());
        List changeSets = searcher.findRecentChangeSets(searchParams);
        Assert.assertEquals((int)6, (int)changeSets.size());
        Assert.assertEquals((String)((ChangeSet)changeSets.get(0)).getId(), (String)"MAIN:brendan:20041014145930");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(1)).getId(), (String)"MAIN:brendan:20041012133813");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(2)).getId(), (String)"MAIN:brendan:20041012105308");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(3)).getId(), (String)"MAIN:brendan:20041011005813");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(4)).getId(), (String)"MAIN:brendan:20040927035147");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(5)).getId(), (String)"MAIN:brendan:20040927034003");
        userParamBuilder.setFileExtension("java");
        searchParams = userParamBuilder.build().generateChangelogParams("cvs");
        changeSets = searcher.findRecentChangeSets(searchParams);
        Assert.assertEquals((int)changeSets.size(), (int)6);
        Assert.assertEquals((String)((ChangeSet)changeSets.get(0)).getId(), (String)"MAIN:brendan:20040927035147");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(1)).getId(), (String)"MAIN:brendan:20040927034003");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(2)).getId(), (String)"MAIN:brendan:20040924055317");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(3)).getId(), (String)"MAIN:brendan:20040924054708");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(4)).getId(), (String)"MAIN:brendan:20040723071526");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(5)).getId(), (String)"MAIN:brendan:20040526080128");
        userParamBuilder.setBranch("BRANCH1");
        searchParams = userParamBuilder.build().generateChangelogParams("cvs");
        changeSets = searcher.findRecentChangeSets(searchParams);
        Assert.assertTrue((boolean)changeSets.isEmpty());
        userParamBuilder.setBranch("PROD_136");
        searchParams = userParamBuilder.build().generateChangelogParams("cvs");
        changeSets = searcher.findRecentChangeSets(searchParams);
        Assert.assertEquals((int)2, (int)changeSets.size());
        Assert.assertEquals((String)((ChangeSet)changeSets.get(0)).getId(), (String)"PROD_136:brendan:20031127062444");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(1)).getId(), (String)"PROD_136:brendan:20031120042248");
        userParamBuilder.setCommentSearchText("doofus");
        searchParams = userParamBuilder.build().generateChangelogParams("cvs");
        changeSets = searcher.findRecentChangeSets(searchParams);
        Assert.assertEquals((int)1, (int)changeSets.size());
        Assert.assertEquals((String)((ChangeSet)changeSets.get(0)).getId(), (String)"PROD_136:brendan:20031127062444");
        userParamBuilder.setBranch("MAIN");
        userParamBuilder.setCompulsoryCommitter("matt");
        userParamBuilder.setCommentSearchText("blah");
        userParamBuilder.setFileExtension(".txt");
        userParamBuilder.minDate(new Date(DateHelper.parseDate((String)"2004-07-01T00:00:00", (long)System.currentTimeMillis(), (TimeZone)AppConfig.getsConfig().getTimezone())));
        userParamBuilder.maxDate(new Date(DateHelper.parseDate((String)"2004-08-31T00:00:00", (long)System.currentTimeMillis(), (TimeZone)AppConfig.getsConfig().getTimezone())));
        searchParams = userParamBuilder.build().generateChangelogParams("cvs");
        changeSets = searcher.findRecentChangeSets(searchParams);
        Assert.assertEquals((int)6, (int)changeSets.size());
        Assert.assertEquals((String)((ChangeSet)changeSets.get(0)).getId(), (String)"MAIN:matt:20040830081737");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(1)).getId(), (String)"MAIN:matt:20040823010523");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(2)).getId(), (String)"MAIN:matt:20040823010443");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(3)).getId(), (String)"MAIN:matt:20040823010419");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(4)).getId(), (String)"MAIN:matt:20040723003145");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(5)).getId(), (String)"MAIN:matt:20040723002914");
        userParamBuilder.setFilename("x");
        searchParams = userParamBuilder.build().generateChangelogParams("cvs");
        changeSets = searcher.findRecentChangeSets(searchParams);
        Assert.assertEquals((int)4, (int)changeSets.size());
        Assert.assertEquals((String)((ChangeSet)changeSets.get(0)).getId(), (String)"MAIN:matt:20040723003145");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(1)).getId(), (String)"MAIN:matt:20040723002914");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(2)).getId(), (String)"MAIN:matt:20040723002514");
        Assert.assertEquals((String)((ChangeSet)changeSets.get(3)).getId(), (String)"MAIN:matt:20040723002355");
        userParamBuilder.setFilename("cleansweeper");
        userParamBuilder.minDate(null);
        userParamBuilder.maxDate(null);
        userParamBuilder.setCommentSearchText(null);
        userParamBuilder.setFileExtension(null);
        searchParams = userParamBuilder.build().generateChangelogParams("cvs");
        changeSets = searcher.findRecentChangeSets(searchParams);
        Assert.assertEquals((int)1, (int)changeSets.size());
        Assert.assertEquals((String)((ChangeSet)changeSets.get(0)).getId(), (String)"MAIN:matt:20021216102031");
    }

    @Test
    public void testChangesetSearch() throws Exception {
        RecentChangesParams2 params = new RecentChangesParams2();
        params.setMaxReturn(2000);
        RecentChangesSearcher2 searcher = new RecentChangesSearcher2(this.engine);
        params.setSearchDirection(0);
        List changeSets1 = searcher.findRecentChangeSets(params);
        Assert.assertTrue((changeSets1.size() > 200 ? 1 : 0) != 0);
        for (int i = 1; i < changeSets1.size(); ++i) {
            ChangeSet cs1 = (ChangeSet)changeSets1.get(i - 1);
            ChangeSet cs2 = (ChangeSet)changeSets1.get(i);
            Assert.assertTrue((String)(cs1.getId() + " vs " + cs2.getId()), (cs1.getDate() >= cs2.getDate() ? 1 : 0) != 0);
            this.assertPrevChangeset(cs1, cs2);
            this.assertNextChangeset(cs2, cs1);
        }
        params.setSearchDirection(1);
        List changeSets2 = searcher.findRecentChangeSets(params);
        Assert.assertEquals((int)changeSets1.size(), (int)changeSets2.size());
        for (int i = 0; i < changeSets2.size(); ++i) {
            Assert.assertEquals((String)((ChangeSet)changeSets1.get(changeSets1.size() - i - 1)).getId(), (String)((ChangeSet)changeSets2.get(i)).getId());
            if (i <= 0) continue;
            ChangeSet cs1 = (ChangeSet)changeSets2.get(i - 1);
            ChangeSet cs2 = (ChangeSet)changeSets2.get(i);
            Assert.assertTrue((String)(cs1.getId() + " vs " + cs2.getId()), (cs1.getDate() <= cs2.getDate() ? 1 : 0) != 0);
            this.assertPrevChangeset(cs2, cs1);
            this.assertNextChangeset(cs1, cs2);
        }
    }

    @Test
    public void testFSH235() throws Exception {
        this.subtestFSH235("MAIN:matt:20041116234847", Path.ROOT);
        this.subtestFSH235("MAIN:matt:20041116234847", new Path((CharSequence)"emptytests/empty_on_branch"));
        this.subtestFSH235("MAIN:matt:20041116234847", new Path((CharSequence)"test/branching"));
    }

    private void subtestFSH235(String csid, Path path) throws Exception {
        RevisionCache revisionCache = this.engine.getRevisionCache();
        RecentChangesParams2 params = new RecentChangesParams2();
        ChangeSet cs = revisionCache.getChangeSet(csid);
        params.setBasePath(path);
        params.setMaxChangeset(cs, true);
        params.setMinChangeset(cs, true);
        RecentChangesSearcher2 searcher = new RecentChangesSearcher2(this.engine);
        List changeSets = searcher.findRecentChangeSets(params);
        Assert.assertEquals((int)1, (int)changeSets.size());
        ChangeSet result = (ChangeSet)changeSets.get(0);
        Assert.assertEquals((String)csid, (String)result.getId());
    }

    private void assertNextChangeset(ChangeSet cs2, ChangeSet cs1) throws Exception {
        String nextCsid = this.findNextChangeset(cs2, Path.ROOT);
        Assert.assertEquals((String)cs1.getId(), (String)nextCsid);
    }

    private String findNextChangeset(ChangeSet cs, Path path) throws Exception {
        RecentChangesParams2 nextParams = new RecentChangesParams2();
        nextParams.setBasePath(path);
        nextParams.setMaxReturn(1);
        nextParams.setSearchDirection(1);
        nextParams.setMaxChangeset(null, false);
        nextParams.setMinChangeset(cs, false);
        RecentChangesSearcher2 rcs = new RecentChangesSearcher2(this.engine);
        List nextChangesets = rcs.findRecentChangeSets(nextParams);
        return ((ChangeSet)nextChangesets.get(0)).getId();
    }

    private void assertPrevChangeset(ChangeSet cs2, ChangeSet cs3) throws Exception {
        String prevCsid = this.findPrevChangeset(cs2, Path.ROOT);
        Assert.assertEquals((String)cs3.getId(), (String)prevCsid);
    }

    private String findPrevChangeset(ChangeSet cs, Path path) throws Exception {
        RecentChangesParams2 prevParams = new RecentChangesParams2();
        prevParams.setBasePath(path);
        prevParams.setMaxReturn(1);
        prevParams.setSearchDirection(0);
        prevParams.setMinChangeset(null, false);
        prevParams.setMaxChangeset(cs, false);
        RecentChangesSearcher2 rcs = new RecentChangesSearcher2(this.engine);
        List prevChangesets = rcs.findRecentChangeSets(prevParams);
        return ((ChangeSet)prevChangesets.get(0)).getId();
    }

    @Test
    public void testNextPrevChangeset() throws Exception {
        RevisionCache revisionCache = this.engine.getRevisionCache();
        ChangeSet currCs = revisionCache.getChangeSet("MAIN:matt:20030214060223");
        Path path = Path.ROOT;
        String nextCs = this.findNextChangeset(currCs, path);
        String prevCs = this.findPrevChangeset(currCs, path);
        Assert.assertFalse((boolean)nextCs.equals(prevCs));
        Assert.assertFalse((boolean)currCs.getId().equals(prevCs));
        Assert.assertFalse((boolean)currCs.getId().equals(nextCs));
        Assert.assertEquals((String)"yoyo:matt:20030214060223", (String)nextCs);
        Assert.assertEquals((String)"MAIN:anthony:20030214044800", (String)prevCs);
    }
}

