/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.reptest;

import com.cenqua.fisheye.util.MD5;
import com.cenqua.fisheye.util.StringUtil;
import junit.framework.TestCase;

public class MD5Test
extends TestCase {
    public void testRFC_1321() {
        this.testHash("", "d41d8cd98f00b204e9800998ecf8427e");
        this.testHash("a", "0cc175b9c0f1b6a831c399e269772661");
        this.testHash("abc", "900150983cd24fb0d6963f7d28e17f72");
        this.testHash("message digest", "f96b697d7cb7938d525a2f31aaf161d0");
        this.testHash("abcdefghijklmnopqrstuvwxyz", "c3fcd3d76192e4007dfb496cca67e13b");
        this.testHash("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "d174ab98d277d9f5a5611c2c9f419d9f");
        this.testHash("12345678901234567890123456789012345678901234567890123456789012345678901234567890", "57edf4a22be3c955ac49da2e2107b67a");
    }

    private void testHash(String input, String expected) {
        MD5Test.assertTrue((boolean)expected.equalsIgnoreCase(MD5.hash((String)input)));
    }

    public void testHexDecoding() {
        byte b0;
        int i;
        for (i = 0; i <= 255; ++i) {
            byte b = (byte)i;
            String expected = String.format("%02x", i);
            String s = StringUtil.hexEncode((byte[])new byte[]{b});
            MD5Test.assertEquals((String)expected, (String)s);
            byte[] bytes = MD5.hexDecode((String)s);
            MD5Test.assertEquals((int)1, (int)bytes.length);
            MD5Test.assertEquals((byte)b, (byte)bytes[0]);
        }
        for (i = 256; i < 65535; ++i) {
            b0 = (byte)(i & 0xFF);
            byte b1 = (byte)(i >> 8 & 0xFF);
            String expected = String.format("%04x", i);
            String s = StringUtil.hexEncode((byte[])new byte[]{b1, b0});
            MD5Test.assertEquals((String)expected, (String)s);
            byte[] bytes = MD5.hexDecode((String)s);
            MD5Test.assertEquals((int)2, (int)bytes.length);
            MD5Test.assertEquals((byte)b1, (byte)bytes[0]);
            MD5Test.assertEquals((byte)b0, (byte)bytes[1]);
        }
        for (i = 65536; i < 1048575; ++i) {
            b0 = (byte)(i & 0xFF);
            byte b1 = (byte)(i >> 8 & 0xFF);
            byte b2 = (byte)(i >> 16 & 0xFF);
            String expected = String.format("%06x", i);
            String s = StringUtil.hexEncode((byte[])new byte[]{b2, b1, b0});
            MD5Test.assertEquals((String)expected, (String)s);
            byte[] bytes = MD5.hexDecode((String)s);
            MD5Test.assertEquals((int)3, (int)bytes.length);
            MD5Test.assertEquals((byte)b2, (byte)bytes[0]);
            MD5Test.assertEquals((byte)b1, (byte)bytes[1]);
            MD5Test.assertEquals((byte)b0, (byte)bytes[2]);
        }
    }
}

