/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.reptest;

import com.atlassian.fisheye.bucket.BreakdownOption;
import com.atlassian.fisheye.bucket.BucketData;
import com.atlassian.fisheye.bucket.BucketDataElement;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.atlassian.fisheye.bucket.TestUtils;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.util.Disposer;
import java.util.TimeZone;
import junit.framework.Assert;
import org.jfree.data.xy.XYSeries;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.RestoreSystemProperties;

public final class LinecountTest {
    private static final boolean ENABLED_FALLBACK = true;
    private BucketGraph dataCollector;
    private TimeZone tzOrigSystem = TimeZone.getDefault();
    private TimeZone tzOrigConfig = TimeZone.getDefault();
    private final TimeZone timeZonePerth = TimeZone.getTimeZone("Asia/Tokyo");
    private final TimeZone timeZonePoland = TimeZone.getTimeZone("Europe/Warsaw");
    private final Path path = new Path((CharSequence)"CleanSweeper.java");
    private RepositoryEngine engine;
    @Rule
    public final RestoreSystemProperties restoreSystemProperties = new RestoreSystemProperties();

    @Before
    public void setUp() throws Exception {
        Disposer.pushThreadInstance();
    }

    private void init(TimeZone timeZone) throws Exception {
        this.init(timeZone, false);
    }

    private void init(TimeZone timeZone, Boolean enableFallback) throws Exception {
        TestFishEyeInstances.stop();
        this.tzOrigSystem = TimeZone.getDefault();
        TimeZone.setDefault(timeZone);
        if (AppConfig.getsConfig() != null) {
            this.tzOrigConfig = AppConfig.getsConfig().getTimezone();
            if (AppConfig.getsConfig() != null && AppConfig.getsConfig().getConfigDocument() != null) {
                AppConfig.getsConfig().getConfig().setTimezone(timeZone.getID());
            }
        }
        System.setProperty("fisheye.blame.scm.fallback.enable", enableFallback.toString());
        FishEyeSysProps.reloadProperties();
        RepositoryHandle handle = this.whichHandle();
        this.engine = handle.acquireEngine();
        this.dataCollector = this.engine.getBucketGraph();
        this.dataCollector.reindex(this.engine.getLinecountCalculator(), this.engine.getStatus());
    }

    @After
    public void tearDown() throws Exception {
        AppConfig.getsConfig().getConfig().setTimezone(this.tzOrigConfig.getID());
        AppConfig.getsConfig().reload();
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
        TimeZone.setDefault(this.tzOrigSystem);
    }

    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.reslurpAndGetSanity1Repos2();
    }

    @Test
    public void testUpdateWithPolishTimezone() throws Exception {
        this.init(this.timeZonePoland, true);
        this.implTestUpdateWithPolishLocaleAndTimezone();
    }

    @Test
    public void testUpdateWithSydneyTimeZone() throws Exception {
        this.init(this.timeZonePerth, true);
        this.implTestIncrementalUpdate();
    }

    @Test
    public void testAuthorLinecounts() throws Exception {
        this.init(this.timeZonePerth, true);
        this.runAuthorLinecountTests(0);
        System.out.println("0\n" + this.dataCollector.toStringFull() + "\n");
        TestFishEyeInstances.advanceSanity1Repos2(1);
        this.runAuthorLinecountTests(1);
        System.out.println("1\n" + this.dataCollector.toStringFull() + "\n");
    }

    @Test
    public void testAuthorLinecountsReslurp() throws Exception {
        this.init(this.timeZonePerth, true);
        this.dataCollector.reindex(this.engine.getLinecountCalculator(), this.engine.getStatus());
        this.runAuthorLinecountTests(0);
        TestFishEyeInstances.advanceSanity1Repos2(1);
        this.dataCollector.reindex(this.engine.getLinecountCalculator(), this.engine.getStatus());
        this.runAuthorLinecountTests(1);
    }

    private void runAuthorLinecountTests(int index) throws DbException {
        String[] main = new String[]{"{__ALL_AUTHORS__={0={12029=[321(+321),2(+2)], 12041=[365(+44),4(+2)], 12070=[361(-4),5(+1)], 12098=[361(+0),6(+1)], 12101=[365(+4),7(+1)], 12141=[365(+0),8(+1)], 12156=[365(+0),9(+1)]}}, anthony={0={12029=[321(+321),2(+2)], 12041=[365(+44),3(+1)], 12070=[361(-4),4(+1)], 12098=[361(+0),5(+1)], 12101=[365(+4),6(+1)], 12141=[365(+0),7(+1)], 12156=[364(-1),7(+0)]}}, brendan={0={12156=[1(+1),1(+1)]}}, matt={0={12041=[0(+0),1(+1)]}}}", "{__ALL_AUTHORS__={0={12029=[321(+321),2(+2)], 12041=[365(+44),4(+2)], 12070=[361(-4),5(+1)], 12098=[361(+0),6(+1)], 12101=[365(+4),7(+1)], 12141=[365(+0),8(+1)], 12156=[365(+0),9(+1)], 12157=[364(-1),10(+1)]}}, anthony={0={12029=[321(+321),2(+2)], 12041=[365(+44),3(+1)], 12070=[361(-4),4(+1)], 12098=[361(+0),5(+1)], 12101=[365(+4),6(+1)], 12141=[365(+0),7(+1)], 12156=[364(-1),7(+0)], 12157=[362(-2),7(+0)]}}, brendan={0={12156=[1(+1),1(+1)], 12157=[2(+1),2(+1)]}}, matt={0={12041=[0(+0),1(+1)]}}}"};
        String[] prod_136 = new String[]{"{__ALL_AUTHORS__={0={12156=[365(+365),0(+0)], 12380=[379(+14),1(+1)], 12387=[389(+10),2(+1)]}}, anthony={0={12156=[364(+364),0(+0)], 12380=[341(-23),0(+0)]}}, brendan={0={12156=[1(+1),0(+0)], 12380=[38(+37),1(+1)], 12387=[48(+10),2(+1)]}}}", "{__ALL_AUTHORS__={0={12156=[365(+365),0(+0)], 12380=[379(+14),1(+1)], 12387=[389(+10),2(+1)]}}, anthony={0={12156=[364(+364),0(+0)], 12380=[341(-23),0(+0)]}}, brendan={0={12156=[1(+1),0(+0)], 12380=[38(+37),1(+1)], 12387=[48(+10),2(+1)]}}}"};
        String[] chalk = new String[]{"{__ALL_AUTHORS__={0={12156=[365(+365),0(+0)]}}, anthony={0={12156=[364(+364),0(+0)]}}, brendan={0={12156=[1(+1),0(+0)]}}}", "{__ALL_AUTHORS__={0={12156=[365(+365),0(+0)]}}, anthony={0={12156=[364(+364),0(+0)]}}, brendan={0={12156=[1(+1),0(+0)]}}}"};
        ParameterSetQuery params = new ParameterSetQuery();
        params.setExtension(".java");
        params.setBreakdown(BreakdownOption.AUTHOR);
        params.setBranch("MAIN");
        System.out.println(params.getBranch() + " " + index);
        System.out.println(this.dataCollector.getBuckets(params).toString());
        Assert.assertEquals((String)main[index], (String)this.dataCollector.getBuckets(params).toString());
        params.setBranch("PROD_136");
        System.out.println(params.getBranch() + " " + index);
        System.out.println(this.dataCollector.getBuckets(params).toString());
        Assert.assertEquals((String)prod_136[index], (String)this.dataCollector.getBuckets(params).toString());
        params.setBranch("CHALK");
        System.out.println(params.getBranch() + " " + index);
        System.out.println(this.dataCollector.getBuckets(params).toString());
        Assert.assertEquals((String)chalk[index], (String)this.dataCollector.getBuckets(params).toString());
    }

    private void implTestUpdateWithPolishLocaleAndTimezone() throws Exception {
        this.checkPathAgainstString(this.path, null, TestUtils.readFile("LinecountTestOutput1-Polish.txt"), this.timeZonePoland);
        this.checkPathAgainstString(this.path, "PROD_136", TestUtils.readFile("LinecountTestOutput2-Polish.txt"), this.timeZonePoland);
    }

    @Test
    public void testChangeingTimezones() throws Exception {
        this.init(TimeZone.getDefault());
        RootConfig rootConfig = AppConfig.getsConfig();
        TimeZone tz = AppConfig.getsConfig().getTimezone();
        rootConfig.getConfig().setTimezone("Europe/Warsaw");
        rootConfig.reload();
        Assert.assertEquals((String)rootConfig.getTimezone().getID(), (String)"Europe/Warsaw");
        rootConfig.getConfig().setTimezone(tz.getID());
        rootConfig.reload();
        Assert.assertEquals((String)rootConfig.getTimezone().getID(), (String)tz.getID());
    }

    private void implTestIncrementalUpdate() throws Exception {
        this.checkPathAgainstString(this.path, "__TRUNKLIKE__", TestUtils.readFile("LinecountTestOutput1.txt"), this.timeZonePerth);
        this.checkPathAgainstString(this.path, "PROD_136", TestUtils.readFile("LinecountTestOutput2.txt"), this.timeZonePerth);
        FileHistory hist = this.engine.getRevisionCache().getFileHistory(this.path);
        ParameterSetQuery params = new ParameterSetQuery();
        params.setPath(this.path);
        BucketData bucketDataNew = this.dataCollector.getBuckets(params).getFirst();
        Assert.assertEquals((String)"Initial file history for trunk", (String)TestUtils.fileHistoryToString(hist, null, this.timeZonePerth), (String)"Wed Dec 04 08:04:08 JST 2002 313 (+313 -0: 313)\nWed Dec 04 13:59:47 JST 2002 321 (+8 -0: 8)\nMon Dec 16 09:24:39 JST 2002 366 (+66 -21: 45)\nMon Dec 16 19:20:31 JST 2002 365 (+0 -1: -1)\nTue Jan 14 16:26:30 JST 2003 361 (+9 -13: -4)\nTue Feb 11 09:02:12 JST 2003 361 (+1 -1: 0)\nFri Feb 14 13:48:00 JST 2003 365 (+57 -53: 4)\nWed Mar 26 08:58:29 JST 2003 365 (+1 -1: 0)\nThu Apr 10 16:22:42 JST 2003 365 (+1 -1: 0)\n");
        Assert.assertEquals((String)"Initial bucket data for trunk", (String)TestUtils.bucketDataToString((BucketData<BucketDataElement>)bucketDataNew, this.timeZonePerth), (String)"12029[Wed Dec 04 00:00:00 JST 2002 - Wed Dec 04 23:59:59 JST 2002]: LOC 321,\t revs 2\n12041[Mon Dec 16 00:00:00 JST 2002 - Mon Dec 16 23:59:59 JST 2002]: LOC 44,\t revs 2\n12070[Tue Jan 14 00:00:00 JST 2003 - Tue Jan 14 23:59:59 JST 2003]: LOC -4,\t revs 1\n12098[Tue Feb 11 00:00:00 JST 2003 - Tue Feb 11 23:59:59 JST 2003]: LOC 0,\t revs 1\n12101[Fri Feb 14 00:00:00 JST 2003 - Fri Feb 14 23:59:59 JST 2003]: LOC 4,\t revs 1\n12141[Wed Mar 26 00:00:00 JST 2003 - Wed Mar 26 23:59:59 JST 2003]: LOC 0,\t revs 1\n12156[Thu Apr 10 00:00:00 JST 2003 - Thu Apr 10 23:59:59 JST 2003]: LOC 0,\t revs 1\n");
        Assert.assertEquals((String)"Initial file history for branch PROD_136", (String)TestUtils.fileHistoryToString(hist, "PROD_136", this.timeZonePerth), (String)"Thu Nov 20 13:22:48 JST 2003 379 (+38 -24: 14)\nThu Nov 27 15:24:44 JST 2003 389 (+14 -4: 10)\n");
        params.setBranch("PROD_136");
        bucketDataNew = this.dataCollector.getBuckets(params).getFirst();
        Assert.assertEquals((String)"Initial bucket data for branch PROD_136", (String)TestUtils.bucketDataToString((BucketData<BucketDataElement>)bucketDataNew, this.timeZonePerth), (String)"12156[Thu Apr 10 00:00:00 JST 2003 - Thu Apr 10 23:59:59 JST 2003]: LOC 365,\t revs 0\n12380[Thu Nov 20 00:00:00 JST 2003 - Thu Nov 20 23:59:59 JST 2003]: LOC 14,\t revs 1\n12387[Thu Nov 27 00:00:00 JST 2003 - Thu Nov 27 23:59:59 JST 2003]: LOC 10,\t revs 1\n");
        TestFishEyeInstances.advanceSanity1Repos2(1);
        hist = this.engine.getRevisionCache().getFileHistory(this.path);
        Assert.assertEquals((String)"File history for trunk after first advance", (String)TestUtils.fileHistoryToString(hist, null, this.timeZonePerth), (String)"Wed Dec 04 08:04:08 JST 2002 313 (+313 -0: 313)\nWed Dec 04 13:59:47 JST 2002 321 (+8 -0: 8)\nMon Dec 16 09:24:39 JST 2002 366 (+66 -21: 45)\nMon Dec 16 19:20:31 JST 2002 365 (+0 -1: -1)\nTue Jan 14 16:26:30 JST 2003 361 (+9 -13: -4)\nTue Feb 11 09:02:12 JST 2003 361 (+1 -1: 0)\nFri Feb 14 13:48:00 JST 2003 365 (+57 -53: 4)\nWed Mar 26 08:58:29 JST 2003 365 (+1 -1: 0)\nThu Apr 10 16:22:42 JST 2003 365 (+1 -1: 0)\nFri Apr 11 16:22:42 JST 2003 364 (+1 -2: -1)\n");
        Assert.assertEquals((String)"File history for branch PROD_136 after first advance", (String)TestUtils.fileHistoryToString(hist, "PROD_136", this.timeZonePerth), (String)"Thu Nov 20 13:22:48 JST 2003 379 (+38 -24: 14)\nThu Nov 27 15:24:44 JST 2003 389 (+14 -4: 10)\n");
        this.checkPathAgainstString(this.path, null, TestUtils.readFile("LinecountTestOutput3.txt"), this.timeZonePerth);
        this.checkPathAgainstString(this.path, "PROD_136", TestUtils.readFile("LinecountTestOutput4.txt"), this.timeZonePerth);
        TestFishEyeInstances.advanceSanity1Repos2(2);
        hist = this.engine.getRevisionCache().getFileHistory(this.path);
        Assert.assertEquals((String)"File history for trunk after second advance", (String)TestUtils.fileHistoryToString(hist, null, this.timeZonePerth), (String)"Wed Dec 04 08:04:08 JST 2002 313 (+313 -0: 313)\nWed Dec 04 13:59:47 JST 2002 321 (+8 -0: 8)\nMon Dec 16 09:24:39 JST 2002 366 (+66 -21: 45)\nMon Dec 16 19:20:31 JST 2002 365 (+0 -1: -1)\nTue Jan 14 16:26:30 JST 2003 361 (+9 -13: -4)\nTue Feb 11 09:02:12 JST 2003 361 (+1 -1: 0)\nFri Feb 14 13:48:00 JST 2003 365 (+57 -53: 4)\nWed Mar 26 08:58:29 JST 2003 365 (+1 -1: 0)\nThu Apr 10 16:22:42 JST 2003 365 (+1 -1: 0)\nFri Apr 11 16:22:42 JST 2003 364 (+1 -2: -1)\n");
        Assert.assertEquals((String)"File history for branch PROD_136 after second advance", (String)TestUtils.fileHistoryToString(hist, "PROD_136", this.timeZonePerth), (String)"Thu Nov 20 13:22:48 JST 2003 379 (+38 -24: 14)\nThu Nov 27 15:24:44 JST 2003 389 (+14 -4: 10)\n");
        this.checkPathAgainstString(this.path, null, TestUtils.readFile("LinecountTestOutput3.txt"), this.timeZonePerth);
        this.checkPathAgainstString(this.path, "PROD_136", TestUtils.readFile("LinecountTestOutput4.txt"), this.timeZonePerth);
        TestFishEyeInstances.advanceSanity1Repos2(3);
        hist = this.engine.getRevisionCache().getFileHistory(this.path);
        Assert.assertEquals((String)"File history for trunk after third advance", (String)TestUtils.fileHistoryToString(hist, null, this.timeZonePerth), (String)"Wed Dec 04 08:04:08 JST 2002 313 (+313 -0: 313)\nWed Dec 04 13:59:47 JST 2002 321 (+8 -0: 8)\nMon Dec 16 09:24:39 JST 2002 366 (+66 -21: 45)\nMon Dec 16 19:20:31 JST 2002 365 (+0 -1: -1)\nTue Jan 14 16:26:30 JST 2003 361 (+9 -13: -4)\nTue Feb 11 09:02:12 JST 2003 361 (+1 -1: 0)\nFri Feb 14 13:48:00 JST 2003 365 (+57 -53: 4)\nWed Mar 26 08:58:29 JST 2003 365 (+1 -1: 0)\nThu Apr 10 16:22:42 JST 2003 365 (+1 -1: 0)\nFri Apr 11 16:22:42 JST 2003 364 (+1 -2: -1)\n");
        Assert.assertEquals((String)"File history for branch PROD_136 after third advance", (String)TestUtils.fileHistoryToString(hist, "PROD_136", this.timeZonePerth), (String)"Thu Nov 20 13:22:48 JST 2003 379 (+38 -24: 14)\nThu Nov 27 15:24:44 JST 2003 389 (+14 -4: 10)\n");
        this.checkPathAgainstString(this.path, null, TestUtils.readFile("LinecountTestOutput3.txt"), this.timeZonePerth);
        this.checkPathAgainstString(this.path, "PROD_136", TestUtils.readFile("LinecountTestOutput4.txt"), this.timeZonePerth);
    }

    private void checkPathAgainstString(Path path, String branch, String string, TimeZone timeZone) throws Exception {
        ParameterSetQuery params = new ParameterSetQuery();
        params.setPath(path);
        params.setBranch(branch);
        XYSeries dataNew = this.dataCollector.getXYSeries(params, PeriodUnit.DAY).getLinecountCollection().getSeries(0);
        Assert.assertEquals((String)string, (String)TestUtils.seriesToString(dataNew, timeZone));
    }
}

