/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.reptest;

import com.atlassian.fecru.search.common.api.SearchResults;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.filepaths.FilePathResult;
import com.atlassian.fecru.search.filepaths.FilePathSearcher;
import com.cenqua.fisheye.cvsrep.RepSanityTestBase;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public final class FilePathSearcherIntegrationTest
extends RepSanityTestBase {
    @Test
    public void testFilePathSearchSimple() {
        FilePathSearcher searcher = new FilePathSearcher(this.repositoryManager, this.engine.getCrossRepLuceneIndex());
        this.checkSearch(searcher, "Clean", "test/CleanSweeper.java");
        this.checkSearch(searcher, "CleanSweeper.java", "test/CleanSweeper.java");
        this.checkSearch(searcher, "cleansweeper.java", "test/CleanSweeper.java");
        this.checkSearch(searcher, "cleansweeper", "test/CleanSweeper.java");
        this.checkSearch(searcher, "CleanSweeper", "test/CleanSweeper.java");
        this.checkSearch(searcher, "CleSwe", "test/CleanSweeper.java");
        this.checkSearch(searcher, "CS", "test/CleanSweeper.java", "test/ws/CLISetup.vdproj");
        this.checkSearch(searcher, "file.txt", "test/longdir/dir1/the/quick/brown/fox/jumps/over/the/lazy/dog/too/many/cooks/spoil/the/broth/blah/foo/bar/file.txt", "test/addremove/file.txt", "test/funny#dir/file.txt", "test/funny file.txt", "test/funny#file.txt", "test/kw/strange$file.txt");
        this.checkSearch(searcher, "kw", "test/kw");
    }

    @Test
    public void testBranches() {
        FilePathSearcher searcher = new FilePathSearcher(this.repositoryManager, this.engine.getCrossRepLuceneIndex());
        SearchResults results = searcher.search("Clean", SearchScope.builder().withTo(1).withRepositories(new RepositoryHandle[]{this.handle}).build());
        Assert.assertTrue((String)"Search for Clean should hit test/CleanSweeper.java", (results.getTotalCount() == 1 ? 1 : 0) != 0);
        FilePathResult result = (FilePathResult)results.iterator().next();
        this.checkBranches(result, "MAIN", "PROD_136");
        results = searcher.search("test.text", SearchScope.builder().withTo(1).withRepositories(new RepositoryHandle[]{this.handle}).build());
        Assert.assertTrue((String)"Search for test.text should hit test/test.text", (results.getTotalCount() == 1 ? 1 : 0) != 0);
        result = (FilePathResult)results.iterator().next();
        this.checkBranches(result, "MAIN", "BRANCH2", "yoyo");
    }

    private void checkBranches(FilePathResult result, String ... expectedBranches) {
        List latestBranches = result.getHeadRevisions();
        Assert.assertTrue((String)("Expected " + expectedBranches.length + " branches for " + result.getLogicalPath()), (latestBranches.size() == expectedBranches.length ? 1 : 0) != 0);
        ArrayList<String> resultBranches = new ArrayList<String>();
        for (FileRevision rev : latestBranches) {
            resultBranches.add(rev.getBranch());
        }
        for (String branch : expectedBranches) {
            Assert.assertTrue((String)("expected " + branch + " in branch list for " + result.getLogicalPath()), (boolean)resultBranches.contains(branch));
        }
    }

    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.getSanity1Repos(false);
    }

    private void checkSearch(FilePathSearcher searcher, String query, String ... expected) {
        SearchResults results = searcher.search(query, SearchScope.builder().withTo(expected.length).withRepositories(new RepositoryHandle[]{this.handle}).build());
        ArrayList<String> expectedAsList = new ArrayList<String>(Arrays.asList(expected));
        for (FilePathResult result : results) {
            String logicalPath = result.getLogicalPath();
            Assert.assertTrue((String)("for query \"" + query + "\" got " + logicalPath + " but was expecting one of " + expectedAsList), (boolean)expectedAsList.contains(logicalPath));
            expectedAsList.remove(logicalPath);
        }
        Assert.assertTrue((String)("results missing: " + expectedAsList + ", was searching for: " + query), (boolean)expectedAsList.isEmpty());
    }
}

