/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.reptest;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.dirtree.DirTreeCache;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class DirTreeCacheTest {
    private RepositoryEngine engine;
    private RevisionCache cache;

    @Before
    public void setUp() throws Exception {
        Disposer.pushThreadInstance();
        RepositoryHandle handle = TestFishEyeInstances.getSanity1Repos();
        this.engine = handle.acquireEngine();
        this.cache = this.engine.getRevisionCache();
    }

    @After
    public void tearDown() throws Exception {
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testSimple() throws Exception {
        this.assertSubdirs(new Path((CharSequence)"test"), new String[]{"addremove", "branching", "changeset", "cvsnt1", "funny dir", "funny#dir", "kw", "longdir", "support", "test", "ws"});
        this.subtestEmptyDirs(new Path((CharSequence)"test"), null, new String[0]);
    }

    @Test
    public void testEmpty() throws Exception {
        this.assertSubdirs(new Path((CharSequence)"emptytests"), new String[]{"empty", "deletedfiles", "notempty", "empty_on_branch"});
        this.subtestEmptyDirs(new Path((CharSequence)"emptytests"), null, new String[]{"empty", "deletedfiles"});
        WaybackSpec wb = new WaybackSpec();
        wb.setBranch("MAIN");
        this.subtestEmptyDirs(new Path((CharSequence)"emptytests"), wb, new String[]{"empty", "deletedfiles"});
        wb = new WaybackSpec();
        wb.setBranch("BRANCH_1");
        this.subtestEmptyDirs(new Path((CharSequence)"emptytests"), wb, new String[]{"empty", "deletedfiles", "notempty", "empty_on_branch"});
        wb = new WaybackSpec();
        wb.setAuthor("matt");
        this.subtestEmptyDirs(new Path((CharSequence)"emptytests"), wb, new String[]{"empty", "deletedfiles"});
        wb = new WaybackSpec();
        wb.setDateStr("2004-11-16T23:48:47");
        wb.setDate(DateHelper.componentsToTime((int)2004, (int)11, (int)16, (int)23, (int)48, (int)47));
        this.subtestEmptyDirs(new Path((CharSequence)"emptytests"), wb, new String[]{"empty", "deletedfiles"});
        wb = new WaybackSpec();
        wb.setTag("BP_1");
        this.subtestEmptyDirs(new Path((CharSequence)"emptytests"), wb, new String[]{"empty", "deletedfiles", "notempty"});
    }

    private void assertSubdirs(Path p, String[] expectedDirStrings) throws Exception {
        Path[] expectedDirs = this.toPaths(p, expectedDirStrings);
        List<Path> subdirs = Arrays.asList(this.cache.listDirs(p));
        for (Path expectedDir : expectedDirs) {
            Assert.assertTrue((String)expectedDir.toString(), (boolean)subdirs.contains(expectedDir));
        }
        Assert.assertEquals((int)expectedDirs.length, (int)subdirs.size());
    }

    private Path[] toPaths(Path prefix, String[] expectedDirStrings) {
        Path[] result = new Path[expectedDirStrings.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Path(prefix, expectedDirStrings[i]);
        }
        return result;
    }

    private void subtestEmptyDirs(Path p, WaybackSpec wb, String[] expectedEmptyStrings) throws DbException {
        Path[] expectedEmpty = this.toPaths(p, expectedEmptyStrings);
        DirTreeCache dcache = new DirTreeCache(this.engine);
        final LinkedList emptyDirs = new LinkedList();
        final Path[] subdirs = this.cache.listDirs(p);
        dcache.calculateWith(wb, new DirTreeCache.Visitor(){

            public void visit(DirTreeCache.Context calc) throws DbException {
                for (Path subdir : subdirs) {
                    if (!calc.isEmptyOfFiles(subdir)) continue;
                    emptyDirs.add(subdir);
                }
            }
        });
        for (Path path : expectedEmpty) {
            Assert.assertTrue((String)(path.toString() + " should be in " + emptyDirs), (boolean)emptyDirs.contains(path));
        }
        Assert.assertEquals((int)expectedEmpty.length, (int)emptyDirs.size());
    }
}

