/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.reptest;

import com.atlassian.fisheye.event.CommitEventImpl;
import com.atlassian.fisheye.event.RepositoryScanProcessedEvent;
import com.atlassian.fisheye.rep.RepositoryEventCollector;
import com.cenqua.fisheye.cvsrep.CvsTestBase;
import com.cenqua.fisheye.cvsrep.CvsTestHarness;
import com.cenqua.fisheye.rep.BranchChange;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class CvsRepositoryScanProcessedEventTest
extends CvsTestBase {
    private RepositoryEventCollector eventCollector = new RepositoryEventCollector();

    @Override
    protected String getDumpName() {
        return "cvs-test";
    }

    @Override
    protected CvsTestHarness createHarness() {
        return new CvsTestHarness(){

            @Override
            protected void beforeEngineStarted() {
                super.beforeEngineStarted();
                this.registerCommitEventGenerator();
                this.getEventPublisher().register((Object)CvsRepositoryScanProcessedEventTest.this.eventCollector);
            }
        };
    }

    @Test
    public void testScanProcessedEvent() throws Exception {
        List<Object> eventsAfterInitial = this.eventCollector.getAndClearEvents();
        this.testHarness.doIncSlurp(new File("test/testfiles/cvs/cvs-scanprocessed.zip"));
        List<Object> eventsAfterIncremental = this.eventCollector.getAndClearEvents();
        this.testHarness.doIncSlurp(new File("test/testfiles/cvs/cvs-scanprocessed.zip"));
        List<Object> eventsAfterSubsequent = this.eventCollector.getAndClearEvents();
        Assert.assertThat(eventsAfterInitial, (Matcher)Matchers.empty());
        Assert.assertThat(eventsAfterIncremental, (Matcher)Matchers.contains((Object[])new Object[]{new CommitEventImpl(this.testHarness.getRepoName(), "BRANCH_I_MODIFY:lukpater:20140514125527"), new CommitEventImpl(this.testHarness.getRepoName(), "NEW_HOPE:lukpater:20140514125647"), new RepositoryScanProcessedEvent(this.testHarness.getRepoName(), (Iterable)ImmutableSet.of((Object)"BRANCH_I_MODIFY:lukpater:20140514125527", (Object)"NEW_HOPE:lukpater:20140514125647"), (Iterable)ImmutableSet.of((Object)new BranchChange("BRANCH_I_MODIFY", BranchChange.ChangeType.MODIFIED), (Object)new BranchChange("NEW_HOPE", BranchChange.ChangeType.ADDED)))}));
        Assert.assertThat(eventsAfterSubsequent, (Matcher)Matchers.empty());
    }
}

