/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.reptest;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.RepSanityTestBase;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public final class CvsDiffHunkTest
extends RepSanityTestBase {
    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.getSanity1Repos();
    }

    @Test
    public void testHunkInsertion() throws DbException {
        Path path = new Path((CharSequence)"test/tobedeleted.txt");
        FileHistory hist = this.engine.getRevisionCache().getFileHistory(path);
        List revs = hist.getRevisionsSorted();
        List hunks = ((FileRevision)revs.get(0)).getHunks();
        Assert.assertEquals((Object)Hunk.createUnifiedDeleteHunk((int)1, (int)1, (int)4), hunks.get(0));
        Assert.assertEquals((String)"[d<1:4 , 0:0>]", (String)hunks.toString());
        hunks = ((FileRevision)revs.get(1)).getHunks();
        Assert.assertEquals((Object)new Hunk(1, 1, 3, 3), hunks.get(0));
        Assert.assertEquals((String)"[c<1:3 , 1:3>]", (String)hunks.toString());
        hunks = ((FileRevision)revs.get(2)).getHunks();
        Assert.assertEquals((Object)Hunk.createUnifiedAddHunk((int)1, (int)1, (int)4), hunks.get(0));
        Assert.assertEquals((String)"[a<0:0 , 1:4>]", (String)hunks.toString());
        hunks = ((FileRevision)revs.get(3)).getHunks();
        Assert.assertEquals((Object)Hunk.createUnifiedDeleteHunk((int)1, (int)1, (int)2), hunks.get(0));
        Assert.assertEquals((String)"[d<1:2 , 0:0>]", (String)hunks.toString());
        hunks = ((FileRevision)revs.get(4)).getHunks();
        Assert.assertEquals((Object)Hunk.createUnifiedAddHunk((int)2, (int)2, (int)1), hunks.get(0));
        Assert.assertEquals((String)"[a<1:0 , 2:1>]", (String)hunks.toString());
        hunks = ((FileRevision)revs.get(5)).getHunks();
        Assert.assertEquals((Object)Hunk.createUnifiedAddHunk((int)1, (int)1, (int)1), hunks.get(0));
        Assert.assertEquals((String)"[a<0:0 , 1:1>]", (String)hunks.toString());
    }
}

