/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.reptest;

import com.atlassian.fisheye.rep.RevCountChecker;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.CvsTestBase;
import com.cenqua.fisheye.cvsrep.cache.CvsChangeSet;
import com.cenqua.fisheye.lucene.BranchIndexingChecker;
import com.cenqua.fisheye.rep.AncestryTester;
import com.cenqua.fisheye.rep.ChangeSet;
import org.junit.Test;

public class CvsAncestryTest
extends CvsTestBase {
    @Override
    protected String getDumpName() {
        return "cvs-test";
    }

    @Test
    public void testBaseAncestry() {
        CvsChangeSet main0 = this.cache.getChangeSet("MAIN:mwatson:20110504001707");
        AncestryTester.assertParents((RevisionCache)this.cache, (ChangeSet)main0, new String[0]);
        CvsChangeSet initFiles = this.cache.getChangeSet("MAIN:mwatson:20110504002241");
        AncestryTester.assertParents((RevisionCache)this.cache, (ChangeSet)initFiles, main0.getId());
        CvsChangeSet fileInDeepDir = this.cache.getChangeSet("MAIN:mwatson:20110504002344");
        AncestryTester.assertParents((RevisionCache)this.cache, (ChangeSet)fileInDeepDir, initFiles.getId());
        CvsChangeSet mod1s = this.cache.getChangeSet("MAIN:mwatson:20110504002450");
        CvsChangeSet mod2s = this.cache.getChangeSet("MAIN:mwatson:20110504002451");
        AncestryTester.assertParents((RevisionCache)this.cache, (ChangeSet)mod2s, mod1s.getId());
        CvsChangeSet mod9s = this.cache.getChangeSet("MAIN:mwatson:20110504002458");
        CvsChangeSet branchMod1s = this.cache.getChangeSet("BRANCH_I_MODIFY:mwatson:20110504002628");
        AncestryTester.assertParents((RevisionCache)this.cache, (ChangeSet)branchMod1s, mod9s.getId());
        CvsChangeSet branchMod2s = this.cache.getChangeSet("BRANCH_I_MODIFY:mwatson:20110504002629");
        AncestryTester.assertParents((RevisionCache)this.cache, (ChangeSet)branchMod2s, branchMod1s.getId());
        CvsChangeSet mergeToMain = this.cache.getChangeSet("MAIN:mwatson:20110504002747");
        AncestryTester.assertParents((RevisionCache)this.cache, (ChangeSet)mergeToMain, mod9s.getId());
    }

    @Test
    public void testBranchIndexing() {
        BranchIndexingChecker.verifyIndexedBranchesWithRevCache(this.cache);
    }

    @Test
    public void testRevCounts() {
        RevCountChecker.checkRevCounts(this.cache);
    }
}

