/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.reptest;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.vis.BranchTable;
import com.cenqua.fisheye.vis.DrawContextMetrics;
import com.cenqua.fisheye.vis.Graph;
import com.cenqua.fisheye.vis.HistoryRenderer;
import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class CRU778Test {
    private RepositoryEngine engine;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.checkCleanStart();
        Disposer.pushThreadInstance();
        RepositoryHandle handle = TestFishEyeInstances.getSanity1Repos();
        this.engine = handle.acquireEngine();
    }

    @After
    public void tearDown() throws Exception {
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
        TestFishEyeInstances.checkCleanStart();
    }

    @Test
    public void testGraphRenderer() throws Exception {
        FileHistory hist = this.engine.getRevisionCache().getFileHistory(new Path((CharSequence)"test/changeset/file1.txt"));
        List onmain = hist.getRevisions("MAIN");
        Assert.assertEquals((int)5, (int)onmain.size());
        Assert.assertTrue((boolean)onmain.contains("1.1"));
        Assert.assertTrue((boolean)onmain.contains("1.2"));
        Assert.assertTrue((boolean)onmain.contains("1.3"));
        Assert.assertTrue((boolean)onmain.contains("1.4"));
        Assert.assertTrue((boolean)onmain.contains("1.5"));
        Graph graph = new Graph(hist);
        graph.collate();
        BranchTable table = new BranchTable(graph);
        table.collate();
        HistoryRenderer hr = new HistoryRenderer(hist, graph, table, new DrawContextMetrics());
        hr.computeBounds();
    }
}

