/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.reptest;

import com.atlassian.fisheye.it.cvsrep.RepSanity1Test;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class CRU715Test {
    private RepositoryEngine engine;

    @Before
    public void setUp() throws Exception {
        Disposer.pushThreadInstance();
        RepositoryHandle handle = TestFishEyeInstances.getSanity1Repos();
        this.engine = handle.acquireEngine();
    }

    @After
    public void tearDown() throws Exception {
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
        TestFishEyeInstances.checkCleanStart();
    }

    @Test
    public void testJoinsAndGroupBy() throws Exception {
        this.assertResults(this.doQuery("select revisions where content matches 'obscure' and on branch MAIN group by file"), true);
        this.assertResults(this.doQuery("select revisions where content matches 'obscure' group by file"), true);
        this.assertResults(this.doQuery("select revisions where content matches 'obscure' and on branch MAIN group by changeset"), true);
        this.assertResults(this.doQuery("select revisions where content matches 'obscure' group by changeset"), true);
        this.assertResults(this.doQuery("select revisions where content matches 'obscure' and on branch MAIN"), false);
        this.assertResults(this.doQuery("select revisions where content matches 'obscure'"), false);
    }

    private void assertResults(SearchResults results, boolean grouped) throws Exception {
        Assert.assertEquals((int)4, (int)results.size());
        Assert.assertEquals((boolean)grouped, (boolean)results.isGrouped());
        ArrayList<RevInfoKey> keys = new ArrayList<RevInfoKey>();
        SearchResults.RevisionResultsIterator i = results.iterateRevisions(0);
        while (i.hasNext()) {
            RevInfoKey k = i.nextItem().getRevInfoKey();
            Assert.assertTrue((boolean)i.isStartOfGroup());
            keys.add(k);
        }
        Assert.assertEquals((int)4, (int)keys.size());
        this.assertResultsContain("CRU-715/CardNumberFormatter.java", "1.3", keys);
        this.assertResultsContain("CRU-715/CreditCardDisplayFormat.java", "1.5", keys);
        this.assertResultsContain("CRU-715/changelog.txt", "1.1", keys);
        this.assertResultsContain("CRU-715/spec.txt", "1.1", keys);
    }

    private void assertResultsContain(String path, String rev, List results) throws Exception {
        Assert.assertTrue((boolean)results.contains(new RevInfoKey(new Path((CharSequence)path), rev)));
    }

    private SearchResults doQuery(String ql) throws Exception {
        return RepSanity1Test.doQuery(ql, this.engine);
    }
}

