/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.reptest;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.RepSanityTestBase;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.search.SearchResults;
import junit.framework.Assert;
import org.junit.Test;

public final class CRU1060CvsTest
extends RepSanityTestBase {
    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.getSanity1Repos();
    }

    @Test
    public void testBeforeAfterAndTagging() throws Exception {
        FileRevision r1_5 = this.getRevision("1.5");
        FileRevision r1_3 = this.getRevision("1.3");
        FileRevision r1_3_16_1 = this.getRevision("1.3.16.1");
        FileRevision r1_1 = this.getRevision("1.1");
        FileRevision r1_1_2_3 = this.getRevision("1.1.2.3");
        this.assertBefore(r1_1, r1_5, true);
        this.assertBefore(r1_1, r1_3, true);
        this.assertBefore(r1_1, r1_1, false);
        this.assertBefore(r1_5, r1_1, false);
        this.assertBefore(r1_3, r1_1, false);
        this.assertAfter(r1_5, r1_1, true);
        this.assertAfter(r1_5, r1_3, true);
        this.assertAfter(r1_5, r1_5, false);
        this.assertAfter(r1_1, r1_5, false);
        this.assertAfter(r1_3, r1_5, false);
        this.assertBefore(r1_1, r1_3_16_1, true);
        this.assertAfter(r1_3_16_1, r1_3, true);
        this.assertBefore(r1_1, r1_1_2_3, true);
        this.assertAfter(r1_1_2_3, r1_1, true);
        this.assertBefore(r1_3, r1_3_16_1, true);
        this.assertAfter(r1_3_16_1, r1_3, true);
        this.assertBefore(r1_3_16_1, r1_1_2_3, false);
        this.assertBefore(r1_1_2_3, r1_3_16_1, false);
        this.assertAfter(r1_3_16_1, r1_1_2_3, false);
        this.assertAfter(r1_1_2_3, r1_3_16_1, false);
        this.assertQueryContains(new String[]{"1.1", "1.1.2.1", "1.1.2.2"}, "tagged < merge_point_VOUCHERS_TO_MAIN");
        this.assertQueryContains(new String[]{"1.1", "1.1.2.1", "1.1.2.2", "1.1.2.3"}, "tagged <= merge_point_VOUCHERS_TO_MAIN");
        this.assertQueryContains(new String[]{"1.1", "1.2", "1.3", "1.4"}, "tagged < build-MAIN-637");
        this.assertQueryContains(new String[]{"1.2", "1.3", "1.4", "1.5", "1.1.2.1", "1.1.2.2", "1.1.2.3", "1.3.16.1"}, "tagged > VOUCHER_REFUNDS$BP");
    }

    private void assertQueryContains(String[] expectedRevs, String where) throws Exception {
        SearchResults searchResults = this.doQuery("select revisions where path like CreditCardDisplayFormat.java and " + where);
        this.assertResultsSize(expectedRevs.length, searchResults);
        for (String expectedRev : expectedRevs) {
            this.assertResultsContain("CRU-715/CreditCardDisplayFormat.java", expectedRev, searchResults);
        }
    }

    private void assertBefore(FileRevision a, FileRevision b, boolean expected) throws Exception {
        RevisionCache cache = this.engine.getRevisionCache();
        Assert.assertEquals((boolean)expected, (boolean)cache.isBefore(a.getRevID(), b.getRevID()));
    }

    private void assertAfter(FileRevision a, FileRevision b, boolean expected) throws Exception {
        RevisionCache cache = this.engine.getRevisionCache();
        Assert.assertEquals((boolean)expected, (boolean)cache.isAfter(a.getRevID(), b.getRevID()));
    }

    private FileRevision getRevision(String rev) throws DbException {
        RevisionCache cache = this.engine.getRevisionCache();
        FileRevision ri = cache.getFileRevision(new RevInfoKey(new Path((CharSequence)"CRU-715/CreditCardDisplayFormat.java"), rev));
        Assert.assertNotNull((Object)ri);
        return ri;
    }
}

