/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.rep;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fisheye.event.FisheyeEventPublisher;
import com.atlassian.fisheye.event.RepositoryStartingEvent;
import com.atlassian.fisheye.event.RepositoryStartingEventImpl;
import com.atlassian.fisheye.pipeline.ChangeSetPipeline;
import com.atlassian.fisheye.pipeline.DefaultChangeSetPipeline;
import com.atlassian.fisheye.pipeline.PipelinePhase;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.impl.DummyTxTemplate;
import com.cenqua.crucible.util.DummyEventPublisher;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.DiffTestUtils;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.RepositoryModificationTracker;
import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.LegacyRepositoryManagerRootConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepositoryDefaultsType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.crossrepo.BranchIndexer;
import com.cenqua.fisheye.crossrepo.PathIndexer;
import com.cenqua.fisheye.crossrepo.PathIndexerCache;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.CommitEventGenerator;
import com.cenqua.fisheye.rep.CommitNotificationDAO;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DummyCommitNotificationDAO;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.search.SearchManager;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.xmlbeans.XmlException;
import org.mockito.Matchers;
import org.mockito.Mockito;

public abstract class BaseTestHarness<E extends RepositoryEngine> {
    private final Appender errorCatcher;
    private String repoName;
    private File repoDir = null;
    private File appDir = null;
    private IndexingContext indexingContext;
    private String subPath;
    private AllowType allow;
    private boolean storeDiffs;
    private String username;
    private String password;
    private long blockSize;
    protected final RootConfig rootConfig;
    private List<LoggingEvent> slurpErrors = new ArrayList<LoggingEvent>();
    protected E engine;
    private EventPublisher eventPublisher = new FisheyeEventPublisher();
    private int numSlurps = 2;
    private DefaultChangeSetPipeline pipeline;
    private boolean flagWarnings = false;
    protected RepositoryManager repositoryManager;
    private boolean ignoreSlurpErrors = false;
    private long pipelineCompletionWaitTime = 120000L;

    protected BaseTestHarness() {
        this.rootConfig = BaseTestHarness.createMockRootConfig();
        this.errorCatcher = new AppenderSkeleton(){

            protected void append(LoggingEvent event) {
                if (event.getLevel() == Level.ERROR || event.getLevel() == Level.WARN && BaseTestHarness.this.flagWarnings) {
                    BaseTestHarness.this.slurpErrors.add(event);
                }
            }

            public void close() {
            }

            public boolean requiresLayout() {
                return false;
            }
        };
    }

    public static RootConfig createMockRootConfig() {
        RootConfig rootConfig = (RootConfig)Mockito.mock(RootConfig.class);
        ConfigDocument.Config config = ConfigDocument.Config.Factory.newInstance();
        Mockito.when((Object)rootConfig.getConfig()).thenReturn((Object)config);
        RepositoryDefaultsType defaults = BaseTestHarness.createRepoDefaults();
        config.setRepositoryDefaults(defaults);
        return rootConfig;
    }

    public RootConfig getRootConfig() {
        return this.rootConfig;
    }

    public void slurpDump(File dumpLocation) throws IOException, DbException, RepositoryClientException, ConfigException, XmlException {
        this.initialiseDumpDirs(dumpLocation);
        Logs.APP_LOG.info((Object)("Creating repo at " + this.repoDir.getAbsolutePath() + " for " + dumpLocation.getAbsolutePath()));
        this.restoreDump(dumpLocation, this.repoDir);
        this.createEngineAndSlurp();
    }

    public void createAndStartEngine() throws IOException, DbException, RepositoryClientException, ConfigException, XmlException {
        this.initEnvironment();
        this.startRepo();
        this.engine = this.createEngine();
        RepositoryHandle handle = this.createMockRepoHandle();
        this.repositoryManager = (RepositoryManager)Mockito.mock(RepositoryManager.class);
        Mockito.when((Object)this.repositoryManager.getRepository(this.engine.getName())).thenReturn((Object)handle);
        if (this.pipeline != null) {
            this.registerChangesetProcessors((ChangeSetPipeline)this.pipeline, handle);
            this.pipeline.startup(this.repositoryManager);
            this.pipeline.onRepositoryStarting((RepositoryStartingEvent)new RepositoryStartingEventImpl(this.engine.getName(), false));
        }
        this.beforeEngineStarted();
        this.engine.start();
        this.afterEngineStarted();
    }

    protected RepositoryHandle createMockRepoHandle() {
        try {
            RepositoryHandle handle = (RepositoryHandle)Mockito.mock(RepositoryHandle.class);
            Mockito.when((Object)handle.isRunning()).thenReturn((Object)true);
            Mockito.when((Object)handle.getName()).thenReturn((Object)this.engine.getName());
            Mockito.when((Object)handle.getStatus()).thenReturn((Object)this.engine.getStatus());
            Mockito.when((Object)handle.acquireEngine()).thenReturn(this.engine);
            Mockito.when((Object)handle.getCfg()).thenReturn((Object)this.engine.getCfg());
            Mockito.when((Object)handle.withEngine((Function)Matchers.any(Function.class))).thenAnswer(invocation -> {
                Function f = (Function)invocation.getArguments()[0];
                return f.apply(this.engine);
            });
            return handle;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create handle mock");
        }
    }

    public void createEngineAndSlurp() throws IOException, DbException, RepositoryClientException, ConfigException, XmlException {
        this.slurpErrors.clear();
        this.createAndStartEngine();
        this.slurpWithPipeline();
    }

    private void slurpWithPipeline() throws ConfigException, RepositoryClientException {
        Logs.APP_LOG.addAppender(this.errorCatcher);
        this.doSlurp();
        if (this.pipeline != null) {
            this.awaitPipelineCompletion();
            Logs.APP_LOG.removeAppender(this.errorCatcher);
        } else {
            Logs.APP_LOG.removeAppender(this.errorCatcher);
        }
        if (!this.ignoreSlurpErrors) {
            this.checkSlurpProblems();
        }
    }

    public long getPipelineCompletionWaitTime() {
        return this.pipelineCompletionWaitTime;
    }

    public void setPipelineCompletionWaitTime(long pipelineCompletionWaitTime) {
        this.pipelineCompletionWaitTime = pipelineCompletionWaitTime;
    }

    private void awaitPipelineCompletion() throws ConfigException, RepositoryClientException {
        boolean done;
        if (this.pipelineCompletionWaitTime == 0L) {
            return;
        }
        long start = System.currentTimeMillis();
        long count = this.getPipelineCompletionWaitTime() / 100L;
        do {
            ConcurrentMap stateCounts = this.engine.getStatus().getIndexingStateCounts();
            done = true;
            for (ChangeSetIndexingState changeSetIndexingState : ChangeSetIndexingState.values()) {
                if (changeSetIndexingState == ChangeSetIndexingState.CONTENT_INDEXED || changeSetIndexingState == ChangeSetIndexingState.COMPLETE || ((AtomicInteger)stateCounts.get(changeSetIndexingState)).intValue() <= 0) continue;
                done = false;
                break;
            }
            if (done) continue;
            try {
                --count;
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!done && count > 0L);
        this.doSlurp();
        if (!done) {
            Map depths = this.pipeline.getQueueDepths();
            Logs.APP_LOG.info((Object)"Queue depths:");
            for (ChangeSetIndexingState changeSetIndexingState : PipelinePhase.values()) {
                Logs.APP_LOG.info((Object)(changeSetIndexingState + " : " + depths.get(changeSetIndexingState)));
            }
            this.pipeline.dumpPipelineState();
            throw new RuntimeException("Pipeline did not empty in time. Waited " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    public void setFlagWarnings(boolean flagWarnings) {
        this.flagWarnings = flagWarnings;
    }

    private void initEnvironment() throws DbException, IOException {
        TestFishEyeInstances.stop();
        this.appDir = FisheyeTestUtil.createTempDir("app-" + this.getRepoName() + "-");
        AppConfig.overrideAppHome((File)new File(FisheyeTestEnv.WORKSPACE_DIR, "output/dist"), (File)this.appDir);
        CrossRepLuceneIndex crossRepLuceneIndex = new CrossRepLuceneIndex(new File(this.appDir, "cache"));
        this.pipeline = this.createChangeSetPipeline();
        this.indexingContext = new IndexingContext(crossRepLuceneIndex, (ChangeSetPipeline)this.pipeline, this.getEventPublisher(), false, (RepositoryModificationTracker)Mockito.mock(RepositoryModificationTracker.class), new PathIndexer(crossRepLuceneIndex, new PathIndexerCache((EventPublisher)new DummyEventPublisher())), new BranchIndexer(crossRepLuceneIndex));
    }

    protected DefaultChangeSetPipeline createChangeSetPipeline() {
        return null;
    }

    protected EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    protected void registerChangesetProcessors(ChangeSetPipeline pipeline, RepositoryHandle handle) {
    }

    private void doSlurp() throws DbException, ConfigException, RepositoryClientException {
        for (int i = 0; i < this.getNumSlurps(); ++i) {
            this.engine.slurp();
        }
    }

    private void checkSlurpProblems() throws RepositoryClientException {
        if (!this.slurpErrors.isEmpty()) {
            String firstErrorEvent = this.slurpErrors.get(0).getRenderedMessage();
            ThrowableInformation cause = this.slurpErrors.get(0).getThrowableInformation();
            throw new RuntimeException("Slurp Errors - first error: " + firstErrorEvent, cause == null ? null : cause.getThrowable());
        }
        if (this.engine.getStatus().getMessage().length() != 0) {
            throw new RepositoryClientException("Problem with slurp - " + this.engine.getStatus().getMessage());
        }
        if (this.engine.getStatus().getEngineError().length() != 0) {
            throw new RepositoryClientException("Problem with slurp - " + this.engine.getStatus().getEngineError());
        }
    }

    public File getAppDir() {
        return this.appDir;
    }

    protected int getNumSlurps() {
        return this.numSlurps;
    }

    public void setNumSlurps(int numSlurps) {
        this.numSlurps = numSlurps;
    }

    public void doIncSlurp(File incrementedDump) throws IOException, ConfigException, DbException, RepositoryClientException, XmlException {
        IOHelper.recursiveDelete((File)this.repoDir, (int)Integer.MAX_VALUE);
        this.repoDir.mkdir();
        Logs.APP_LOG.addAppender(this.errorCatcher);
        this.restoreDump(incrementedDump, this.repoDir);
        this.slurpWithPipeline();
        Logs.APP_LOG.removeAppender(this.errorCatcher);
        if (!this.ignoreSlurpErrors) {
            this.checkSlurpProblems();
        }
    }

    protected void beforeEngineStarted() {
    }

    protected void afterEngineStarted() throws DbException {
    }

    protected void restoreDump(File dumpLocation, File repoLocation) throws IOException, RepositoryClientException {
        IOHelper.unzip((File)dumpLocation, (File)repoLocation);
    }

    private void setRepoNameFromDump(File dumpLocation) {
        String name = dumpLocation.getName();
        int index = name.indexOf(46);
        if (index != -1) {
            name = name.substring(0, index);
        }
        this.setRepoName(name);
    }

    public String getRepoName() {
        return this.repoName;
    }

    private void initialiseDumpDirs(File dumpLocation) throws IOException, DbException {
        this.setRepoNameFromDump(dumpLocation);
        this.createRepoDir();
    }

    public void createRepoDir() throws IOException {
        this.repoDir = FisheyeTestUtil.createTempDir("repo-" + this.getRepoName() + "-");
    }

    public void cleanUp() throws DbException {
        if (this.pipeline != null && this.pipeline.isStarted()) {
            this.pipeline.shutdown();
        }
        if (this.engine != null) {
            this.engine.forceClose();
        }
        this.stopRepo();
        if (this.indexingContext != null && this.indexingContext.getCrossRepLuceneIndex() != null) {
            this.indexingContext.getCrossRepLuceneIndex().close();
        }
        if (this.repoDir != null) {
            BaseTestHarness.tryDelete(this.repoDir);
        }
        if (this.appDir != null) {
            BaseTestHarness.tryDelete(this.appDir);
        }
    }

    protected void startRepo() throws RepositoryClientException, ConfigException {
    }

    protected void stopRepo() {
    }

    protected abstract E createEngine() throws XmlException, IOException, ConfigException, DbException;

    public void assertNoSlurpErrors(String reference) throws DbException {
        String message;
        RepositoryStatus statusReporter = this.engine.getStatus();
        if (statusReporter.getEngineHasError()) {
            message = statusReporter.getEngineError();
            Assert.fail((String)("Slurp of " + reference + " failed with " + message));
        }
        if (statusReporter.isMessageAvailable()) {
            message = statusReporter.getMessage().trim();
            Assert.fail((String)("Slurp of " + reference + " failed with " + message));
        }
        DiffTestUtils.checkDiffs(this.engine.getPathMatcher(), this.engine.getRevisionCache());
    }

    public SearchResults evaluateQuery(String query) throws Exception {
        FishQuery q = FisheyeTestUtil.parseQuery(query);
        SearchManager manager = this.engine.getSearchManager();
        return manager.runQuery(q, true);
    }

    public static RepositoryDefaultsType createRepoDefaults() {
        RepositoryDefaultsType defaults = RepositoryDefaultsType.Factory.newInstance();
        defaults.addNewLinker();
        defaults.addNewAllow();
        defaults.addNewTextIndexer();
        return defaults;
    }

    private static void tryDelete(File dir) {
        FisheyeTestUtil.deleteDir(dir);
        if (!dir.exists()) {
            return;
        }
        System.out.println("PROBLEM DELETING ALL FILES, sleeping: " + dir);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        FisheyeTestUtil.deleteDir(dir);
        if (!dir.exists()) {
            return;
        }
        System.out.println("PROBLEM DELETING ALL FILES, AGAIN: " + dir);
        FisheyeTestUtil.listDir(System.out, dir);
    }

    public File getRepoDir() {
        return this.repoDir;
    }

    public IndexingContext getIndexingContext() {
        return this.indexingContext;
    }

    public String getSubPath() {
        return this.subPath;
    }

    public void setSubPath(String subPath) {
        this.subPath = subPath;
    }

    public AllowType getAllow() {
        return this.allow;
    }

    public void setAllow(AllowType allow) {
        this.allow = allow;
    }

    public boolean isStoreDiffs() {
        return this.storeDiffs;
    }

    public void setStoreDiffs(boolean storeDiffs) {
        this.storeDiffs = storeDiffs;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public E getEngine() {
        return this.engine;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    protected RepositoryType createRepoDefinition() {
        RepositoryType repoDefinition = RepositoryType.Factory.newInstance();
        repoDefinition.setName(this.getRepoName());
        repoDefinition.setDescription("Test Repo - " + this.getRepoName());
        repoDefinition.setEnabled(true);
        if (this.getAllow() != null) {
            repoDefinition.setAllow(this.getAllow());
        }
        repoDefinition.addNewTextIndexer().setEnabled(true);
        return repoDefinition;
    }

    public abstract BaseRevisionCache<?, ?, ?> getCache();

    public void registerCommitEventGenerator() {
        CommitEventGenerator eventGenerator = new CommitEventGenerator((TxTemplate)new DummyTxTemplate(), (CommitNotificationDAO)new DummyCommitNotificationDAO(), this.engine.getCrossRepLuceneIndex(), this.repositoryManager, this.eventPublisher, (Executor)MoreExecutors.sameThreadExecutor());
        this.eventPublisher.register((Object)eventGenerator);
    }

    public void setIgnoreSlurpErrors(boolean ignoreSlurpErrors) {
        this.ignoreSlurpErrors = ignoreSlurpErrors;
    }

    static {
        LegacyRepositoryManagerRootConfig.resetConfig();
    }

    protected static abstract class BaseBuilder<B extends BaseBuilder, H extends BaseTestHarness> {
        private String subPath;
        private AllowType allow;
        private boolean storeDiffs;
        private String username;
        private String password;
        private long blockSize;
        private File dumpFile;

        protected BaseBuilder() {
        }

        public B setSubPath(String subPath) {
            this.subPath = subPath;
            return this.builder();
        }

        public B setAllow(AllowType allowType) {
            this.allow = allowType;
            return this.builder();
        }

        public B setStoreDiffs(boolean storeDiffs) {
            this.storeDiffs = storeDiffs;
            return this.builder();
        }

        public B setUsername(String username) {
            this.username = username;
            return this.builder();
        }

        public B setPassword(String password) {
            this.password = password;
            return this.builder();
        }

        public B setBlockSize(long blockSize) {
            this.blockSize = blockSize;
            return this.builder();
        }

        public B setDumpFile(File dumpFile) {
            this.dumpFile = dumpFile;
            return this.builder();
        }

        public final H build() throws ConfigException, RepositoryClientException, XmlException, IOException {
            Preconditions.checkState((this.dumpFile != null ? 1 : 0) != 0, (Object)"Can't perform slurp without repo dump file");
            H testHarness = this.createHarness();
            ((BaseTestHarness)testHarness).setSubPath(this.subPath);
            ((BaseTestHarness)testHarness).setAllow(this.allow);
            ((BaseTestHarness)testHarness).setStoreDiffs(this.storeDiffs);
            ((BaseTestHarness)testHarness).setUsername(this.username);
            ((BaseTestHarness)testHarness).setPassword(this.password);
            ((BaseTestHarness)testHarness).setBlockSize(this.blockSize);
            testHarness = this.configureTestHarness(testHarness);
            ((BaseTestHarness)testHarness).slurpDump(this.dumpFile);
            ((BaseTestHarness)testHarness).assertNoSlurpErrors(this.dumpFile.getAbsolutePath());
            return testHarness;
        }

        protected abstract H createHarness();

        protected abstract H configureTestHarness(H var1);

        protected B builder() {
            return (B)this;
        }
    }
}

