/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.quicksearch.action;

import com.atlassian.fecru.search.common.api.QuickSearchTimeBucket;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fisheye.quicksearch.action.HintParser;
import com.atlassian.fisheye.quicksearch.action.QuickSearchAction;
import com.atlassian.fisheye.quicksearch.action.SearchMessage;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.ping.CrossRepositoryRescanRequest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class QuickSearchActionTest {
    QuickSearchAction action;
    QuickSearchAction.IndexingStatus indexingStatus;

    @Before
    public void setUp() throws Exception {
        this.action = new QuickSearchAction();
    }

    @Test
    public void testNewSearchScope() {
        this.action.setPage(10);
        SearchScope scope = this.action.newSearchScopeBuilder(Collections.emptyList(), null, new HintParser((Iterable)SearchType.ALL_SEARCH_TYPES)).build();
        Assert.assertThat((Object)scope.from(), (Matcher)CoreMatchers.is((Object)90));
        this.action.setPage(-1);
        scope = this.action.newSearchScopeBuilder(Collections.emptyList(), null, new HintParser((Iterable)SearchType.ALL_SEARCH_TYPES)).build();
        Assert.assertThat((Object)scope.from(), (Matcher)CoreMatchers.is((Object)90));
        try {
            this.action.setPage(0xE38E38E);
            scope = this.action.newSearchScopeBuilder(Collections.emptyList(), null, new HintParser((Iterable)SearchType.ALL_SEARCH_TYPES)).build();
            throw new AssertionError((Object)"Did not detect integer overflow");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @Test
    public void testPrepareNotificationsSlurpingRepositories() throws Exception {
        this.action.setQ("some query");
        this.indexingStatus = new QuickSearchAction.IndexingStatus(false, false, false);
        ImmutableList repositories = ImmutableList.of((Object)this.mockRepoHandle("repo_InitialIndexComplete_NoCrossRepoUpgrade", true, false), (Object)this.mockRepoHandle("repo_InitialIndexComplete_CrossRepoUpgrade", true, true), (Object)this.mockRepoHandle("repo_InitialIndexUnComplete_NoCrossRepoUpgrade", false, false), (Object)this.mockRepoHandle("repo_InitialIndexUnComplete_CrossRepoUpgrade", false, true));
        this.action.prepareNotifications((Iterable)repositories, this.indexingStatus);
        List messages = this.action.getMessages();
        String subText = ((SearchMessage)messages.get(0)).getSubText();
        Assert.assertEquals((String)"expected only one message", (long)1L, (long)messages.size());
        Assert.assertNotNull((String)"message should contains list of affected repositories", (Object)subText);
        ArrayList<String> expectedRepositories = new ArrayList<String>();
        expectedRepositories.add("repo_InitialIndexComplete_CrossRepoUpgrade");
        expectedRepositories.add("repo_InitialIndexUnComplete_NoCrossRepoUpgrade");
        expectedRepositories.add("repo_InitialIndexUnComplete_CrossRepoUpgrade");
        ArrayList actual = new ArrayList();
        Collections.addAll(actual, subText.split(", "));
        Assert.assertThat((String)"expected the following repositories in message", actual, (Matcher)CoreMatchers.is(expectedRepositories));
        Assert.assertThat((Object)subText, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)"...")));
    }

    @Test
    public void testPrepareNotificationsWarningMessage() {
        this.indexingStatus = new QuickSearchAction.IndexingStatus(true, true, true);
        RepositoryHandle exampleRepo = this.mockRepoHandle("ExampleRepo", true, false);
        ImmutableList repositories = ImmutableList.of((Object)exampleRepo);
        this.action.setRepository(exampleRepo.getName());
        this.action.prepareNotifications((Iterable)repositories, this.indexingStatus);
        SearchMessage expectedMessage = new SearchMessage("Results might be incomplete", "Repository 'ExampleRepo' is still being indexed. Some of the results might not be available yet.", null, SearchMessage.MessageStatus.WARNING, false);
        List messages = this.action.getMessages();
        Assert.assertEquals((String)"expected only one message", (long)1L, (long)messages.size());
        Assert.assertThat((String)"expected warning message", messages.get(0), (Matcher)CoreMatchers.is((Object)expectedMessage));
    }

    @Test
    public void testPrepareNotificationsHintMessage() {
        this.indexingStatus = new QuickSearchAction.IndexingStatus(true, true, false);
        RepositoryHandle exampleRepo = this.mockRepoHandle("ExampleRepo", true, false);
        ImmutableList repositories = ImmutableList.of((Object)exampleRepo);
        this.action.setRepository(exampleRepo.getName());
        this.action.prepareNotifications((Iterable)repositories, this.indexingStatus);
        SearchMessage expectedMessage = new SearchMessage("Results might be incomplete", "Scanning of repository 'ExampleRepo' is complete, comprehensive indexing is in progress. Some details might be available later.", null, SearchMessage.MessageStatus.INFO, false);
        List messages = this.action.getMessages();
        Assert.assertEquals((String)"expected only one message", (long)1L, (long)messages.size());
        Assert.assertThat((String)"expected warning message", messages.get(0), (Matcher)CoreMatchers.is((Object)expectedMessage));
    }

    @Test
    public void testPrepareNotificationsLimitsRepos() throws Exception {
        this.action.setQ("query");
        this.indexingStatus = new QuickSearchAction.IndexingStatus(false, false, false);
        Iterable repositories = Iterables.limit((Iterable)Iterables.cycle((Object[])new RepositoryHandle[]{this.mockRepoHandle("IndexingRepo", false, false)}), (int)100);
        this.action.prepareNotifications(repositories, this.indexingStatus);
        List messages = this.action.getMessages();
        String subText = ((SearchMessage)messages.get(0)).getSubText();
        Assert.assertThat((Object)messages.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)StringUtils.countMatches((String)subText, (String)"IndexingRepo"), (Matcher)Matchers.equalTo((Object)10));
        Assert.assertThat((Object)subText, (Matcher)Matchers.endsWith((String)"..."));
    }

    @Test
    public void testUnavailableFilterForCommitters() throws Exception {
        this.action.setQ("query");
        this.action.setT(String.valueOf(SearchType.COMMITTERS.ordinal()));
        this.action.setBucket(QuickSearchTimeBucket.LAST_MONTH.name());
        this.action.setUserFilter("joe");
        this.action.prepareNotifications(Collections.emptyList(), new QuickSearchAction.IndexingStatus(false, false, false));
        List messages = this.action.getMessages();
        Assert.assertThat((Object)messages, (Matcher)Matchers.hasItem((Object)new SearchMessage("The user and last modified filters are not available for committer search. Showing all results")));
    }

    @Test
    public void testSingleFilterUnavailableForCommitters() throws Exception {
        this.action.setQ("query");
        this.action.setT(String.valueOf(SearchType.COMMITTERS.ordinal()));
        this.action.setBucket(QuickSearchTimeBucket.LAST_MONTH.name());
        this.action.prepareNotifications(Collections.emptyList(), new QuickSearchAction.IndexingStatus(false, false, false));
        List messages = this.action.getMessages();
        Assert.assertThat((Object)messages, (Matcher)Matchers.hasItem((Object)new SearchMessage("The last modified filter is not available for committer search. Showing all results")));
    }

    @Test
    public void testSingleFilterUnavailableForPaths() throws Exception {
        this.action.setQ("query");
        this.action.setT(String.valueOf(SearchType.FILE_PATHS.ordinal()));
        this.action.setUserFilter("joe");
        this.action.prepareNotifications(Collections.emptyList(), new QuickSearchAction.IndexingStatus(false, false, false));
        List messages = this.action.getMessages();
        Assert.assertThat((Object)messages, (Matcher)Matchers.hasItem((Object)new SearchMessage("The user filter is not available for file or directory search. Showing all results")));
    }

    @Test
    public void testHandleTooManyFileException() {
        Assert.assertThat((Object)this.action.getMessages(), (Matcher)Matchers.hasSize((int)0));
        this.action.handleTooManyFileException();
        Assert.assertThat((Object)this.action.getMessages(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void shouldReturnErrorJsonOnJsonRequest() throws Exception {
        this.action.setResultsOnly(true);
        this.action.setQ("query");
        String result = this.action.execute();
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)"error-json"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldPropagateExceptionOnHtmlRequest() throws Exception {
        this.action.setQ("query");
        this.action.execute();
    }

    private RepositoryHandle mockRepoHandle(String name, boolean isInitialIndexingComplete, boolean crossRepoUpgradeOngoing) {
        RepositoryHandle handleMock = (RepositoryHandle)Mockito.mock(RepositoryHandle.class);
        RepositoryStatus statusMock = (RepositoryStatus)Mockito.mock(RepositoryStatus.class);
        Mockito.when((Object)handleMock.getStatus()).thenReturn((Object)statusMock);
        Mockito.when((Object)handleMock.getName()).thenReturn((Object)name);
        Mockito.when((Object)statusMock.isInitialIndexingComplete()).thenReturn((Object)isInitialIndexingComplete);
        if (crossRepoUpgradeOngoing) {
            new CrossRepositoryRescanRequest(handleMock, false);
        }
        return handleMock;
    }
}

