/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.quicksearch.action;

import com.atlassian.fecru.search.common.api.QuickSearcher;
import com.atlassian.fecru.search.common.api.SearchType;
import com.atlassian.fisheye.quicksearch.action.HintParser;
import java.util.Collections;
import junit.framework.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class HintParserTest {
    private final Iterable<SearchType> searchTypes = SearchType.ALL_SEARCH_TYPES;
    private final HintParser allParser = new HintParser(this.searchTypes);

    @Test
    public void testParseHint() throws Exception {
        HintParser hintParser = new HintParser(this.searchTypes);
        for (SearchType searchType : this.searchTypes) {
            String hint = searchType.getHint();
            if (hint == null) continue;
            hintParser.parse(hint + ": myquery");
            Assert.assertEquals((String)"myquery", (String)hintParser.getQuery());
            Assert.assertEquals((Object)searchType, (Object)hintParser.getHintType());
            hintParser.parse(hint + ": m");
            Assert.assertEquals((String)"m", (String)hintParser.getQuery());
            Assert.assertEquals((Object)searchType, (Object)hintParser.getHintType());
        }
    }

    @Test
    public void testParseNoHint() throws Exception {
        HintParser hintParser = new HintParser(this.searchTypes);
        String userQuery = "query with no hint";
        hintParser.parse(userQuery);
        Assert.assertEquals((String)userQuery, (String)hintParser.getQuery());
        Assert.assertNull((Object)hintParser.getHintType());
        userQuery = "query: with no hint";
        hintParser.parse(userQuery);
        Assert.assertEquals((String)userQuery, (String)hintParser.getQuery());
        Assert.assertNull((Object)hintParser.getHintType());
    }

    @Test
    public void testParseInvalidHint() throws Exception {
        String userQuery;
        HintParser hintParser = new HintParser(this.searchTypes);
        for (SearchType searchType : this.searchTypes) {
            userQuery = searchType.getHint() + ":";
            hintParser.parse(userQuery);
            Assert.assertEquals((String)userQuery, (String)hintParser.getQuery());
            Assert.assertNull((Object)hintParser.getHintType());
        }
        for (SearchType searchType : this.searchTypes) {
            userQuery = searchType.getHint() + ":     ";
            hintParser.parse(userQuery);
            Assert.assertEquals((String)userQuery, (String)hintParser.getQuery());
            Assert.assertNull((Object)hintParser.getHintType());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseHintWithNoAvailableSearchers() throws Exception {
        new HintParser(Collections.emptyList());
        Assert.fail((String)"should not accept no empty searchers");
    }

    @Test
    public void testParseHintWithSearchers() throws Exception {
        SearchType type = SearchType.CHANGESET_COMMENTS;
        QuickSearcher quickSearcher = (QuickSearcher)Mockito.mock(QuickSearcher.class);
        Mockito.when((Object)quickSearcher.getType()).thenReturn((Object)type);
        HintParser hintParser = new HintParser(Collections.singleton(type));
        String userQuery = "query with no hint";
        hintParser.parse(userQuery);
        Assert.assertEquals((String)userQuery, (String)hintParser.getQuery());
        Assert.assertNull((Object)hintParser.getHintType());
        userQuery = type.getHint() + ": with a hint";
        hintParser.parse(userQuery);
        Assert.assertEquals((String)"with a hint", (String)hintParser.getQuery());
        Assert.assertEquals((Object)type, (Object)hintParser.getHintType());
        String wrongTypeQuery = SearchType.CONTENT.getHint() + ": with wrong hint";
        hintParser.parse(wrongTypeQuery);
        Assert.assertEquals((String)wrongTypeQuery, (String)hintParser.getQuery());
        Assert.assertNull((Object)hintParser.getHintType());
    }
}

