/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.quicksearch.action;

import com.atlassian.crucible.explorers.ChangeSetPair;
import com.atlassian.fecru.search.common.api.SearchScope;
import com.atlassian.fisheye.quicksearch.action.ChangesetIdInterceptor;
import com.atlassian.fisheye.web.NavBuilder;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.crossrepo.ChangesetSearcher;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Collections;

public class ChangesetIdInterceptorTest {
    private static final ChangeSetPair CS_12 = ChangeSetPair.newInstance((String)"rep1", (String)"12");
    private static final ChangeSetPair CS_123 = ChangeSetPair.newInstance((String)"rep1", (String)"123");
    private static final ChangeSetPair CS_124 = ChangeSetPair.newInstance((String)"rep1", (String)"124");
    private ChangesetSearcher searcher = (ChangesetSearcher)Mockito.mock(ChangesetSearcher.class);
    private ChangesetIdInterceptor interceptor = new ChangesetIdInterceptor(this.searcher);

    @Test
    public void testGetRedirectPath_singleResult() throws Exception {
        Mockito.when((Object)this.searcher.getChangesetsForQuery((ChangesetQueryBuilder)org.mockito.Matchers.any(ChangesetQueryBuilder.class), org.mockito.Matchers.eq((int)2))).thenReturn((Object)ImmutableList.of((Object)CS_123));
        SearchScope scope = SearchScope.builder().withRepositories(new RepositoryHandle[]{FisheyeTestUtil.mockRepoHandle("foo")}).build();
        String redirectPath = this.interceptor.getRedirectPath("123", scope);
        Assert.assertThat((Object)redirectPath, (Matcher)IsEqual.equalTo((Object)this.changesetUrl(CS_123)));
    }

    @Test
    public void testGetRedirectPath_twoResultsOneExactMatch() throws Exception {
        Mockito.when((Object)this.searcher.getChangesetsForQuery((ChangesetQueryBuilder)org.mockito.Matchers.any(ChangesetQueryBuilder.class), org.mockito.Matchers.eq((int)2))).thenReturn((Object)ImmutableList.of((Object)CS_12, (Object)CS_123));
        SearchScope scope = SearchScope.builder().withRepositories(new RepositoryHandle[]{FisheyeTestUtil.mockRepoHandle("foo")}).build();
        String redirectPath = this.interceptor.getRedirectPath("12", scope);
        Assert.assertThat((Object)redirectPath, (Matcher)IsEqual.equalTo((Object)this.changesetUrl(CS_12)));
    }

    @Test
    public void testGetRedirectPath_twoResultsNoExactMatch() throws Exception {
        Mockito.when((Object)this.searcher.getChangesetsForQuery((ChangesetQueryBuilder)org.mockito.Matchers.any(ChangesetQueryBuilder.class), org.mockito.Matchers.eq((int)2))).thenReturn((Object)ImmutableList.of((Object)CS_124, (Object)CS_123));
        SearchScope scope = SearchScope.builder().withRepositories(new RepositoryHandle[]{FisheyeTestUtil.mockRepoHandle("foo")}).build();
        String redirectPath = this.interceptor.getRedirectPath("12", scope);
        Assert.assertThat((Object)redirectPath, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testGetRedirectPath_twoResultsBothExactMatches() throws Exception {
        Mockito.when((Object)this.searcher.getChangesetsForQuery((ChangesetQueryBuilder)org.mockito.Matchers.any(ChangesetQueryBuilder.class), org.mockito.Matchers.eq((int)2))).thenReturn((Object)ImmutableList.of((Object)CS_12, (Object)CS_12));
        SearchScope scope = SearchScope.builder().build();
        String redirectPath = this.interceptor.getRedirectPath("12", scope);
        Assert.assertThat((Object)redirectPath, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testGetRedirectPath_oneResultsNoExactMatch_svn() throws Exception {
        Mockito.when((Object)this.searcher.getChangesetsForQuery((ChangesetQueryBuilder)org.mockito.Matchers.any(ChangesetQueryBuilder.class), org.mockito.Matchers.eq((int)2))).thenReturn((Object)ImmutableList.of((Object)CS_124));
        SearchScope scope = SearchScope.builder().withRepositories(new RepositoryHandle[]{FisheyeTestUtil.mockRepoHandle("rep1", ScmType.SVN)}).build();
        String redirectPath = this.interceptor.getRedirectPath("12", scope);
        Assert.assertThat((Object)redirectPath, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testGetRedirectPath_filtersByRepo() throws Exception {
        String csid = "12";
        Mockito.when((Object)this.searcher.getChangesetsForQuery((ChangesetQueryBuilder)org.mockito.Matchers.any(ChangesetQueryBuilder.class), org.mockito.Matchers.anyInt())).thenAnswer(invocation -> {
            ChangesetQueryBuilder query = (ChangesetQueryBuilder)invocation.getArguments()[0];
            Assert.assertThat((Object)query.build(), (Matcher)Matchers.equalTo((Object)((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().fromTheseRepos((Collection)ImmutableSet.of((Object)"rep2", (Object)"rep3"))).withChangeSetId("12").build()));
            return Collections.emptyList();
        });
        String redirectPath = this.interceptor.getRedirectPath("12", SearchScope.builder().withRepositories(new RepositoryHandle[]{FisheyeTestUtil.mockRepoHandle("rep2"), FisheyeTestUtil.mockRepoHandle("rep3")}).build());
    }

    @Test
    public void testGetRedirectPath_noMatches() throws Exception {
        Mockito.when((Object)this.searcher.getChangesetsForQuery((ChangesetQueryBuilder)org.mockito.Matchers.any(ChangesetQueryBuilder.class), org.mockito.Matchers.eq((int)2))).thenReturn((Object)ImmutableList.of());
        SearchScope scope = SearchScope.builder().withRepositories(new RepositoryHandle[]{FisheyeTestUtil.mockRepoHandle("foo")}).build();
        String redirectPath = this.interceptor.getRedirectPath("12", scope);
        Assert.assertThat((Object)redirectPath, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testGetRedirectPath_noRepoConstraints() throws Exception {
        SearchScope scope = SearchScope.builder().build();
        String redirectPath = this.interceptor.getRedirectPath("12", scope);
        Assert.assertThat((Object)redirectPath, (Matcher)Matchers.nullValue());
    }

    private String changesetUrl(ChangeSetPair cs) {
        return NavBuilder.changeset((String)cs.getRepository(), (String)cs.getCsid());
    }
}

