/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.quartz;

import com.atlassian.fisheye.quartz.DefaultQuartzManager;
import com.atlassian.fisheye.quartz.JobInfo;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdScheduler;

public final class DefaultQuartzManagerTest {
    private Scheduler scheduler;
    private File propertiesDir;
    private final String testJobClass = "com.atlassian.fisheye.quartz.TestJob";
    private DefaultQuartzManager quartzManager;

    @Test
    public void testStartNoProperties() throws Exception {
        this.quartzManager.start();
        assert (this.quartzManager.getAllJobs().size() == 0);
    }

    @Test
    public void testStartProperties() throws Exception {
        this.quartzManager.setDir(this.propertiesDir);
        this.quartzManager.start();
        JobInfo jobInfo = this.quartzManager.getJobInfo("test1", "test");
        junit.framework.Assert.assertNotNull((Object)jobInfo);
        junit.framework.Assert.assertEquals((String)"0/5 * * * * ?", (String)jobInfo.getCronExp());
    }

    @Test
    public void testScheduleUnscheduleJob() throws Exception {
        String cron = "0/2 * * * * ?";
        this.quartzManager.setDir(this.propertiesDir);
        this.quartzManager.start();
        this.quartzManager.registerJob("test2", "test", cron, "com.atlassian.fisheye.quartz.TestJob", false);
        JobInfo jobInfo = this.quartzManager.getJobInfo("test2", "test");
        junit.framework.Assert.assertNotNull((Object)jobInfo);
        junit.framework.Assert.assertEquals((String)cron, (String)jobInfo.getCronExp());
        this.quartzManager.unscheduleJob("test2", "test");
        jobInfo = this.quartzManager.getJobInfo("test2", "test");
        Assert.assertNull((Object)jobInfo);
    }

    @Before
    public void setUp() throws Exception {
        this.scheduler = new StdScheduler(null, null){
            private boolean started;
            private Map<JobDetail, Trigger> schedule;
            {
                this.started = false;
                this.schedule = new HashMap<JobDetail, Trigger>();
            }

            public void start() throws SchedulerException {
                this.started = true;
            }

            public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
                this.schedule.put(jobDetail, trigger);
                return null;
            }

            public boolean unscheduleJob(String name, String group) throws SchedulerException {
                Trigger trigger = this.getTrigger(name, group);
                JobDetail jobDetail = this.getJobDetail(trigger.getJobName(), trigger.getJobGroup());
                return jobDetail != null && this.schedule.remove(jobDetail) != null;
            }

            public JobDetail getJobDetail(String name, String group) throws SchedulerException {
                for (JobDetail jobDetail : this.schedule.keySet()) {
                    if (!jobDetail.getName().equals(name) || !jobDetail.getGroup().equals(group)) continue;
                    return jobDetail;
                }
                return null;
            }

            public Trigger getTrigger(String name, String group) throws SchedulerException {
                for (Trigger trigger : this.schedule.values()) {
                    if (!trigger.getName().equals(name) || !trigger.getGroup().equals(group)) continue;
                    return trigger;
                }
                return null;
            }

            public boolean isShutdown() {
                return !this.started;
            }
        };
        this.propertiesDir = FisheyeTestUtil.createTempDir("quartz");
        File orig = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/quartz/quartzcron.properties");
        IOHelper.copy((File)orig, (File)this.propertiesDir);
        this.scheduler.start();
        this.quartzManager = new DefaultQuartzManager();
        this.quartzManager.setQuartzScheduler(this.scheduler);
    }

    @After
    public void tearDown() {
        this.quartzManager = null;
    }
}

