/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.web.conditions;

import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.fisheye.plugin.web.conditions.UserLoggedInCondition;
import com.atlassian.fisheye.plugin.web.helpers.GlobalHelper;
import com.atlassian.fisheye.plugin.web.helpers.Helper;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class UserLoggedInConditionTest
extends TestCase {
    public void testNoGlobalHelperYieldsFalse() {
        Helper helper = (Helper)Mockito.mock(Helper.class);
        Mockito.when((Object)helper.getGlobal()).thenReturn(null);
        UserLoggedInConditionTest.assertFalse((boolean)new UserLoggedInCondition().shouldDisplay(helper));
    }

    public void testAnonymousUserYieldsFalse() {
        Helper helper = (Helper)Mockito.mock(Helper.class);
        GlobalHelper globalHelper = (GlobalHelper)Mockito.mock(GlobalHelper.class);
        Mockito.when((Object)helper.getGlobal()).thenReturn((Object)globalHelper);
        Mockito.when((Object)globalHelper.getUser()).thenReturn((Object)UserData.ANONYMOUS);
        UserLoggedInConditionTest.assertFalse((boolean)new UserLoggedInCondition().shouldDisplay(helper));
    }

    public void testSomeUserYieldsTrue() {
        Helper helper = (Helper)Mockito.mock(Helper.class);
        GlobalHelper globalHelper = (GlobalHelper)Mockito.mock(GlobalHelper.class);
        UserData userData = (UserData)Mockito.mock(UserData.class);
        Mockito.when((Object)helper.getGlobal()).thenReturn((Object)globalHelper);
        Mockito.when((Object)globalHelper.getUser()).thenReturn((Object)userData);
        Mockito.when((Object)userData.getUserName()).thenReturn((Object)"matt");
        UserLoggedInConditionTest.assertTrue((boolean)new UserLoggedInCondition().shouldDisplay(helper));
    }
}

