/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.web.conditions;

import com.atlassian.fisheye.plugin.web.conditions.HasPermissionToCreateReview;
import com.atlassian.fisheye.plugin.web.helpers.Helper;
import com.cenqua.fisheye.web.filters.GlobalJspContext;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class HasPermissionToCreateReviewTest {
    private HasPermissionToCreateReview condition;
    private Helper context;
    private HttpServletRequest request;
    private GlobalJspContext globalJspContext;

    @Before
    public void setUp() {
        this.condition = new HasPermissionToCreateReview();
        this.condition.init(new HashMap());
        this.context = (Helper)Mockito.mock(Helper.class);
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.globalJspContext = (GlobalJspContext)Mockito.mock(GlobalJspContext.class);
    }

    @Test
    public void testFailIfNoRequestInContext() {
        Mockito.when((Object)this.context.getRequest()).thenReturn(null);
        Assert.assertFalse((boolean)this.condition.shouldDisplay(this.context));
    }

    @Test
    public void testFailIfNoGlobalJspContextInRequestAttribute() {
        Mockito.when((Object)this.context.getRequest()).thenReturn((Object)this.request);
        Mockito.when((Object)this.request.getAttribute("global")).thenReturn(null);
        Assert.assertFalse((boolean)this.condition.shouldDisplay(this.context));
    }

    @Test
    public void testFailIfCurrentUserHasNoPermissionToCreateReview() {
        Mockito.when((Object)this.context.getRequest()).thenReturn((Object)this.request);
        Mockito.when((Object)this.request.getAttribute("global")).thenReturn((Object)this.globalJspContext);
        Mockito.when((Object)this.globalJspContext.isShowCreateReview()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.condition.shouldDisplay(this.context));
    }

    @Test
    public void testSuccessIfCurrentUserHasNoPermissionToCreateReview() {
        Mockito.when((Object)this.context.getRequest()).thenReturn((Object)this.request);
        Mockito.when((Object)this.request.getAttribute("global")).thenReturn((Object)this.globalJspContext);
        Mockito.when((Object)this.globalJspContext.isShowCreateReview()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.condition.shouldDisplay(this.context));
    }

    @Test
    public void testFailEvenIfGlobalAttributeDoesNotContainGlobalJspContext() {
        Mockito.when((Object)this.context.getRequest()).thenReturn((Object)this.request);
        Mockito.when((Object)this.request.getAttribute("global")).thenReturn(new HashMap());
        Assert.assertFalse((boolean)this.condition.shouldDisplay(this.context));
    }
}

