/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.servlet;

import com.atlassian.fisheye.plugin.servlet.FisheyeServletModuleContainerServlet;
import com.atlassian.fisheye.plugin.servlet.FisheyeServletModuleManager;
import com.atlassian.fisheye.plugin.web.RequiresXsrfCheck;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class FisheyeServletModuleContainerServletTest {
    public static final int XSRF_STATUS = 403;
    public static final String XSRF_ERROR_MESSAGE = "XSRF Error";
    public static final int OK_STATUS = 200;
    public static final String OK_ERROR_MESSAGE = "OK";

    @Test
    public void testXsrfNoAnnotationWithInvalidToken() throws Exception {
        this.checkServletResponse(new XsrfPostServlet(), "GET", false, 200, OK_ERROR_MESSAGE);
    }

    @Test
    public void testXsrfNoAnnotationWithValidToken() throws Exception {
        this.checkServletResponse(new XsrfPostServlet(), "GET", true, 200, OK_ERROR_MESSAGE);
    }

    @Test
    public void testXsrfDirectPostAnnotationWithInvalidToken() throws Exception {
        this.checkServletResponse(new XsrfPostServlet(), "POST", false, 403, XSRF_ERROR_MESSAGE);
    }

    @Test
    public void testXsrfDirectPostAnnotationWithValidToken() throws Exception {
        this.checkServletResponse(new XsrfPostServlet(), "POST", true, 200, OK_ERROR_MESSAGE);
    }

    @Test
    public void testXsrfSubclass1PostAnnotationWithInvalidToken() throws Exception {
        this.checkServletResponse(new XsrfPostSubclass1Servlet(), "POST", false, 403, XSRF_ERROR_MESSAGE);
    }

    @Test
    public void testXsrfSubclass1PostClassAnnotationWithValidToken() throws Exception {
        this.checkServletResponse(new XsrfPostSubclass1Servlet(), "POST", true, 200, OK_ERROR_MESSAGE);
    }

    @Test
    public void testXsrfSubclass2PostAnnotationWithInvalidToken() throws Exception {
        this.checkServletResponse(new XsrfPostSubclass2Servlet(), "POST", false, 403, XSRF_ERROR_MESSAGE);
    }

    @Test
    public void testXsrfSubclass2PostClassAnnotationWithValidToken() throws Exception {
        this.checkServletResponse(new XsrfPostSubclass2Servlet(), "POST", true, 200, OK_ERROR_MESSAGE);
    }

    @Test
    public void testXsrfDirectServiceAnnotationWithInvalidToken() throws Exception {
        this.checkServletResponse(new XsrfServiceServlet(), "POST", false, 403, XSRF_ERROR_MESSAGE);
    }

    @Test
    public void testXsrfDirectServiceAnnotationWithValidToken() throws Exception {
        this.checkServletResponse(new XsrfServiceServlet(), "POST", true, 200, OK_ERROR_MESSAGE);
    }

    private void checkServletResponse(HttpServlet pluginServlet, String requestMethod, boolean validatorResult, int expectedStatus, String expectedErrorMessage) throws Exception {
        FisheyeServletModuleContainerServlet fisheyeServlet = this.createFisheyeServlet(pluginServlet, validatorResult);
        MockHttpServletRequest request = new MockHttpServletRequest(requestMethod, "");
        MockHttpServletResponse response = new MockHttpServletResponse();
        response.setStatus(200, OK_ERROR_MESSAGE);
        fisheyeServlet.service((HttpServletRequest)request, (HttpServletResponse)response);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)expectedStatus));
        MatcherAssert.assertThat((Object)response.getErrorMessage(), (Matcher)Matchers.is((Object)expectedErrorMessage));
    }

    private FisheyeServletModuleContainerServlet createFisheyeServlet(HttpServlet pluginServlet, boolean validatorResult) throws ServletException {
        return new FisheyeServletModuleContainerServlet((ServletModuleManager)this.createModuleManager(pluginServlet), this.createTokenValidator(validatorResult));
    }

    private FisheyeServletModuleManager createModuleManager(HttpServlet pluginServlet) throws ServletException {
        FisheyeServletModuleManager moduleManager = (FisheyeServletModuleManager)Mockito.mock(FisheyeServletModuleManager.class);
        ((FisheyeServletModuleManager)Mockito.doReturn((Object)pluginServlet).when((Object)moduleManager)).getServlet(Mockito.anyString(), (ServletConfig)Mockito.any(ServletConfig.class));
        return moduleManager;
    }

    private XsrfTokenValidator createTokenValidator(boolean validatorResult) throws ServletException {
        XsrfTokenValidator tokenValidator = (XsrfTokenValidator)Mockito.mock(XsrfTokenValidator.class);
        Mockito.when((Object)tokenValidator.validateFormEncodedToken((HttpServletRequest)Mockito.any(HttpServletRequest.class))).thenReturn((Object)validatorResult);
        return tokenValidator;
    }

    static class XsrfServiceServlet
    extends HttpServlet {
        XsrfServiceServlet() {
        }

        @RequiresXsrfCheck
        protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        }
    }

    static class XsrfPostSubclass2Servlet
    extends XsrfPostSubclass1Servlet {
        XsrfPostSubclass2Servlet() {
        }
    }

    static class XsrfPostSubclass1Servlet
    extends XsrfPostServlet {
        XsrfPostSubclass1Servlet() {
        }
    }

    static class XsrfPostServlet
    extends HttpServlet {
        XsrfPostServlet() {
        }

        @RequiresXsrfCheck
        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        }
    }
}

