/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.pipeline;

import com.cenqua.fisheye.FishEyeSysProps;
import junit.framework.Assert;
import org.junit.Test;

public class PipelineThreadCountTest {
    @Test
    public void checkThreadDistributions() {
        for (int i = 0; i <= 1001; ++i) {
            int t = this.setAndReloadThreadCount(i);
            Assert.assertTrue((String)"Total thread count not in expected range", (boolean)(i < 4 ? t == 4 : (i > 1000 ? t == 1000 : t == i)));
            Assert.assertTrue((String)"At least one thread should be allocated to each phase", (FishEyeSysProps.PIPELINE_METADATA_THREAD_COUNT > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"At least one thread should be allocated to each phase", (FishEyeSysProps.PIPELINE_INDEXING_THREAD_COUNT > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"indexing thread count should be equal or less than metadata", (FishEyeSysProps.PIPELINE_METADATA_THREAD_COUNT >= FishEyeSysProps.PIPELINE_INDEXING_THREAD_COUNT ? 1 : 0) != 0);
            Assert.assertTrue((String)"Thread counts for metadata and indexing should never differ by more than 1", (Math.abs(FishEyeSysProps.PIPELINE_METADATA_THREAD_COUNT - FishEyeSysProps.PIPELINE_INDEXING_THREAD_COUNT) <= 1 ? 1 : 0) != 0);
            Assert.assertEquals((String)"Phase thread counts should sum to total thread count", (int)FishEyeSysProps.PIPELINE_THREAD_COUNT, (int)(FishEyeSysProps.PIPELINE_METADATA_THREAD_COUNT + FishEyeSysProps.PIPELINE_INDEXING_THREAD_COUNT));
        }
    }

    private int setAndReloadThreadCount(int val) {
        System.setProperty("fisheye.pipeline.threads", "" + val);
        FishEyeSysProps.reloadProperties();
        return FishEyeSysProps.PIPELINE_THREAD_COUNT;
    }
}

