/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.pipeline;

import com.atlassian.fisheye.pipeline.ChangeSetEntry;
import com.atlassian.fisheye.pipeline.PartitionedChangeSetPhaseQueues;
import com.atlassian.fisheye.pipeline.PipelinePhase;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.support.ThreadDumpHelper;
import com.cenqua.fisheye.util.ConfigurableThreadFactory;
import com.cenqua.fisheye.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class PersistentChangeSetPhaseQueuesTest {
    private PartitionedChangeSetPhaseQueues queues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSanity() throws IOException, InterruptedException {
        File tmpDir = File.createTempFile("pipeline", "tmp");
        String repo = "test";
        try {
            Assert.assertTrue((tmpDir.delete() && tmpDir.mkdir() ? 1 : 0) != 0);
            this.queues = new PartitionedChangeSetPhaseQueues(tmpDir);
            this.queues.unparkEntries("test");
            ConcurrentHashMap changesets = new ConcurrentHashMap();
            int numWorkers = 4;
            int numChangeSetsPerWorker = 250;
            int numChangeSets = numWorkers * 250;
            AtomicInteger csid = new AtomicInteger(0);
            this.runWorkersOnQueue("entryGenerator", () -> {
                for (int i = 0; i < 250; ++i) {
                    ChangeSetEntry cs = new ChangeSetEntry("test", System.currentTimeMillis() + (long)i, "" + csid.incrementAndGet());
                    changesets.put(cs, PipelinePhase.first());
                    this.queues.put(cs, PipelinePhase.first());
                }
            }, numWorkers);
            Map depths = this.queues.getQueueDepths();
            Assert.assertEquals((String)"Expected all changesets in initial queue", (long)numChangeSets, (long)((AtomicInteger)depths.get(PipelinePhase.first())).intValue());
            for (PipelinePhase phase : PipelinePhase.values()) {
                if (phase == PipelinePhase.DONE) continue;
                this.runWorkersOnQueue(phase.toString() + "PhaseProcessor", () -> {
                    try {
                        String name = Thread.currentThread().getName();
                        for (int i = 0; i < 250; ++i) {
                            ChangeSetEntry cs = this.queues.take(name, phase);
                            this.queues.updateAndRelease(name, cs, phase, phase.next());
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }, numWorkers);
                depths = this.queues.getQueueDepths();
                if (phase.next() == PipelinePhase.DONE) {
                    for (PipelinePhase p : PipelinePhase.values()) {
                        if (p == PipelinePhase.DONE) continue;
                        Assert.assertEquals((String)"Expected all changesets in state DONE", (long)0L, (long)((AtomicInteger)depths.get(p)).intValue());
                    }
                    continue;
                }
                Assert.assertEquals((String)"Expected all changesets in next queue", (long)numChangeSets, (long)((AtomicInteger)depths.get(phase.next())).intValue());
            }
        }
        finally {
            FileUtils.deleteTree((File)tmpDir);
            if (this.queues != null) {
                this.queues.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnfairPriority() throws Exception {
        File tmpDir = File.createTempFile("pipeline", "tmp");
        int changeSetsPerRepo = 10;
        try {
            Assert.assertTrue((tmpDir.delete() && tmpDir.mkdir() ? 1 : 0) != 0);
            this.queues = new PartitionedChangeSetPhaseQueues(tmpDir);
            this.queues.unparkEntries("repo1");
            this.queues.unparkEntries("repo2");
            long ts = 0L;
            for (int i = 0; i < changeSetsPerRepo; ++i) {
                ChangeSetEntry cs = new ChangeSetEntry("repo1", ts++, "A" + i);
                this.queues.put(cs, PipelinePhase.first());
                cs = new ChangeSetEntry("repo2", ts++, "B" + i);
                this.queues.put(cs, PipelinePhase.first());
            }
            Assert.assertEquals((String)"unit test is borked", (long)(changeSetsPerRepo * 2), (long)ts);
            long ts2 = ts;
            for (int i = 0; i < changeSetsPerRepo; ++i) {
                ChangeSetEntry entry = this.queues.take("foo", PipelinePhase.first());
                this.queues.updateAndRelease("foo", entry, PipelinePhase.first(), PipelinePhase.INDEXING);
                Assert.assertEquals((long)entry.getTimestamp(), (long)(--ts2));
            }
            ChangeSetEntry cs = new ChangeSetEntry("repo1", ts++, "C1");
            this.queues.put(cs, PipelinePhase.first());
            cs = this.queues.take("foo", PipelinePhase.first());
            Assert.assertEquals((String)"newest should be head of the queue", (Object)"C1", (Object)cs.getId());
            this.queues.updateAndRelease("foo", cs, PipelinePhase.first(), PipelinePhase.INDEXING);
            cs = this.queues.take("foo", PipelinePhase.INDEXING);
            Assert.assertEquals((String)"newest should be head of the queue", (Object)"C1", (Object)cs.getId());
            for (int i = 0; i < changeSetsPerRepo; ++i) {
                ChangeSetEntry entry = this.queues.take("foo", PipelinePhase.first());
                this.queues.updateAndRelease("foo", entry, PipelinePhase.first(), PipelinePhase.INDEXING);
                Assert.assertEquals((long)entry.getTimestamp(), (long)(--ts2));
            }
            long prev = Long.MAX_VALUE;
            for (int i = 0; i < changeSetsPerRepo; ++i) {
                ChangeSetEntry entry = this.queues.take("foo", PipelinePhase.INDEXING);
                Assert.assertTrue((String)("expected date order descending, but got " + entry.getTimestamp() + ">" + prev), (entry.getTimestamp() < prev ? 1 : 0) != 0);
                prev = entry.getTimestamp();
            }
        }
        finally {
            FileUtils.deleteTree((File)tmpDir);
            if (this.queues != null) {
                this.queues.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFairPriority() throws Exception {
        File tmpDir = File.createTempFile("pipeline", "tmp");
        try {
            int currentRepo;
            int i;
            Assert.assertTrue((tmpDir.delete() && tmpDir.mkdir() ? 1 : 0) != 0);
            this.queues = new PartitionedChangeSetPhaseQueues(tmpDir, true);
            int repos = 10;
            int changeSetsPerRepo = 10;
            for (i = 0; i < repos; ++i) {
                this.queues.unparkEntries("R" + i);
            }
            for (i = 0; i < changeSetsPerRepo * repos; ++i) {
                currentRepo = i / repos;
                ChangeSetEntry cs = new ChangeSetEntry("R" + currentRepo, (long)(currentRepo * 100 + i), "cs" + i);
                this.queues.put(cs, PipelinePhase.first());
            }
            for (i = 0; i < changeSetsPerRepo * repos; ++i) {
                currentRepo = i % repos;
                ChangeSetEntry entry = this.queues.take("test", PipelinePhase.first());
                Assert.assertEquals((String)"Got changeset from the wrong repo. ", (Object)("R" + currentRepo), (Object)entry.getRepository());
            }
        }
        finally {
            FileUtils.deleteTree((File)tmpDir);
            if (this.queues != null) {
                this.queues.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParkUnparkRemove() throws Exception {
        File tmpDir = File.createTempFile("pipeline", "tmp");
        int changeSetsPerRepo = 10;
        try {
            ChangeSetEntry cs;
            int i;
            Assert.assertTrue((tmpDir.delete() && tmpDir.mkdir() ? 1 : 0) != 0);
            this.queues = new PartitionedChangeSetPhaseQueues(tmpDir);
            Map queueDepths = this.queues.getQueueDepths();
            this.queues.unparkEntries("repo1");
            this.queues.unparkEntries("repo2");
            long ts = System.currentTimeMillis();
            for (i = 0; i < changeSetsPerRepo; ++i) {
                cs = new ChangeSetEntry("repo1", ts++, "A" + i);
                this.queues.put(cs, PipelinePhase.first());
            }
            for (i = 0; i < changeSetsPerRepo; ++i) {
                cs = new ChangeSetEntry("repo2", ts++, "B" + i);
                this.queues.put(cs, PipelinePhase.first());
            }
            Assert.assertEquals((String)"Queue depths are borked", (long)(changeSetsPerRepo * 2), (long)((AtomicInteger)queueDepths.get(PipelinePhase.first())).intValue());
            Assert.assertEquals((String)"changesets from repo2 should be at the head of the queue", (Object)"repo2", (Object)this.queues.take("worker1", PipelinePhase.first()).getRepository());
            this.queues.parkEntries("repo2");
            Assert.assertEquals((String)"Queue depths are borked", (long)changeSetsPerRepo, (long)((AtomicInteger)queueDepths.get(PipelinePhase.first())).intValue());
            Assert.assertEquals((String)"changesets from repo1 should be at the head of the queue", (Object)"repo1", (Object)this.queues.take("worker1", PipelinePhase.first()).getRepository());
            this.queues.unparkEntries("repo2");
            Assert.assertEquals((String)"changesets from repo2 should be at the head of the queue", (Object)"repo2", (Object)this.queues.take("worker1", PipelinePhase.first()).getRepository());
            Assert.assertEquals((String)"Queue depths are borked", (long)(changeSetsPerRepo * 2), (long)((AtomicInteger)queueDepths.get(PipelinePhase.first())).intValue());
            this.queues.parkEntries("repo2");
            Assert.assertEquals((String)"Queue depths are borked", (long)changeSetsPerRepo, (long)((AtomicInteger)queueDepths.get(PipelinePhase.first())).intValue());
            this.queues.removeEntries("repo2", true);
            Assert.assertEquals((String)"changesets from repo1 should be at the head of the queue", (Object)"repo1", (Object)this.queues.take("worker1", PipelinePhase.first()).getRepository());
            Assert.assertEquals((String)"Queue depths are borked", (long)changeSetsPerRepo, (long)((AtomicInteger)queueDepths.get(PipelinePhase.first())).intValue());
        }
        finally {
            FileUtils.deleteTree((File)tmpDir);
            if (this.queues != null) {
                this.queues.shutdown();
            }
        }
    }

    private void runWorkersOnQueue(String workerIdBase, Runnable runnable, int numWorkers) throws InterruptedException, IOException {
        ExecutorService workers = Executors.newFixedThreadPool(numWorkers, (ThreadFactory)new ConfigurableThreadFactory(workerIdBase, true));
        CountDownLatch workerLatch = new CountDownLatch(numWorkers);
        for (int w = 0; w < numWorkers; ++w) {
            workers.execute(() -> {
                runnable.run();
                Logs.APP_LOG.info((Object)("Finishing on thread " + Thread.currentThread().getName()));
                workerLatch.countDown();
            });
        }
        if (!workerLatch.await(5L, TimeUnit.MINUTES)) {
            StringBuilder threaddump = new StringBuilder();
            ThreadDumpHelper.getThreadDump((Appendable)threaddump);
            Logs.APP_LOG.error((Object)"Dumping threads: ");
            Logs.APP_LOG.error((Object)threaddump);
            Assert.fail((String)("Expected " + numWorkers + " workers to finish, got " + ((long)numWorkers - workerLatch.getCount())));
        }
        workers.shutdownNow();
    }
}

