/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.pipeline;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.util.ListIterable;
import com.atlassian.fisheye.event.RepositoryStartingEvent;
import com.atlassian.fisheye.event.RepositoryStartingEventImpl;
import com.atlassian.fisheye.pipeline.ChangeSetEntry;
import com.atlassian.fisheye.pipeline.ChangeSetPhaseQueues;
import com.atlassian.fisheye.pipeline.DefaultChangeSetPipeline;
import com.atlassian.fisheye.pipeline.PartitionedChangeSetPhaseQueues;
import com.atlassian.fisheye.pipeline.PhaseProcessor;
import com.atlassian.fisheye.pipeline.PipelinePhase;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DummyRevisionCache;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.support.ThreadDumpHelper;
import com.cenqua.fisheye.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ChangeSetPipelineTest {
    @Mock
    private ChangeSetPhaseQueues mockQueue;
    @Mock
    private PhaseProcessor mockProcessor;
    @Mock
    private EventPublisher mockEventPublisher;
    @Mock
    private RepositoryManager repositoryManager;
    @Mock
    private RepositoryHandle repositoryHandle;
    private DefaultChangeSetPipeline pipeline;
    private RevisionCache revCache = new DummyRevisionCache(){

        @Override
        public ListIterable<ChangeSet> getChangeSetsInState(ChangeSetIndexingState state) {
            return ListIterable.UTILS.emptyListIterable();
        }

        @Override
        public FileRevision findFileRevision(Path path, String revision) throws DbException {
            return null;
        }
    };

    @Test
    public void testPhaseProcessorRegistration() {
        this.pipeline = new DefaultChangeSetPipeline(this.mockQueue, this.mockEventPublisher);
        try {
            this.pipeline.startup(this.repositoryManager);
            Assert.fail((String)"Startup is not allowed without phase processors");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.pipeline.registerPhaseProcessor(PipelinePhase.DONE, this.mockProcessor, 1);
            Assert.fail((String)"Phase processor not allowed for the DONE phase");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.pipeline.registerPhaseProcessor(PipelinePhase.first(), this.mockProcessor, 1);
            this.pipeline.registerPhaseProcessor(PipelinePhase.first(), this.mockProcessor, 1);
            Assert.fail((String)"Duplicate phase processors are not allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.pipeline.startup(this.repositoryManager);
            Assert.fail((String)"Startup is not allowed without sufficient phase processors");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLifeCycle() throws Exception {
        this.pipeline = new DefaultChangeSetPipeline(this.mockQueue, this.mockEventPublisher);
        Mockito.when((Object)this.mockQueue.take(Matchers.anyString(), (PipelinePhase)Matchers.any())).thenReturn((Object)new ChangeSetEntry("rep", 1L, "ABC123"));
        Mockito.when((Object)this.mockProcessor.processChangesetEntry((ChangeSetEntry)Matchers.any(ChangeSetEntry.class))).thenReturn((Object)true);
        for (PipelinePhase phase : PipelinePhase.values()) {
            if (phase == PipelinePhase.DONE) continue;
            this.pipeline.registerPhaseProcessor(phase, this.mockProcessor, 1);
        }
        try {
            this.pipeline.shutdown();
            Assert.fail((String)"Shutdown is not allowed before startup");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.pipeline.startup(this.repositoryManager);
            try {
                this.pipeline.startup(this.repositoryManager);
                Assert.fail((String)"Startup is not allowed when already started");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        finally {
            this.pipeline.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFullPipelineRun() throws IOException, InterruptedException, RepositoryHandle.StateException {
        String repoName = "test";
        File tmpDir = File.createTempFile("pipeline", "tmp");
        try {
            Assert.assertTrue((tmpDir.delete() && tmpDir.mkdir() ? 1 : 0) != 0);
            this.pipeline = new DefaultChangeSetPipeline((ChangeSetPhaseQueues)new PartitionedChangeSetPhaseQueues(tmpDir), this.mockEventPublisher);
            ConcurrentHashMap<ChangeSetEntry, PipelinePhase> changesets = new ConcurrentHashMap<ChangeSetEntry, PipelinePhase>();
            int numChangeSets = 1000;
            int expectedProcessInvocations = 1000 * (PipelinePhase.values().length - 1);
            CountDownLatch csLatch = new CountDownLatch(expectedProcessInvocations);
            float errorRate = 0.25f;
            LinkedList errors = new LinkedList();
            for (PipelinePhase phase : PipelinePhase.values()) {
                if (phase == PipelinePhase.DONE) continue;
                this.pipeline.registerPhaseProcessor(phase, entry -> {
                    if (Math.random() < 0.25) {
                        System.out.println("Simulating error in processor");
                        throw new RuntimeException("Simulated transient failure");
                    }
                    Thread.sleep((int)(Math.random() * 100.0));
                    System.out.println(Thread.currentThread().getName() + " csid " + entry.getId() + " processing " + phase + ", next = " + phase.next());
                    if (changesets.get(entry) != phase) {
                        errors.add("processor for phase " + phase + " found changeset " + entry.getId() + " in phase " + changesets.get(entry));
                    } else {
                        changesets.put(entry, phase.next());
                    }
                    csLatch.countDown();
                    return true;
                }, 8);
            }
            RepositoryEngine repositoryEngine = (RepositoryEngine)Mockito.mock(RepositoryEngine.class);
            Mockito.when((Object)repositoryEngine.getRevisionCache()).thenReturn((Object)this.revCache);
            Mockito.when((Object)this.repositoryHandle.acquireEngine()).thenReturn((Object)repositoryEngine);
            Mockito.when((Object)this.repositoryHandle.isPipelined()).thenReturn((Object)true);
            Mockito.when((Object)this.repositoryManager.getRepository(Matchers.anyString())).thenReturn((Object)this.repositoryHandle);
            this.pipeline.startup(this.repositoryManager);
            this.pipeline.onRepositoryStarting((RepositoryStartingEvent)new RepositoryStartingEventImpl("test", false));
            for (int i = 0; i < 1000; ++i) {
                ChangeSetEntry cs = new ChangeSetEntry("test", System.currentTimeMillis(), "" + i);
                changesets.put(cs, PipelinePhase.first());
                this.pipeline.put(cs);
                Thread.sleep(10L);
            }
            if (!csLatch.await(5L, TimeUnit.MINUTES)) {
                StringBuilder threadDump = new StringBuilder();
                ThreadDumpHelper.getThreadDump((Appendable)threadDump);
                Logs.APP_LOG.error((Object)"Dumping threads: ");
                Logs.APP_LOG.error((Object)threadDump);
                Assert.fail((String)("Expected " + expectedProcessInvocations + " process invocations, got " + ((long)expectedProcessInvocations - csLatch.getCount())));
            }
            if (errors.size() > 0) {
                for (String error : errors) {
                    System.err.println(error);
                }
                Assert.assertThat((String)"Errors detected in pipeline processing", errors, (Matcher)org.hamcrest.Matchers.empty());
            }
            for (PipelinePhase phase : changesets.values()) {
                Assert.assertEquals((Object)phase, (Object)PipelinePhase.DONE);
            }
            Map queueDepths = this.pipeline.getQueueDepths();
            boolean queueDepthsZeroed = false;
            for (int i = 0; i < 20; ++i) {
                queueDepthsZeroed = true;
                for (PipelinePhase phase : PipelinePhase.values()) {
                    if (phase == PipelinePhase.DONE || ((AtomicInteger)queueDepths.get(phase)).intValue() <= 0) continue;
                    queueDepthsZeroed = false;
                    break;
                }
                if (queueDepthsZeroed) break;
                Thread.sleep(10L);
            }
            Assert.assertTrue((String)"Queues depths never reached zero", (boolean)queueDepthsZeroed);
        }
        finally {
            if (this.pipeline != null) {
                this.pipeline.dumpPipelineState();
                this.pipeline.shutdown();
            }
            FileUtils.deleteTree((File)tmpDir);
        }
    }
}

